/*
 * Decompiled with CFR 0.152.
 */
package siovanus;

import avis.base.AException;
import avis.base.Avis;
import avis.input.AInputDevice;
import avis.motion.Drivant;
import avis.motion.MMachine;
import avis.motion.MMachineSpec;
import avis.session.AScenario;
import avis.session.ASession;
import avis.video.AScreen;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import siovanus.SGroup;
import siovanus.SSession;
import siovanus.Siovanus;
import siovanus.drivant.AviatorDrivant;
import siovanus.drivant.SEmittableDrivant;
import siovanus.drivant.aviator.Aviator;
import siovanus.drivant.aviator.BomberAviator;
import siovanus.drivant.aviator.ChasingAviator;
import siovanus.drivant.aviator.GunAviator;
import siovanus.drivant.aviator.MobAviator;
import siovanus.drivant.aviator.SmartAviator;
import siovanus.drivant.aviator.UserAviator;
import siovanus.drivant.aviator.VesselAviator;
import siovanus.spec.SGageSpriteSpec;
import siovanus.sprite.SGageSprite;

public abstract class SScenario
extends AScenario {
    private int score = 0;
    protected SSession ssession;
    protected AviatorDrivant userDrivant;
    private Map<String, Integer> pointMap;
    protected SortedMap<String, Integer> scoreMap;
    protected boolean passed;
    public static final String BGM_CHOPIN_OP39 = "bgm/chopin_op39.mid";
    public static final String BGM_CARMEN1_2 = "bgm/bizet_carmen_1_2.mid";
    public static final String BGM_LISZT143 = "bgm/liszt_s143.mid";
    public static final String BGM_WALKURENRITT = "bgm/wagner_walkurenritt.mid";
    public static final String BGM_IMPROMPTU_4 = "bgm/Schubert_Impromptus_D899_No_4.mid";
    public static final String BGM_QUARTET_10 = "bgm/Quartet_10_mvt3.MID";
    public static final String BGM_SYM9_1 = "bgm/Sym_9_First_Movement.mid";
    public static final String BGM_SYM9_4 = "bgm/Sym_9_Fourth_Movement.mid";
    public static final String BGM_BWV1068_2 = "bgm/jsbach_bwv1068_2.mid";

    @Override
    public void handleCollision(Drivant d1, Drivant d2, double distance) {
        Avis.logger().debug("Collision detected:d1=<" + d1 + ">,d2=<" + d2 + ">");
        if (d1.isValid() && d2.isValid()) {
            this._handleCollision(d1, d2, distance);
            this._handleCollision(d2, d1, distance);
        }
        this.ssession.updateLife(((AviatorDrivant.AviatorParameters)this.userDrivant.snapshot()).life);
        this.ssession.updateScore(this.score);
    }

    private void _handleCollision(Drivant d1, Drivant d2, double distance) {
        if (d1 instanceof AviatorDrivant) {
            AviatorDrivant.AviatorParameters p1 = (AviatorDrivant.AviatorParameters)d1.rollbackSegment();
            if (--p1.life < 0) {
                d1.invalidate();
                this.score += this.calcScore(d1);
                if ((d1.groupId() == SGroup.Enemy_Aerial || d1.groupId() == SGroup.Enemy_Surface) && d1.label() != null) {
                    Integer s = (Integer)this.scoreMap.get(d1.label());
                    this.scoreMap.put(d1.label(), s == null ? 1 : s + 1);
                }
                this.explosion(d1);
            }
        } else if (d1 instanceof SEmittableDrivant && d2 instanceof AviatorDrivant) {
            d1.invalidate();
            this.minorExplosion(d1);
        }
    }

    protected int calcScore(Drivant drivant) {
        if (drivant.groupId() == SGroup.Enemy_Aerial || drivant.groupId() == SGroup.Enemy_Surface) {
            Integer score = this.pointMap.get(drivant.label());
            return score != null ? score : 0;
        }
        return 0;
    }

    @Override
    public boolean collides(Drivant d1, Drivant d2, double distance) {
        return distance < (d1.width() + d2.width() + d1.height() + d2.height()) / 2.0;
    }

    @Override
    public void handleInteraction(Drivant d1, Drivant d2, double distance) {
        if (d1 instanceof AviatorDrivant && d2 instanceof AviatorDrivant) {
            ((AviatorDrivant)d1).notify((AviatorDrivant)d2, distance);
            ((AviatorDrivant)d2).notify((AviatorDrivant)d1, distance);
        }
    }

    public void explosion(Drivant drivant) {
        this.ssession.explosion(this, drivant);
        this.ssession.soundEffect("sound/explosion02.wav");
    }

    public void minorExplosion(Drivant drivant) {
        this.ssession.minorExplosion(this, drivant);
    }

    @Override
    public void init(ASession session) throws AException {
        this.ssession = (SSession)session;
        this.pointMap = new HashMap<String, Integer>();
        this.pointMap.put(null, 0);
        this.pointMap.put("Avenger", 100);
        this.pointMap.put("F4U", 200);
        this.pointMap.put("P51D", 500);
        this.pointMap.put("B17", 500);
        this.pointMap.put("B29", 800);
        this.pointMap.put("USS New Jersey(GUN)", 800);
        this.pointMap.put("USS New Jersey", 9000);
        this.scoreMap = new TreeMap<String, Integer>();
    }

    public void message(String message, int x, int y, Color color, float f) {
        this.ssession.message(message, x, y, color, f);
    }

    public void message(String message, int x, int y, Color color, float f, int duration) {
        int ticks = 1000 * duration / this.ssession.interval();
        this.ssession.message(message, x, y, color, f, ticks);
    }

    public void title(String message, int y, Color c, float fontSize, int durationToDisplay) {
        int ticks = 1000 * durationToDisplay / this.ssession.interval();
        this.ssession.message(message, -1, y, c, fontSize, ticks, "EffectMessage");
    }

    public void creditMessage(String message, int y, Color c, float fontSize, int durationToDisplay) {
        int ticks = 1000 * durationToDisplay / this.ssession.interval();
        this.ssession.message(message, -1, y, c, fontSize, ticks, "CreditMessage");
    }

    @Override
    public void invalidated(Drivant drivant) {
    }

    @Override
    public void registered(Drivant drivant) {
    }

    @Override
    public void emit(Drivant emitter, MMachineSpec emittable) {
        this.shot(emitter, emittable);
    }

    protected void shot(Drivant emitter, MMachineSpec emittable) {
        MMachine mmachine = emittable.createMMachine(350, emitter.x(), emitter.y(), emitter.direction(), -1.0, emitter.groupId(), emitter);
        mmachine.drivant().addObserver(this);
    }

    public AInputDevice stick() {
        return this.ssession.stick();
    }

    public AviatorDrivant userDrivant() {
        return this.userDrivant;
    }

    protected void createNewDummy() {
        MMachine mmachine = Siovanus.dummySpec.createMMachine(900, 0.0, 0.0, 0, 0.0, SGroup.Enemy_Aerial, new ChasingAviator());
        mmachine.drivant().addObserver(this);
    }

    protected void createNewEnemy_Avenger(double x, double y, int direction, boolean smart, Aviator activatedAviator) {
        Aviator aviator = smart ? new SmartAviator() : (activatedAviator != null ? new MobAviator(activatedAviator) : new MobAviator());
        MMachine mmachine = Siovanus.avengerSpec.createMMachine(500, x, y, direction, 1.0, SGroup.Enemy_Aerial, aviator);
        mmachine.drivant().addObserver(this);
    }

    protected void createNewEnemy_Avenger(double x, double y, int direction, boolean smart) {
        this.createNewEnemy_Avenger(x, y, direction, smart, null);
    }

    protected void createNewEnemy_Avenger(double x, double y, int direction) {
        this.createNewEnemy_Avenger(x, y, direction, false, null);
    }

    protected void createNewEnemy_Avenger(double x, double y, int direction, Aviator activatedAviator) {
        this.createNewEnemy_Avenger(x, y, direction, false, activatedAviator);
    }

    protected void createNewEnemy_P51D(double x, double y, int direction) {
        MMachine mmachine = Siovanus.p51dSpec.createMMachine(400, x, y, direction, 1.0, SGroup.Enemy_Aerial, new SmartAviator());
        mmachine.drivant().addObserver(this);
    }

    protected void createNewEnemy_F4U(double x, double y, int direction) {
        this.createNewEnemy_F4U(x, y, direction, false, null);
    }

    protected void createNewEnemy_F4U(double x, double y, int direction, boolean smart) {
        this.createNewEnemy_F4U(x, y, direction, smart, null);
    }

    protected void createNewEnemy_F4U(double x, double y, int direction, boolean smart, Aviator activatedAviator) {
        Aviator aviator = smart ? new SmartAviator() : (activatedAviator != null ? new MobAviator(activatedAviator) : new MobAviator());
        MMachine mmachine = Siovanus.f4uSpec.createMMachine(400, x, y, direction, 1.0, SGroup.Enemy_Aerial, aviator);
        mmachine.drivant().addObserver(this);
    }

    protected Drivant createNewEnemy_USSNewJersey(double x, double y) {
        MMachine mmachine = Siovanus.ussNewJerseySpec.createMMachine(100, x, y, 64, 1.0, SGroup.Enemy_Surface, new VesselAviator());
        mmachine.drivant().addObserver(this);
        return mmachine.drivant();
    }

    void createNewEnemy_USSNewJersey_Gun(Drivant parent, double r, int th, int direction, int rightEnd, int leftEnd) {
        MMachine mmachine = Siovanus.ussNewJerseyGunSpec.createMMachine(150, 0.0, 0.0, direction, 1.0, SGroup.Enemy_Surface, new GunAviator(parent, r, th, direction, rightEnd, leftEnd));
        mmachine.drivant().addObserver(this);
    }

    protected void createNewEnemy_B17(double x, double y, int direction) {
        MMachine mmachine = Siovanus.b17Spec.createMMachine(400, x, y, direction, 1.0, SGroup.Enemy_Aerial, new MobAviator(new BomberAviator()));
        mmachine.drivant().addObserver(this);
    }

    protected void createNewEnemy_B29(double x, double y, int direction) {
        MMachine mmachine = Siovanus.b29Spec.createMMachine(400, x, y, direction, 1.0, SGroup.Enemy_Aerial, new MobAviator(new BomberAviator()));
        mmachine.drivant().addObserver(this);
    }

    protected void createNewFriend_Zero(double x, double y, int direction) {
        MMachine mmachine = Siovanus.zeroSpec.createMMachine(400, x, y, direction, 1.0, SGroup.Player_Aerial, new SmartAviator());
        ((AviatorDrivant)mmachine.drivant()).target(this.userDrivant);
        mmachine.drivant().addObserver(this);
    }

    protected void createNewUser_Ki84(double x, double y, int direction) {
        Aviator userAviator = this.createUserAviator();
        MMachine mmachine = Siovanus.ki84Spec.createMMachine(900, x, y, direction, 1.0, SGroup.Player_Aerial, userAviator);
        this.userDrivant = (AviatorDrivant)mmachine.drivant();
        this.userDrivant.addObserver(this);
        mmachine.drivant().addObserver(this);
        this.ssession.userDrivantCreated(this.userDrivant);
        AScreen screen = this.ssession.screen();
        SGageSpriteSpec p = new SGageSpriteSpec(userAviator);
        SGageSprite gage = (SGageSprite)p.createSprite(1000);
        screen.foregroundPlane().attach(gage);
        gage.put(screen.getWidth() - p.width() - 20, screen.getHeight() - 192 - p.height() - 30);
        gage.visible(true);
    }

    protected Aviator createUserAviator() {
        UserAviator userAviator = new UserAviator(this.stick());
        return userAviator;
    }

    protected void createNewFriend_Ki84(double x, double y, int direction) {
        MMachine mmachine = Siovanus.ki84Spec.createMMachine(900, x, y, direction, 1.0, SGroup.Player_Aerial, new SmartAviator());
        ((AviatorDrivant)mmachine.drivant()).target(this.userDrivant);
        mmachine.drivant().addObserver(this);
    }

    public abstract String bgm();

    @Override
    public String backgroundImageResource() {
        return "image/background/bg00.bmp";
    }

    @Override
    public AScenario next() {
        SScenario ret = (SScenario)super.next();
        if (ret != null) {
            ret.score(this.score());
        }
        return ret;
    }

    public int score() {
        return this.score;
    }

    public void score(int score) {
        this.score = score;
    }

    public ASession session() {
        return this.ssession;
    }

    @Override
    public void reset() {
        this.score(0);
        this.scoreMap.clear();
    }

    public double initialX() {
        return 512.0;
    }

    public double initialDirection() {
        return 64.0;
    }

    public double initialY() {
        return -600.0;
    }

    public abstract String getBackgroundResourceName();

    public boolean isPassed() {
        return this.passed;
    }

    public abstract void instructionAfterScenario();
}

