/*
 * Decompiled with CFR 0.152.
 */
package siovanus;

import avis.base.AException;
import avis.base.AResourceLoader;
import avis.base.Avis;
import avis.base.Configuration;
import avis.input.AInputDevice;
import avis.motion.Drivant;
import avis.motion.MotionController;
import avis.session.AScenario;
import avis.session.AScenarioEvent;
import avis.session.ASession;
import avis.sprite.AMessageSprite;
import avis.sprite.ASprite;
import avis.video.APlane;
import avis.video.AScreen;
import avis.video.AViewport;
import java.awt.Color;
import java.io.IOException;
import siovanus.SScenario;
import siovanus.SScenarioStatus;
import siovanus.SStage00Scenario;
import siovanus.SStage01Scenario;
import siovanus.SStage02Scenario;
import siovanus.SStage03Scenario;
import siovanus.SStage04Scenario;
import siovanus.SStage05Scenario;
import siovanus.SStage06Scenario;
import siovanus.SStage07Scenario;
import siovanus.SStage08Scenario;
import siovanus.SStage09Scenario;
import siovanus.SStage99Scenario;
import siovanus.SStageScenario;
import siovanus.Siovanus;
import siovanus.drivant.AviatorDrivant;
import siovanus.spec.SRadarSpriteSpec;
import siovanus.sprite.SRadarSprite;
import siovanus.sprite.SShotSprite;

public class SSession
extends ASession {
    public static final String SE_EXPLOSION = "sound/explosion02.wav";
    public static final String SE_SHOT = "sound/gun02.wav";
    private static final int TRAIL_SIZE = 12;
    private int _dx;
    private int _dy;
    private double bgOriginX;
    private double bgOriginY;
    private AMessageSprite lifeSprite;
    private AMessageSprite scoreSprite;
    private int trailIndex;
    private double[] trailTheta = new double[12];
    private double[] trailX = new double[12];
    private double[] trailY = new double[12];
    private double viewMaxX;
    private double viewMaxY;
    private double viewMinX;
    private double viewMinY;
    private Drivant drivant = null;
    private static final double CAMERA_BIAS = 200.0;
    int remainingTicksToSuspend = -1;
    private ASprite blurSprite;
    private SScenarioStatus scenarioStatus;
    private double initialX;
    private double initialY;
    private double initialDirection;
    private State pauseState;
    private State runningState;
    private State currentState;

    public static void main(String[] args) throws Exception {
        String[] nargs = new String[args.length + 1];
        System.arraycopy(args, 0, nargs, 1, args.length);
        nargs[0] = "-session=siovanus.SSession";
        ASession.main(nargs);
    }

    private void loadRadar(AScreen screen, MotionController controller) {
        SRadarSpriteSpec p = new SRadarSpriteSpec(controller, screen.backgroundPlane());
        SRadarSprite radar = (SRadarSprite)p.createSprite(1000);
        screen.foregroundPlane().attach(radar);
        radar.put(screen.getWidth() - p.width() - 20, screen.getHeight() - p.height() - 20);
        radar.visible(true);
        this.scoreSprite = screen.message("Score:-", 20, 50, Color.red, 16.0f);
        this.lifeSprite = screen.message("Life:-", 20, 70, Color.red, 16.0f);
    }

    @Override
    protected void action(AScenario scenario) throws AException {
        this.currentState.action(scenario);
    }

    @Override
    protected void afterAction(AScenario scenario) throws AException {
        this.currentState.afterAction(scenario);
        APlane backgroundPlane = this.screen.backgroundPlane();
        int viewIndex = (this.trailIndex + 1) % 12;
        AViewport viewport = backgroundPlane.viewport();
        viewport.center(Math.min(this.viewMaxX, Math.max(this.viewMinX, this.trailX[viewIndex] + this.bgOriginX)), Math.min(this.viewMaxY, Math.max(this.viewMinY, -this.trailY[viewIndex] + this.bgOriginY)), (this.trailTheta[viewIndex] - 64.0) % 256.0);
        ++this.trailIndex;
        this.trailIndex %= 12;
        if (this.drivant != null) {
            this.trailX[this.trailIndex] = this.drivant.x() + Avis.cos(this.drivant.direction()) * 200.0;
            this.trailY[this.trailIndex] = this.drivant.y() + Avis.sin(this.drivant.direction()) * 200.0;
            this.trailTheta[this.trailIndex] = this.drivant.direction();
        } else {
            this.trailX[this.trailIndex] = this.initialX;
            this.trailY[this.trailIndex] = this.initialY;
            this.trailTheta[this.trailIndex] = this.initialDirection;
        }
        this._dx = (int)(this.bgOriginX - viewport.x() + backgroundPlane.width() / 2.0);
        this._dy = (int)(this.bgOriginY - viewport.y() + backgroundPlane.height() / 2.0);
    }

    @Override
    protected void beforeAction(AScenario scenario) throws AException {
        this.currentState.beforeAction(scenario);
    }

    @Override
    protected void afterRun(AScenario scenario) {
        this.getBgmManager().stop();
        this.getSoundManager().terminate();
    }

    @Override
    protected void aftetrLayout() {
    }

    @Override
    protected void afterTerminate(AScenario scenario) {
    }

    @Override
    protected String backgroundImageResourceName() {
        return this.scenario.backgroundImageResource();
    }

    @Override
    protected void beforeLayout() {
    }

    @Override
    protected void beforeRun(AScenario scenario) {
        this.start();
    }

    @Override
    protected String[] bgmResources() {
        return new String[]{"bgm/chopin_op39.mid", "bgm/bizet_carmen_1_2.mid", "bgm/liszt_s143.mid", "bgm/wagner_walkurenritt.mid", "bgm/Schubert_Impromptus_D899_No_4.mid", "bgm/Quartet_10_mvt3.MID", "bgm/Sym_9_First_Movement.mid", "bgm/Sym_9_Fourth_Movement.mid", "bgm/jsbach_bwv1068_2.mid"};
    }

    private void calcurateBgOrigin() {
        APlane backgroundPlane = this.screen.backgroundPlane();
        this.bgOriginX = backgroundPlane.background().imageWidth() / 2.0;
        this.bgOriginY = backgroundPlane.background().imageHeight() / 2.0;
    }

    public void userDrivantCreated(Drivant userDrivant) {
        int i = 0;
        while (i < 12) {
            this.trailX[i] = userDrivant.x() + Avis.cos(userDrivant.direction()) * 200.0;
            this.trailY[i] = userDrivant.y() + Avis.sin(userDrivant.direction()) * 200.0;
            this.trailTheta[i] = userDrivant.direction();
            ++i;
        }
        this.drivant = userDrivant;
    }

    @Override
    protected AScenario createDefaultScenario() throws AException {
        SStage01Scenario ret = new SStage01Scenario();
        ((AScenario)ret).init(this);
        return ret;
    }

    public void explosion(AScenario scenario, Drivant drivant) {
        if (drivant instanceof AviatorDrivant) {
            Siovanus.explosionSpec.createMMachine(1000, drivant.x(), drivant.y(), drivant.direction(), drivant.velocity(), null, (AviatorDrivant)drivant);
        } else {
            Siovanus.explosionSpec.createMMachine(1000, drivant.x(), drivant.y(), drivant.direction(), drivant.velocity(), null, null);
        }
    }

    public void minorExplosion(AScenario scenario, Drivant drivant) {
        if (drivant instanceof AviatorDrivant) {
            Siovanus.minorExplosionSpec.createMMachine(1000, drivant.x(), drivant.y(), drivant.direction(), drivant.velocity(), null, (AviatorDrivant)drivant);
        } else {
            Siovanus.minorExplosionSpec.createMMachine(1000, drivant.x(), drivant.y(), drivant.direction(), drivant.velocity(), null, null);
        }
    }

    @Override
    public void layout(ASprite sprite, Drivant drivant) {
        int x = (int)drivant.x() + this._dx;
        int y = (int)(-drivant.y()) + this._dy;
        sprite.put(x, y, drivant.viewDirection());
        sprite.pattern((int)drivant.bank() / sprite.spec().patternDenominator());
    }

    public AMessageSprite message(String message, int x, int y, Color color, float f) {
        return this.screen.message(message, x, y, color, f);
    }

    public void message(String message, int x, int y, Color color, float f, int durationToDisplay) {
        this.screen.message(message, x, y, color, f, durationToDisplay);
    }

    public void message(String message, int x, int y, Color color, float f, int durationToDisplay, String specName) {
        this.screen.message(message, x, y, color, f, durationToDisplay, specName);
    }

    @Override
    protected String[] soundEffectResources() {
        return new String[]{SE_SHOT, SE_EXPLOSION};
    }

    public void updateLife(int life) {
        this.lifeSprite.message("Life:" + (life < 0 ? 0 : life));
    }

    public void updateScore(int score) {
        this.scoreSprite.message("Score:" + score);
    }

    private void updateViewBoundaries(APlane plane) {
        double w2 = plane.width() * plane.width();
        double h2 = plane.height() * plane.height();
        double r = Math.sqrt(w2 + h2);
        double sin = plane.height() / r;
        double cos = plane.width() / r;
        double marginRatio = Math.max(sin, cos);
        this.viewMinX = Double.MIN_VALUE;
        this.viewMaxX = Double.MAX_VALUE;
        this.viewMinY = Double.MIN_VALUE;
        this.viewMaxY = Double.MAX_VALUE;
        double x1 = r * marginRatio * plane.viewport().ratio() + 300.0;
        double x2 = plane.background().imageWidth() - x1;
        double y1 = r * marginRatio * plane.viewport().ratio() + 300.0;
        double y2 = plane.background().imageHeight() - y1;
        this.viewMinX = Math.min(x1, x2);
        this.viewMaxX = Math.max(x1, x2);
        this.viewMinY = Math.min(y1, y2);
        this.viewMaxY = Math.max(y1, y2);
    }

    public void suspend(int ticks) {
        try {
            this.blurSprite = this.screen.createSprite(this.screen.foregroundPlane(), "DefaultBlur", 2000);
            this.blurSprite.put(0, 0);
        }
        catch (AException aException) {
            // empty catch block
        }
        this.remainingTicksToSuspend = ticks;
    }

    public SScenarioStatus scenarioFinished(SScenarioStatus scenarioStatus) {
        if (this.scenarioStatus == null) {
            this.scenarioStatus = scenarioStatus;
            this.suspend(50);
        }
        return this.scenarioStatus;
    }

    public void pause() {
        this.currentState(this.pauseState);
    }

    public void start() {
        this.currentState(this.runningState);
        this.getBgmManager().play(((SScenario)this.scenario).bgm());
        this.remainingTicksToSuspend = -1;
        if (this.blurSprite != null) {
            this.blurSprite.dispose();
        }
        this.scenarioStatus = null;
    }

    @Override
    protected AScenario createScenario() {
        SStage00Scenario cur;
        SStage00Scenario first;
        SStageScenario last;
        SStage00Scenario sStage00Scenario = last = (first = (cur = new SStage00Scenario()));
        last = new SStage01Scenario();
        sStage00Scenario.append(last);
        SStageScenario sStageScenario = last;
        last = new SStage02Scenario();
        sStageScenario.append(last);
        SStageScenario sStageScenario2 = last;
        last = new SStage03Scenario();
        sStageScenario2.append(last);
        SStageScenario sStageScenario3 = last;
        last = new SStage04Scenario();
        sStageScenario3.append(last);
        SStageScenario sStageScenario4 = last;
        last = new SStage05Scenario();
        sStageScenario4.append(last);
        SStageScenario sStageScenario5 = last;
        last = new SStage06Scenario();
        sStageScenario5.append(last);
        SStageScenario sStageScenario6 = last;
        last = new SStage07Scenario();
        sStageScenario6.append(last);
        SStageScenario sStageScenario7 = last;
        last = new SStage08Scenario();
        sStageScenario7.append(last);
        SStageScenario sStageScenario8 = last;
        last = new SStage09Scenario();
        sStageScenario8.append(last);
        SStageScenario sStageScenario9 = last;
        last = new SStage99Scenario();
        sStageScenario9.append(last);
        return cur;
    }

    @Override
    protected void init(AScenario scenario) throws AException {
        Avis.logger().info("Scenario initialization process started (free=<" + Runtime.getRuntime().freeMemory() + ">, memory=<" + Runtime.getRuntime().maxMemory() + ">");
        System.gc();
        super.init(scenario);
        this.loadRadar(this.screen, this.controller);
        Avis.logger().info("                                       (free=<" + Runtime.getRuntime().freeMemory() + ">, memory=<" + Runtime.getRuntime().maxMemory() + ">");
        SScenario sscenario = (SScenario)scenario;
        this.initialX = sscenario.initialX();
        this.initialY = sscenario.initialY();
        this.initialDirection = sscenario.initialDirection();
        String bgResourceName = sscenario.getBackgroundResourceName();
        double ratio = 4.0;
        if (Configuration.bgQualityMode == Configuration.BgQualityMode.LOW) {
            int index = bgResourceName.lastIndexOf(47);
            String filename = bgResourceName.substring(index + 1);
            bgResourceName = String.valueOf(bgResourceName.substring(0, index + 1)) + "lq." + filename;
            ratio = 8.0;
        }
        this.screen.backgroundPlane().background().load(bgResourceName);
        this.screen.backgroundPlane().viewport().zoom(ratio);
        this.updateViewBoundaries(this.screen.backgroundPlane());
        this.calcurateBgOrigin();
        System.gc();
        this.pauseState = this.createPauseState();
        this.runningState = this.createRunningState();
        Avis.logger().statistics("GC result:free/total/max=<" + Avis.format(Runtime.getRuntime().freeMemory()) + "[B]/" + Avis.format(Runtime.getRuntime().totalMemory()) + "[B]/" + Avis.format(Runtime.getRuntime().maxMemory()) + "[B]>");
    }

    public State currenState() {
        return this.currentState;
    }

    public void currentState(State state) {
        this.currentState = state;
    }

    protected State createPauseState() {
        return new SPauseState(this);
    }

    protected State createRunningState() {
        return new SRunningState(this);
    }

    @Override
    public AResourceLoader createResourceLoader() {
        return new AResourceLoader(){

            @Override
            public void loadResources() throws AException {
                Siovanus.load(SSession.this.builder, SSession.this.controller);
                Siovanus.loadSpriteSpecs(SSession.this.videoEngine().getSpriteSpecManager());
            }
        };
    }

    public static abstract class BaseState
    implements State {
        public ASession session;

        public BaseState(ASession session) {
            this.session = session;
        }
    }

    public static class SPauseState
    extends BaseState {
        int ticksWaiting = 0;

        public SPauseState(ASession session) {
            super(session);
        }

        @Override
        public void action(AScenario scenario) {
            SScenario sscenario = (SScenario)scenario;
            int exitCode = 0;
            if (this.ticksWaiting > 480) {
                exitCode = sscenario.isPassed() ? 1 : 3;
                this.session.exit(exitCode);
            }
            ++this.ticksWaiting;
            if (this.session.screen().stick().trigger(AInputDevice.Trigger.SQUARE)) {
                SSession ssession = (SSession)this.session;
                if (ssession.scenarioStatus == SScenarioStatus.Completed) {
                    exitCode = 1;
                } else if (ssession.scenarioStatus == SScenarioStatus.Failed) {
                    exitCode = 2;
                }
                this.session.exit(exitCode);
            }
        }

        @Override
        public void afterAction(AScenario scenario) throws AException {
        }

        @Override
        public void beforeAction(AScenario scenario) throws AException {
        }
    }

    public static class SRunningState
    extends BaseState {
        boolean userPaused = false;
        AMessageSprite pausingMessage = null;

        @Override
        public void action(AScenario scenario) throws AException {
            if (!this.userPaused) {
                this.session.controller().action();
                AScenarioEvent event = scenario.action();
                event.perform(scenario);
                this.session.controller().update();
            }
        }

        protected SRunningState(ASession session) {
            super(session);
        }

        @Override
        public void afterAction(AScenario scenario) {
            SSession ssession = (SSession)this.session;
            if (!this.userPaused) {
                if (ssession.remainingTicksToSuspend == 0) {
                    for (ASprite cur : ssession.screen.backgroundPlane().sprites()) {
                        if (!(cur instanceof SShotSprite)) continue;
                        cur.visible(false);
                    }
                    ssession.pause();
                    ssession.getBgmManager().stop();
                    ssession.getSoundManager().stopAll();
                    ssession.disableRendering();
                } else if (ssession.remainingTicksToSuspend > 0) {
                    if (ssession.remainingTicksToSuspend == 1) {
                        ((SScenario)scenario).instructionAfterScenario();
                    }
                    --ssession.remainingTicksToSuspend;
                } else if (this.session.stick().trigger(AInputDevice.Trigger.START)) {
                    this.pausingMessage = ssession.message("PAUSED", -1, 600, Color.green, 24.0f);
                    ssession.getBgmManager().stop();
                    ssession.getSoundManager().stopAll();
                    try {
                        Avis.logger().statistics("This scenario=<" + scenario + "> is paused. Statistics info about this scenario run is not reliable anymore.");
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {
                        Avis.logger().error("Wait interrupted", e);
                    }
                    this.userPaused = true;
                }
            } else if (ssession.stick().trigger(AInputDevice.Trigger.START)) {
                try {
                    Avis.logger().statistics("This scenario=<" + scenario + "> has been paused. Statistics info about this scenario run is not reliable anymore.");
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    Avis.logger().error("Wait interrupted", e);
                }
                this.userPaused = false;
                this.pausingMessage.dispose();
                ssession.enableRendering();
                ssession.getBgmManager().resume();
            } else {
                ssession.getBgmManager().stop();
                ssession.getSoundManager().stopAll();
                ssession.disableRendering();
            }
        }

        @Override
        public void beforeAction(AScenario scenario) throws AException {
        }
    }

    public static interface State {
        public void action(AScenario var1) throws AException;

        public void afterAction(AScenario var1) throws AException;

        public void beforeAction(AScenario var1) throws AException;
    }
}

