/*
 * Decompiled with CFR 0.152.
 */
package siovanus;

import avis.base.AException;
import avis.base.Avis;
import avis.input.AInputDevice;
import avis.motion.Drivant;
import avis.session.AScenarioEvent;
import java.awt.Color;
import java.util.SortedSet;
import java.util.TreeSet;
import siovanus.SGroup;
import siovanus.SScenario;
import siovanus.SScenarioEvent;
import siovanus.SScenarioStatus;
import siovanus.SStageScenario;
import siovanus.drivant.AviatorDrivant;
import siovanus.drivant.aviator.Aviator;
import siovanus.drivant.aviator.SmartAviator;

public class SStage00Scenario
extends SStageScenario {
    AviatorDrivant specialDrivant;

    @Override
    protected SortedSet<AScenarioEvent> composeEventList() {
        TreeSet<AScenarioEvent> ret = new TreeSet<AScenarioEvent>();
        ret.add(new SScenarioEvent(0){

            @Override
            protected void performSiovanusEvent(SScenario sscenario) throws AException {
                SStage00Scenario.this.createNewFriend_Ki84(2000.0, -1500.0, 64);
                SStage00Scenario.this.createNewFriend_Ki84(2500.0, -2000.0, 64);
                SStage00Scenario.this.createNewFriend_Ki84(3000.0, -2500.0, 64);
                SStage00Scenario.this.createNewUser_Ki84(500.0, -500.0, 64);
                SStage00Scenario.this.createNewEnemy_P51D(-500.0, 500.0, 192);
                SStage00Scenario.this.createNewEnemy_P51D(-1024.0, 3072.0, 192);
                SStage00Scenario.this.createNewEnemy_P51D(-1024.0, 3572.0, 192);
                SStage00Scenario.this.createNewEnemy_P51D(-1024.0, 4072.0, 192);
            }
        });
        ret.add(new SScenarioEvent(1){

            @Override
            protected void performSiovanusEvent(SScenario sscenario) throws AException {
                SStage00Scenario.this.title("Aviator", 350, Color.green, 64.0f, -1);
                SStage00Scenario.this.title("                 1945", 380, Color.red, 32.0f, 5);
            }
        });
        ret.add(new SScenarioEvent(5){

            @Override
            protected void performSiovanusEvent(SScenario sscenario) throws AException {
                SStage00Scenario.this.title("Powered by Avis++ Framework", 400, Color.green, 12.0f, -1);
                SStage00Scenario.this.title("Copyright (C) 2009 INUWI Software Lab.", 500, Color.green, 16.0f, -1);
            }
        });
        ret.add(new SScenarioEvent(11){

            @Override
            protected void performSiovanusEvent(SScenario sscenario) throws AException {
                SStage00Scenario.this.title("                 1945", 380, Color.red, 32.0f, 5);
            }
        });
        ret.add(new SScenarioEvent(21){

            @Override
            protected void performSiovanusEvent(SScenario sscenario) throws AException {
                SStage00Scenario.this.title("                 1945", 380, Color.red, 32.0f, -1);
            }
        });
        return ret;
    }

    @Override
    public AScenarioEvent action() throws AException {
        if (this.userDrivant != null) {
            this.userDrivant.disableCollisionDetect();
        }
        AScenarioEvent ret = super.action();
        if (this.userDrivant != null) {
            this.userDrivant.disableCollisionDetect();
        }
        return ret;
    }

    @Override
    public Aviator createUserAviator() {
        return new SmartAviator();
    }

    @Override
    protected boolean checkIfMissionCompleted() {
        return this.ssession.stick().trigger(AInputDevice.Trigger.SQUARE) || this.tick > 1200;
    }

    @Override
    protected boolean checkIfMissionFailed() {
        return false;
    }

    @Override
    public String bgm() {
        return null;
    }

    @Override
    public void invalidated(Drivant drivant) {
        if (drivant instanceof AviatorDrivant) {
            if (drivant.groupId() == SGroup.Enemy_Aerial) {
                this.createNewEnemy_P51D(-1024.0, 3072.0, 192);
            } else if (drivant.groupId() == SGroup.Player_Aerial) {
                this.createNewFriend_Ki84(2000.0, -1500.0, 64);
            }
        }
    }

    @Override
    public void missionCompleted() {
        this.userDrivant.disableCollisionDetect();
        this.ssession.scenarioFinished(SScenarioStatus.Completed);
        this.finished = true;
        Avis.logger().debug("scenario=<" + this + "> is finished (FINISH).");
    }

    @Override
    public String getBackgroundResourceName() {
        return "image/background/numatsu_ccb-75-30_c3_3.png";
    }

    @Override
    public void instructionAfterScenario() {
        this.ssession.message("[SPACE]:Start Game", -1, 600, Color.cyan, 24.0f);
    }
}

