/*
 * Decompiled with CFR 0.152.
 */
package siovanus;

import avis.base.AException;
import avis.base.Avis;
import avis.session.AScenarioEvent;
import avis.session.ASession;
import avis.sprite.AMessageSprite;
import java.awt.Color;
import java.util.Iterator;
import java.util.SortedSet;
import siovanus.SScenario;
import siovanus.SScenarioStatus;
import siovanus.SStage00Scenario;

public abstract class SStageScenario
extends SScenario {
    protected int tick = 0;
    protected SortedSet<AScenarioEvent> eventList;
    private Iterator<AScenarioEvent> iEventList;
    private AScenarioEvent nextEvent = null;
    protected boolean finished = false;
    protected static int irregularMessageIndex = 0;
    protected static String[] irregularMessageStrings = new String[]{"\u300c\u3053\u306e\u300e\u75be\u98a8\u300f\u306e\u5de6\u6369\u308a\u8fbc\u307f\u306b\u8ffd\u968f\u3067\u304d\u308b\u822a\u7a7a\u6a5f\u306a\u3069\u3001\u7c73\u82f1\u7368\u4f5b\u3053\u306e\u5730\u4e0a\u306e\u4f55\u8655\u306b\u3082\u5b58\u5728\u3057\u306a\u3044\u300d", "\u300c\u4e00\u5f0f\u6226\u3068\u306f\u9055\u3046\u306e\u3060\u3088\u3001\u4e00\u5f0f\u6226\u3068\u306f\uff01\u300d"};
    private AMessageSprite irregularMessage;

    @Override
    public AScenarioEvent action() throws AException {
        AScenarioEvent ret = AScenarioEvent.NULL_EVENT;
        try {
            if (!this.finished && this.checkIfMissionCompleted()) {
                this.ssession.disableStatistics();
                this.missionCompleted();
            }
            if (!this.finished && this.checkIfMissionFailed()) {
                this.ssession.disableStatistics();
                this.missionFailed();
            }
            if (!(this instanceof SStage00Scenario || this.finished || this.irregularMessage != null && !this.irregularMessage.isDisposed() || this.tick <= 200 || irregularMessageIndex >= irregularMessageStrings.length || this.userDrivant.isCollisionDetectEnabled())) {
                if (this.irregularMessage != null) {
                    this.irregularMessage.dispose();
                }
                this.irregularMessage = this.ssession.message(irregularMessageStrings[irregularMessageIndex], 0, 150, Color.green, 16.0f);
                this.irregularMessage.lifetime(96);
                ++irregularMessageIndex;
            }
            if (this.nextEvent == null) {
                AScenarioEvent aScenarioEvent = ret;
                return aScenarioEvent;
            }
            if (this.tick * this.ssession.interval() >= this.nextEvent.index() * 1000) {
                ret = this.nextEvent;
                this.nextEvent = this.iEventList.hasNext() ? this.iEventList.next() : null;
            }
        }
        finally {
            ++this.tick;
        }
        return ret;
    }

    protected void missionFailed() {
        this.ssession.scenarioFinished(SScenarioStatus.Failed);
        this.ssession.message("Mission Failed", -1, 250, Color.red, 64.0f);
        this.showResult(Color.red);
        this.finished = true;
        this.passed = false;
        Avis.logger().info("scenario=<" + this + "> is finished (FAIL).");
        Avis.logger().info(" userDrivant=<" + this.userDrivant + ">");
        if (this.userDrivant != null) {
            Avis.logger().debug("userDrivant.valid=<" + this.userDrivant.isValid() + ">");
        }
    }

    protected void missionCompleted() {
        this.userDrivant.disableCollisionDetect();
        this.ssession.scenarioFinished(SScenarioStatus.Completed);
        this.ssession.message("Mission Completed", -1, 250, Color.cyan, 64.0f);
        this.showResult(Color.cyan);
        this.finished = true;
        this.passed = true;
        Avis.logger().debug("scenario=<" + this + "> is finished (FINISH).");
    }

    private void showResult(Color color) {
        Iterator iLabels = this.scoreMap.keySet().iterator();
        int y = 320;
        while (iLabels.hasNext()) {
            String curLabel = (String)iLabels.next();
            String numberOfPlanesShotDown = "00" + this.scoreMap.get(curLabel);
            numberOfPlanesShotDown = numberOfPlanesShotDown.substring(numberOfPlanesShotDown.length() - 3);
            this.ssession.message(curLabel, 300, y, color, 20.0f);
            this.ssession.message(numberOfPlanesShotDown, 700, y, color, 20.0f);
            y += 30;
        }
    }

    @Override
    public void init(ASession session) throws AException {
        super.init(session);
        this.tick = 0;
        this.userDrivant = null;
        this.finished = false;
        this.passed = false;
        this.eventList = this.composeEventList();
        this.iEventList = this.eventList.iterator();
        if (this.iEventList.hasNext()) {
            this.nextEvent = this.iEventList.next();
        }
    }

    protected abstract SortedSet<AScenarioEvent> composeEventList();

    protected abstract boolean checkIfMissionCompleted();

    protected boolean checkIfMissionFailed() {
        return this.userDrivant != null && !this.userDrivant.isValid();
    }

    @Override
    public void reset() {
        super.reset();
        this.tick = 0;
        this.userDrivant = null;
        this.finished = false;
        this.passed = false;
    }

    protected int numberOfEnemiesShotDown(String label) {
        Integer n = (Integer)this.scoreMap.get(label);
        return n != null ? n : 0;
    }

    protected int numberOfTotalEnemiesShotDown() {
        int ret = 0;
        Iterator iLabels = this.scoreMap.keySet().iterator();
        while (iLabels.hasNext()) {
            ret += this.numberOfEnemiesShotDown((String)iLabels.next());
        }
        return ret;
    }

    protected int secondsElapsed() {
        return this.tick * this.ssession.interval() / 1000;
    }

    @Override
    public void instructionAfterScenario() {
        if (this.passed) {
            this.ssession.message("[SPACE]/[SQUARE]:Next Stage", -1, 550, Color.cyan, 24.0f);
        } else {
            this.ssession.message("[SPACE]/[SQUARE]:Continue", -1, 550, Color.red, 24.0f);
            this.ssession.message("'z'/[CIRCLE]:Quit game", -1, 580, Color.red, 24.0f);
        }
    }
}

