/*
 * Decompiled with CFR 0.152.
 */
package siovanus.drivant;

import avis.base.Avis;
import avis.motion.Drivant;
import avis.motion.Parameters;
import siovanus.drivant.SDrivant;
import siovanus.drivant.aviator.Aviator;

public abstract class AviatorDrivant
extends SDrivant {
    protected int shotInterval = 0;
    protected int bombInterval = 0;

    protected AviatorDrivant() {
    }

    public void aviator(Aviator aviator) {
        ((AviatorParameters)this.committed).aviator = aviator;
    }

    public Aviator aviator() {
        return ((AviatorParameters)this.committed).aviator;
    }

    @Override
    public double accelerationCoefficient() {
        return Avis.cos(this.direction(), (int)this.yawDirection());
    }

    @Override
    public double bank() {
        AviatorParameters p = (AviatorParameters)this.parameters();
        return p.bank;
    }

    protected void consumeShotInterval() {
        if (this.shotInterval > 0) {
            --this.shotInterval;
        }
        if (this.bombInterval > 0) {
            --this.bombInterval;
        }
    }

    @Override
    protected Parameters createInitialParameters() {
        return new AviatorParameters();
    }

    public double gunBias() {
        return 0.0;
    }

    public double gunDeltaX() {
        return 0.0;
    }

    public double gunDeltaY() {
        return 0.0;
    }

    public void notify(AviatorDrivant another, double r) {
        AviatorParameters p = (AviatorParameters)this.prepared;
        if (p.distanceToTarget > r) {
            p.distanceToTarget = r;
            p.target = another;
        }
    }

    @Override
    public final void performDrivantAction() {
        this.consumeShotInterval();
        AviatorParameters p = (AviatorParameters)this.prepared;
        this.aviator().perform(this, this.target());
        p.x += this.velocity() * (Avis.sin((int)p.bank) * Avis.sin((int)p.direction) * 0.5);
        p.y += this.velocity() * (-Avis.sin((int)p.bank) * Avis.cos((int)p.direction) * 0.5);
    }

    public void recoverBank() {
        AviatorParameters p = (AviatorParameters)this.prepared;
        int criterion = 128;
        double r = p.bank > (double)criterion ? p.bankRecovery : -p.bankRecovery;
        p.bank += r;
        p.bank = p.bank >= 256.0 ? 0.0 : (p.bank < 0.0 ? 0.0 : p.bank);
    }

    public void recoverYaw() {
        this.recoverYaw(1.0);
    }

    private void recoverYaw(double ratio) {
        AviatorParameters p = (AviatorParameters)this.prepared;
        double sin = Avis.sin((int)p.yawDirection, (int)p.direction);
        double r = 2.0 * p.yawV * ratio * sin;
        p.direction += r;
        if (p.direction < 0.0) {
            p.direction = (256.0 + p.direction) % 256.0;
        } else if (p.direction >= 256.0) {
            p.direction %= 256.0;
        }
        p.velocity -= p.acceleration * Math.abs(Avis.sin((int)p.yawDirection, (int)p.direction));
        p.velocity = Math.max(p.velocity, p.minV);
    }

    public void recoverYawHalf() {
        this.recoverYaw(0.5);
    }

    public void rollLeft(boolean rollOnly) {
        this.rollLeft(1.0, rollOnly);
    }

    public void rollLeft() {
        this.rollLeft(1.0, false);
    }

    public void rollLeft(double r, boolean rollOnly) {
        AviatorParameters p = (AviatorParameters)this.prepared;
        if (!rollOnly || p.bank > 192.0 || p.bank <= 128.0) {
            p.bank -= p.rollV * r;
            p.bank = p.bank < 0.0 ? (256.0 + p.bank) % 256.0 : p.bank % 256.0;
        }
    }

    protected void rollLeftHalf() {
        this.rollLeft(0.5, false);
    }

    public void rollRight() {
        this.rollRight(1.0, false);
    }

    public void rollRight(boolean rollOnly) {
        this.rollRight(1.0, rollOnly);
    }

    public void rollRight(double r, boolean rollOnly) {
        AviatorParameters p = (AviatorParameters)this.prepared;
        if (!rollOnly || p.bank < 64.0 || p.bank >= 128.0) {
            p.bank = (p.bank + p.rollV * r) % 256.0;
        }
    }

    protected void rollRightHalf() {
        this.rollRight(0.5, false);
    }

    public abstract void shot();

    public abstract void bomb();

    public Drivant target() {
        return ((AviatorParameters)this.committed).target;
    }

    public void target(Drivant target) {
        ((AviatorParameters)this.committed).target = target;
    }

    @Override
    public int viewDirection() {
        return (int)this.yawDirection();
    }

    public double yawDirection() {
        AviatorParameters p = (AviatorParameters)this.parameters();
        return p.yawDirection;
    }

    public void yawLeft() {
        AviatorParameters p = (AviatorParameters)this.prepared;
        p.yawDirection += p.yawV;
        p.yawDirection %= 256.0;
    }

    public void yawRight() {
        AviatorParameters p = (AviatorParameters)this.prepared;
        p.yawDirection -= p.yawV;
        p.yawDirection = p.yawDirection < 0.0 ? (256.0 + p.yawDirection) % 256.0 : p.yawDirection % 256.0;
    }

    public int life() {
        return ((AviatorParameters)this.committed).life;
    }

    @Override
    public void beforeInteraction() {
        AviatorParameters p = (AviatorParameters)this.prepared;
        p.distanceToTarget = Double.MAX_VALUE;
    }

    public static class AviatorParameters
    extends Parameters {
        private static final long serialVersionUID = -3863609777584496654L;
        public Aviator aviator;
        public double bank;
        public double bankRecovery = 1.0;
        public double distanceToTarget = Double.MAX_VALUE;
        public int life = 1;
        public double rollV;
        public Drivant target;
        public double yawDirection;
        public double yawRecovery = 2.0;
        public double yawV;
    }
}

