/*
 * Decompiled with CFR 0.152.
 */
package siovanus.drivant;

import avis.base.Avis;
import avis.motion.Drivant;
import avis.motion.Parameters;

public abstract class SDrivant
extends Drivant {
    public void accelerate() {
        Parameters p = this.prepared;
        double aa = Math.max(this.accelerationCoefficient(), 0.0) * p.acceleration;
        p.velocity = Math.min(p.velocity + aa, p.maxV);
    }

    protected double accelerationCoefficient() {
        return 1.0;
    }

    public void decelerate() {
        Parameters p = this.prepared;
        p.velocity = Math.max(p.velocity - p.acceleration, p.minV);
    }

    @Override
    public final void perform() {
        Parameters p = this.prepared;
        p.x += p.velocity * Avis.cos((int)p.direction);
        p.y += p.velocity * Avis.sin((int)p.direction);
        this.performDrivantAction();
        if (p.x > 6000.0 || p.x < -6000.0 || p.y > 4500.0 || p.y < -4500.0) {
            this.invalidate();
        }
    }

    protected abstract void performDrivantAction();

    @Override
    public double distance(Drivant another) {
        double dx = this.x() - another.x();
        double dy = this.y() - another.y();
        double r = Math.abs(dx) + Math.abs(dy);
        return r;
    }

    public Parameters __parameters() {
        return this.prepared;
    }
}

