/*
 * Decompiled with CFR 0.152.
 */
package siovanus.drivant.aviator;

import avis.base.Avis;
import avis.motion.Drivant;
import avis.motion.Parameters;
import siovanus.drivant.AviatorDrivant;
import siovanus.drivant.aviator.ChasingAviator;

public class CarefullyChasingAviator
extends ChasingAviator {
    private BiasedDrivant rightDummy = new BiasedDrivant(-85, 400.0);
    private BiasedDrivant leftDummy = new BiasedDrivant(85, 400.0);

    @Override
    protected void performAction(AviatorDrivant drivant, Drivant target) {
        if (target == null) {
            super.performAction(drivant, target);
            return;
        }
        Drivant.Product q = target.product(drivant);
        if (q.inner > 0.0) {
            BiasedDrivant imaginaryTarget = q.outer > 0.0 ? this.rightDummy : this.leftDummy;
            imaginaryTarget.target(target);
            super.performAction(drivant, imaginaryTarget);
        } else {
            super.performAction(drivant, target);
        }
    }

    static class BiasedDrivant
    extends Drivant {
        private Drivant target;
        private int theta;
        private double r;

        BiasedDrivant(int theta, double r) {
            this.theta = theta;
            this.r = r;
        }

        public void target(Drivant target) {
            this.target = target;
        }

        @Override
        public double x() {
            return this.target.x() + Avis.cos(this.target.direction() + this.theta) * this.r;
        }

        @Override
        public double y() {
            return this.target.y() + Avis.sin(this.target.direction() + this.theta) * this.r;
        }

        @Override
        public void perform() {
        }

        @Override
        protected Parameters createInitialParameters() {
            return new Parameters();
        }
    }
}

