/*
 * Decompiled with CFR 0.152.
 */
package siovanus.drivant.aviator;

import avis.base.Avis;
import avis.motion.Drivant;
import avis.motion.Parameters;
import siovanus.drivant.AviatorDrivant;
import siovanus.drivant.aviator.Aviator;

public class GunAviator
extends Aviator {
    protected AdjusterDrivant adjuster;
    private double rightEndX;
    private double rightEndY;
    private double leftEndX;
    private double leftEndY;
    private boolean rightMost = false;
    private boolean leftMost = false;
    private double rightSig;
    private double leftSig;

    public GunAviator(Drivant parent, double r, double theta, int baseDirection, int rightEnd, int leftEnd) {
        this.adjuster = new AdjusterDrivant(parent, r, theta);
        this.rightEndX = Avis.cos(rightEnd);
        this.rightEndY = Avis.sin(rightEnd);
        this.leftEndX = Avis.cos(leftEnd);
        this.leftEndY = Avis.sin(leftEnd);
        double baseX = Avis.cos(baseDirection);
        double baseY = Avis.sin(baseDirection);
        this.rightSig = Math.signum(this.rightEndX * baseY - this.rightEndY * baseX);
        this.leftSig = Math.signum(this.leftEndX * baseY - this.leftEndY * baseX);
        System.out.println("rightEnd=<" + rightEnd + ">,leftEnd=<" + leftEnd + ">");
        System.out.println("rightEndX=<" + this.rightEndX + ">, rightEndY=<" + this.rightEndY + ">");
        System.out.println("leftEndX=<" + this.leftEndX + ">, leftEndY=<" + this.leftEndY + ">");
        System.out.println("leftSig=<" + this.leftSig + ">, rightSig=<" + this.rightSig + ">");
    }

    @Override
    protected void performAction(AviatorDrivant drivant, Drivant target) {
        double outerProduct;
        AviatorDrivant.AviatorParameters param = (AviatorDrivant.AviatorParameters)drivant.parameters();
        param.direction = param.yawDirection;
        int direction = (int)param.yawDirection;
        Drivant.Product p = drivant.product(target);
        double outerProductWithRightEnd = this.rightEndX * Avis.sin(direction) - this.rightEndY * Avis.cos(direction);
        double innerProductWithRightEnd = this.rightEndX * Avis.cos(direction) + this.rightEndY * Avis.sin(direction);
        double outerProductWithLeftEnd = this.leftEndX * Avis.sin(direction) - this.leftEndY * Avis.cos(direction);
        double innerProductWithLeftEnd = this.leftEndX * Avis.cos(direction) + this.leftEndY * Avis.sin(direction);
        this.leftMost = false;
        this.rightMost = false;
        if (outerProductWithLeftEnd != 0.0 && innerProductWithLeftEnd > 0.0 && Math.signum(outerProductWithLeftEnd) != this.leftSig) {
            this.leftMost = true;
        }
        if (outerProductWithRightEnd != 0.0 && innerProductWithRightEnd > 0.0 && Math.signum(outerProductWithRightEnd) != this.rightSig) {
            this.rightMost = true;
        }
        if ((outerProduct = p.outer) > 0.0) {
            if (!this.rightMost) {
                drivant.yawRight();
            }
        } else if (outerProduct < 0.0 && !this.leftMost) {
            drivant.yawLeft();
        }
        double tan = p.tangent;
        if (p.inner > 0.0 && Math.abs(tan) < 0.25 && target.groupId() != drivant.groupId()) {
            drivant.shot();
        }
        this.adjuster.adjust(drivant);
    }

    protected static class AdjusterDrivant
    extends Drivant {
        private double r;
        private double theta;
        private Drivant parent;

        protected AdjusterDrivant(Drivant parent, double r, double theta) {
            this.parent = parent;
            this.r = r;
            this.theta = theta;
        }

        protected void adjust(Drivant owner) {
            AviatorDrivant.AviatorParameters pOwner = (AviatorDrivant.AviatorParameters)owner.rollbackSegment();
            AviatorDrivant.AviatorParameters pParent = (AviatorDrivant.AviatorParameters)this.parent.rollbackSegment();
            pOwner.x = pParent.x + Avis.cos((int)(this.theta + pParent.direction)) * this.r;
            pOwner.y = pParent.y + Avis.sin((int)(this.theta + pParent.direction)) * this.r;
        }

        @Override
        public void perform() {
        }

        protected void collision(Drivant another, double distance) {
        }

        @Override
        protected Parameters createInitialParameters() {
            return new Parameters();
        }
    }
}

