/*
 * Decompiled with CFR 0.152.
 */
package siovanus.drivant.aviator;

import avis.motion.Drivant;
import java.util.List;
import siovanus.drivant.AviatorDrivant;
import siovanus.drivant.aviator.Aviator;

public class ProgrammedAviator
extends Aviator {
    public List<Command> commands;
    protected Command data = new Command(Op.Hold, Integer.MAX_VALUE);

    protected ProgrammedAviator(List<Command> commands) {
        this.commands = commands;
        if (commands.size() > 0) {
            Command cmd = commands.remove(0);
            this.data.op = cmd.op;
            this.data.left = cmd.left;
        }
    }

    @Override
    protected void performAction(AviatorDrivant drivant, Drivant target) {
        if (this.data.left < 0) {
            if (this.commands.size() > 0) {
                Command cmd = this.commands.remove(0);
                this.data.previousOp = this.data.op;
                this.data.op = cmd.op;
                this.data.left = cmd.left;
            } else {
                this.data.op = Op.Hold;
                this.data.left = Integer.MAX_VALUE;
            }
        } else {
            --this.data.left;
        }
        if (this.data.op == Op.Hold) {
            drivant.recoverYaw();
            drivant.recoverBank();
        } else if (this.data.op == Op.Accelerate) {
            drivant.accelerate();
        } else if (this.data.op == Op.Decelerate) {
            drivant.decelerate();
        } else if (this.data.op == Op.RollLeft) {
            drivant.rollLeft();
        } else if (this.data.op == Op.RollRight) {
            drivant.rollRight();
        } else if (this.data.op == Op.RollYawLeft) {
            drivant.rollLeft();
            drivant.yawLeft();
            drivant.recoverYawHalf();
        } else if (this.data.op == Op.RollYawRight) {
            drivant.rollRight();
            drivant.yawRight();
            drivant.recoverYawHalf();
        } else if (this.data.op == Op.Shot) {
            drivant.shot();
            this.data.op = this.data.previousOp;
        } else if (this.data.op == Op.YawLeft) {
            drivant.yawLeft();
        } else if (this.data.op == Op.YawRight) {
            drivant.yawRight();
        }
    }

    public static class Command {
        public Op op;
        public int left;
        public Op previousOp;

        public Command(Op op, int left) {
            this.op = op;
            this.left = left;
        }
    }

    public static enum Op {
        Hold,
        Accelerate,
        Decelerate,
        RollLeft,
        RollRight,
        YawLeft,
        YawRight,
        RollYawLeft,
        RollYawRight,
        Shot;

    }
}

