/*
 * Decompiled with CFR 0.152.
 */
package siovanus.motion;

import avis.motion.Drivant;
import avis.motion.InteractionHandler;
import avis.motion.MMachine;
import avis.motion.MotionController;
import junit.framework.TestCase;
import siovanus.SGroup;
import siovanus.motion.MMachine_Driver;

public class MotionController_Test
extends TestCase {
    MMachine_Driver driver;
    MMachine mmachine1;
    MMachine mmachine2;
    MotionController controller;
    Drivant drivant2;
    Drivant drivant1;

    public void setUp() {
        this.driver = new MMachine_Driver();
        this.mmachine1 = this.driver.createTestMMachine_01();
        this.mmachine2 = this.driver.createTestMMachine_02();
        this.drivant1 = this.mmachine1.drivant();
        this.drivant2 = this.mmachine2.drivant();
        this.driver.drivant1TimesCollisionDetected = 0;
        this.driver.drivant2TimesCollisionDetected = 0;
        this.controller = new MotionController();
        this.controller.interactionHandler(new InteractionHandler(){

            @Override
            public boolean collides(Drivant d1, Drivant d2, double distance) {
                return true;
            }

            @Override
            public void handleCollision(Drivant d1, Drivant d2, double distance) {
                MotionController_Test.this.driver.drivant1CollisionDetected = true;
                MotionController_Test.this.driver.drivant2CollisionDetected = true;
                ++MotionController_Test.this.driver.drivant1TimesCollisionDetected;
                ++MotionController_Test.this.driver.drivant2TimesCollisionDetected;
            }

            @Override
            public void handleInteraction(Drivant d1, Drivant d2, double distance) {
            }
        });
        this.controller.init();
    }

    public void test_collision_01() {
        this.drivant1.rollbackSegment().groupId = null;
        this.drivant2.rollbackSegment().groupId = null;
        this.controller.add(this.mmachine1);
        this.controller.add(this.mmachine2);
        this.controller.update();
        this.controller.action();
        MotionController_Test.assertTrue((!this.driver.drivant1CollisionDetected ? 1 : 0) != 0);
        MotionController_Test.assertTrue((!this.driver.drivant2CollisionDetected ? 1 : 0) != 0);
    }

    public void test_collision_02() {
        this.drivant1.rollbackSegment().groupId = SGroup.Enemy_Aerial;
        this.drivant1.commit();
        this.drivant2.rollbackSegment().groupId = SGroup.Player_Aerial;
        this.drivant2.commit();
        this.controller.add(this.mmachine1);
        this.controller.add(this.mmachine2);
        this.controller.update();
        this.controller.action();
        MotionController_Test.assertTrue((boolean)this.driver.drivant1CollisionDetected);
        MotionController_Test.assertEquals((int)1, (int)this.driver.drivant1TimesCollisionDetected);
        MotionController_Test.assertTrue((boolean)this.driver.drivant2CollisionDetected);
        MotionController_Test.assertEquals((int)1, (int)this.driver.drivant2TimesCollisionDetected);
    }

    public void test_collision_03() {
        this.drivant1.rollbackSegment().groupId = SGroup.Enemy_Aerial;
        this.drivant1.commit();
        this.drivant2.rollbackSegment().groupId = null;
        this.drivant2.commit();
        this.controller.add(this.mmachine1);
        this.controller.add(this.mmachine2);
        this.controller.update();
        this.controller.action();
        MotionController_Test.assertTrue((!this.driver.drivant1CollisionDetected ? 1 : 0) != 0);
        MotionController_Test.assertTrue((!this.driver.drivant2CollisionDetected ? 1 : 0) != 0);
    }

    public void test_collision_04() {
        this.drivant1.rollbackSegment().groupId = null;
        this.drivant1.commit();
        this.drivant2.rollbackSegment().groupId = SGroup.Player_Aerial;
        this.drivant2.commit();
        this.controller.add(this.mmachine1);
        this.controller.add(this.mmachine2);
        this.controller.update();
        this.controller.action();
        MotionController_Test.assertTrue((!this.driver.drivant1CollisionDetected ? 1 : 0) != 0);
        MotionController_Test.assertTrue((!this.driver.drivant2CollisionDetected ? 1 : 0) != 0);
    }

    public void test_collision_05() {
        this.drivant1.rollbackSegment().groupId = SGroup.Enemy_Surface;
        this.drivant1.commit();
        this.drivant2.rollbackSegment().groupId = SGroup.Player_Surface;
        this.drivant2.commit();
        this.controller.add(this.mmachine1);
        this.controller.add(this.mmachine2);
        this.controller.update();
        this.controller.action();
        MotionController_Test.assertTrue((boolean)this.driver.drivant1CollisionDetected);
        MotionController_Test.assertEquals((int)1, (int)this.driver.drivant1TimesCollisionDetected);
        MotionController_Test.assertTrue((boolean)this.driver.drivant2CollisionDetected);
        MotionController_Test.assertEquals((int)1, (int)this.driver.drivant2TimesCollisionDetected);
    }
}

