/*
 * Decompiled with CFR 0.152.
 */
package siovanus.sprite;

import avis.base.APoint;
import avis.base.Avis;
import avis.motion.Drivant;
import avis.motion.MMachine;
import avis.motion.MotionController;
import avis.spec.ASpriteSpec;
import avis.video.APlane;
import avis.video.AViewport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import siovanus.SGroup;
import siovanus.spec.SRadarSpriteSpec;
import siovanus.sprite.SShapeSprite;

public class SRadarSprite
extends SShapeSprite {
    protected MotionController controller;
    protected Color color;
    private AffineTransform _transform;
    private AViewport viewport;
    private APlane targetPlane;
    private double horizontalRatio;
    private double verticalRatio;
    private double originX;
    private double originY;

    @Override
    protected void init_Protected(ASpriteSpec p) {
        Avis.logger().debug("Radar Sprite initialized:<" + this + ">");
        SRadarSpriteSpec spec = (SRadarSpriteSpec)this.spec;
        this.targetPlane = spec.targetPlane();
        this.viewport = spec.targetPlane().viewport();
        this.color = spec.color();
        this.controller = spec.controller();
    }

    @Override
    public int width() {
        return ((SRadarSpriteSpec)this.spec).width();
    }

    @Override
    public int height() {
        return ((SRadarSpriteSpec)this.spec).height();
    }

    @Override
    public void paint_Protected(Graphics graphics, ImageObserver observer) {
        this.horizontalRatio = (double)this.width() / this.targetPlane.background().imageWidth();
        this.verticalRatio = (double)this.height() / this.targetPlane.background().imageHeight();
        this.originX = this.targetPlane.background().imageWidth() / 2.0;
        this.originY = this.targetPlane.background().imageHeight() / 2.0;
        this._transform = AffineTransform.getScaleInstance(this.horizontalRatio, -this.verticalRatio);
        graphics.setColor(this.color);
        graphics.fillRect(this.x, this.y, this.width(), this.height());
        APoint src = new APoint();
        APoint dest = new APoint();
        int biasX = this.x + this.width() / 2;
        int biasY = this.y + this.height() / 2;
        int halfWidth = this.width();
        int halfHeight = this.height();
        for (MMachine mmachine : this.controller.mmachines()) {
            Drivant drivant = mmachine.drivant();
            if (drivant.groupId() == SGroup.Player_Aerial) {
                graphics.setColor(Color.CYAN);
            } else if (drivant.groupId() == SGroup.Enemy_Surface) {
                graphics.setColor(Color.BLUE);
            } else if (drivant.groupId() == SGroup.Enemy_Aerial) {
                graphics.setColor(Color.ORANGE);
            } else if (drivant.groupId() == SGroup.Enemy_Surface) {
                graphics.setColor(Color.RED);
            }
            src.set(drivant.x(), drivant.y());
            this._transform.transform(src, dest);
            if (dest.x() < (double)(-halfWidth / 2 - 20) || dest.x() > (double)(halfWidth / 2 + 20) || dest.y() < (double)(-halfHeight / 2 - 20) || dest.y() > (double)(halfHeight / 2 + 20)) continue;
            graphics.fillRect((int)dest.x() + biasX - 2, (int)dest.y() + biasY - 2, 4, 4);
        }
        graphics.setColor(Color.BLUE);
        int vw = (int)(this.targetPlane.width() * this.horizontalRatio);
        int vh = (int)(this.targetPlane.height() * this.verticalRatio);
        int centerX = biasX + (int)((this.viewport.x() - this.originX) * this.horizontalRatio);
        int centerY = biasY + (int)((this.viewport.y() - this.originY) * this.verticalRatio);
        Graphics2D gg = (Graphics2D)graphics;
        AffineTransform backup = gg.getTransform();
        try {
            gg.rotate(Avis.srad2rad(-this.viewport.theta()), centerX, centerY);
            gg.drawRect(centerX - vw / 2, centerY - vh / 2, vw, vh);
            gg.drawLine(centerX, centerY - 5, centerX + 5, centerY + 10);
            gg.drawLine(centerX, centerY - 5, centerX - 5, centerY + 10);
            gg.drawLine(centerX - 5, centerY + 10, centerX + 5, centerY + 10);
        }
        finally {
            gg.setTransform(backup);
        }
        dest = null;
        src = null;
    }
}

