/*
 * Copyright (C) 2010 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus.concurrent;

import plus.util.NumHelper;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * Atomic Array の実装.
 * The class to which this annotation is applied is thread-safe.
 *
 * @param <E> Value
 * @author Kunio Himei.
 */
public class AtomicArray<E> extends CopyOnWriteArrayList<E>
        implements ArrayAccessor<Number, E> {

    public AtomicArray() {
        super();
    }

    public AtomicArray(Collection<? extends E> c) {
        super(c);
    }

    public AtomicArray(E[] toCopyIn) {
        super(toCopyIn);
    }

    //* ------------------------------------------------------------------------
    //* Array Getter / Setter - for Groovy.
    //* ------------------------------------------------------------------------
    @Override
    public E getAt(Object key) { //
        return super.get(arrayKey(key));
    }

    @Override
    public void putAt(Object key, E value) {
        super.set(arrayKey(key), value);
    }

    /**
     * 配列アクセスキー作成 (浮動小数点は、'CONVFMT'で変換).
     */
    public int arrayKey(Object key) {
        return NumHelper.intValue(key);
    }
}