/*
 * Decompiled with CFR 0.152.
 */
package plus.eval;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import plus.concurrent.AtomicNumber;
import plus.eval.EvalAssign;
import plus.exception.BreakException;
import plus.exception.ContinueException;
import plus.exception.ExitException;
import plus.exception.NextException;
import plus.lex.Flags;
import plus.lex.Keyword;
import plus.lex.Node;
import plus.lex.Parser;
import plus.lex.Term;
import plus.runtime.BuiltInVar;
import plus.util.Debug;
import plus.util.NumHelper;
import plus.variable.Frame;

public final class Eval
extends EvalAssign {
    public static final String AWK_PLUS_FOR_ANDROID = "AWK\u02dcplus for Android";
    private static final Pattern RX_INT_NUMBER = Pattern.compile("^\\d+$");
    private static final Integer C_INTEGER1 = 1;
    private static boolean appliedAsMessage = false;

    public Eval(Parser.SyntaxTree tree) {
        this.sTree = tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String[] args) throws Throwable {
        BuiltInVar.reInitialize();
        Frame.cleanup();
        Eval._GLOBALS("false", Boolean.FALSE);
        Eval._GLOBALS("true", Boolean.TRUE);
        this.isGlobalDef = true;
        for (Map.Entry<String, Integer> x : this.sTree.globalValues.entrySet()) {
            Object[] k = x.getKey();
            if (Flags.isArray(x.getValue())) {
                _VARIABLES._allocArray((String)k);
                continue;
            }
            Eval._GLOBALS((String)k, 0);
        }
        if (Eval.exists(this.sTree.global)) {
            this.eval(this.sTree.global);
        }
        this.isGlobalDef = false;
        Eval._newArgs(args, null);
        int exitCode = 0;
        try {
            try {
                if (0 != this.sTree.begin.length) {
                    Frame._startBlockContext();
                    this.eval(this.sTree.begin);
                }
                if (0 != this.sTree.main.length || 0 != this.sTree.end.length) {
                    Object file = 0 == BuiltInVar.ARGIND.intValue() ? Eval.nextfile() : BuiltInVar.FILENAME.get();
                    Frame._startBlockContext();
                    while (Eval.exists(file)) {
                        BuiltInVar.FNR.put(0);
                        while (null != Eval.getline("", file, 0)) {
                            BuiltInVar.NR.calculate("+", C_INTEGER1);
                            BuiltInVar.FNR.calculate("+", C_INTEGER1);
                            try {
                                for (Object x : this.sTree.main) {
                                    this.eval(x);
                                }
                            }
                            catch (NextException e) {
                                file = BuiltInVar.FILENAME.get();
                            }
                        }
                        file = Eval.nextfile();
                    }
                }
            }
            catch (ExitException e) {
                if (Frame.GLOBALS.containsKey(AWK_PLUS_FOR_ANDROID)) {
                    Frame.GLOBALS.put(AWK_PLUS_FOR_ANDROID, e.value);
                }
                exitCode = e.value();
            }
            if (0 != this.sTree.end.length) {
                Frame._startBlockContext();
                this.eval(this.sTree.end);
            }
        }
        catch (ExitException e) {
            if (Frame.GLOBALS.containsKey(AWK_PLUS_FOR_ANDROID)) {
                Frame.GLOBALS.put(AWK_PLUS_FOR_ANDROID, e.value);
            } else {
                exitCode = e.value();
            }
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (null != cause.getCause()) {
                cause = cause.getCause();
            }
            cause.printStackTrace();
            System.err.println(logging.snap());
        }
        finally {
            Eval.close(new Object[0]);
        }
        return exitCode;
    }

    @Override
    @Nullable
    Object eval(Object ee) {
        try {
            Object[] objectArray;
            Object[] e = ee;
            while ((objectArray = e) instanceof Object[]) {
                Object[] x = objectArray;
                int xxlen = x.length;
                if (1 == xxlen) {
                    e = x[0];
                    continue;
                }
                if (1 < xxlen) {
                    this.eval(x[0]);
                    e = Arrays.copyOfRange(x, 1, x.length);
                    continue;
                }
                return x;
            }
            if (e instanceof CharSequence || e instanceof Number || e instanceof Boolean) {
                return e;
            }
            if (e instanceof Term.YyValue) {
                return ((Term.YyValue)e).value;
            }
            if (e instanceof Node.Root) {
                Object[] name;
                logging.log((Node.Root)e);
                Object[] objectArray2 = e;
                if (objectArray2 instanceof Node.YyVariable) {
                    Node.YyVariable x = (Node.YyVariable)objectArray2;
                    name = x.name;
                    if (x instanceof Node.NAME && this.sTree.func.containsKey(name)) {
                        return this.callFunction((String)name, EMPTY_ARRAY);
                    }
                    return Eval._getValue((String)name, this.mkIndex(x.index));
                }
                if (e instanceof Node.YyeValue) {
                    return this.yyeValue((Node.YyeValue)e);
                }
                if (e instanceof Node.YyStatement) {
                    return this.yyStatement((Node.YyStatement)e);
                }
                name = e;
                if (name instanceof Node.Call) {
                    Node.Call x = (Node.Call)name;
                    return this.callFunction(x.name, x.args);
                }
                if (e instanceof Node.Invoke) {
                    return this.invoke((Node.Invoke)e);
                }
                name = e;
                if (name instanceof Node.Getline) {
                    String line;
                    Node.Getline x = (Node.Getline)name;
                    String file = "" + this.eval(x.filename);
                    Node.YyVariable vv = (Node.YyVariable)x.args[0];
                    String index = this.mkIndex(vv.index);
                    if ("$".equals(vv.name)) {
                        line = Eval.getline(x.rid, file, index);
                    } else {
                        line = Eval.getline(x.rid, file, new Object[0]);
                        Eval._putValue(vv.name, index, "=", line);
                    }
                    return null == line ? 0 : 1;
                }
                if (e instanceof Node.YyNop) {
                    return 0;
                }
                throw new IllegalStateException("unmatch: " + Debug.objectOf(e));
            }
            throw new IllegalStateException("unmatch: " + Debug.objectOf(e));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object yyeValue(Node.YyeValue e) {
        Node.Root a;
        String name = e.name;
        Node.YyeValue yyeValue = e;
        if (yyeValue instanceof Node.B00l) {
            Node.B00l x = (Node.B00l)yyeValue;
            boolean bo = Eval._if(this.eval(x.expr));
            return "!".equals(name) != bo;
        }
        Node.YyeValue bo = e;
        if (bo instanceof Node.Comp) {
            Object object;
            Node.Comp x = (Node.Comp)bo;
            if ("is".equals(name) || "as".equals(name)) {
                Object left = this.eval(x.left);
                Object right = this.applyImport(x.right.toString());
                if ("is".equals(name)) {
                    return Eval._is(left, right.toString());
                }
                if (!appliedAsMessage) {
                    appliedAsMessage = true;
                    System.err.println(" 'as'(forced cast) is not supported by the interpreter.");
                }
                return 0;
            }
            if ("in".equals(name) && (object = x.left) instanceof Node.Call) {
                a = (Node.Call)object;
                return Eval._in(this.eval(x.right), this.mkIndex(((Node.Call)a).args));
            }
            boolean bo2 = name.matches("[|]{1,2}") ? Eval._if(this.eval(x.left)) || Eval._if(this.eval(x.right)) : (name.matches("&{1,2}") ? Eval._if(this.eval(x.left)) && Eval._if(this.eval(x.right)) : (RX_INT_NUMBER.matcher(name).find() ? Eval._p2p(name, this.eval(x.left), this.eval(x.right)) : ("in".equals(name) ? Eval._in(this.eval(x.right), this.eval(x.left)) : Eval._if(name, this.eval(x.left), this.eval(x.right)))));
            return bo2;
        }
        bo = e;
        if (bo instanceof Node.IncDec) {
            Node.IncDec x = (Node.IncDec)bo;
            if ("NUMBER".equals(name)) {
                return NumHelper.normalise(NumHelper.doubleValue(this.eval(x.expr)));
            }
            a = (Node.YyVariable)x.expr;
            return Eval._putValue(a.name, this.mkIndex(a.index), name, 1);
        }
        yyeValue = e;
        if (yyeValue instanceof Node.Calc) {
            Node.Calc x = (Node.Calc)yyeValue;
            return AtomicNumber.calculate(name, this.eval(x.left), this.eval(x.right));
        }
        throw new IllegalStateException("unmatch: " + Debug.objectOf(e));
    }

    private Object yyStatement(Node.YyStatement e) throws Throwable {
        Object file;
        Object idx;
        Object jIte;
        Object bo;
        Keyword id = e.id;
        if (e instanceof Node.Ass) {
            return this.assignStmt((Node.Ass)e);
        }
        Node.YyStatement yyStatement = e;
        if (yyStatement instanceof Node.If) {
            Node.If x = (Node.If)yyStatement;
            bo = Eval._if(this.eval(x.cc)) ? this.eval(x.left) : this.eval(x.right);
            return Keyword.SymIF == id ? Integer.valueOf(0) : bo;
        }
        if (e instanceof Node.Stmt) {
            this.simpleStmt((Node.Stmt)e);
            return 0;
        }
        bo = e;
        if (bo instanceof Node.ForIn) {
            Node.ForIn x = (Node.ForIn)bo;
            jIte = Eval.iterator(this.eval(x.e2));
            if (Keyword.SymVAL == x.e1.id || Keyword.SymVAR == x.e1.id) {
                this.assignStmt(new Node.Ass(Keyword.SymVAR, "=", x.e1, "", 31, ""));
            }
            boolean hasNext = true;
            while (hasNext && jIte.hasNext()) {
                Object k = jIte.next();
                try {
                    Eval._putValue(x.e1.name, null, "=", this.eval(k));
                    this.eval(x.stmt);
                }
                catch (BreakException e1) {
                    hasNext = false;
                }
                catch (ContinueException continueException) {}
            }
            return 0;
        }
        jIte = e;
        if (jIte instanceof Node.For) {
            Node.For x = (Node.For)jIte;
            this.eval(x.e1);
            boolean is1st = true;
            boolean hasNext = true;
            while (hasNext) {
                try {
                    if (is1st) {
                        is1st = false;
                    } else {
                        this.eval(x.e3);
                    }
                    if (Eval._if(this.eval(x.e2))) {
                        this.eval(x.stmt);
                        continue;
                    }
                    hasNext = false;
                }
                catch (BreakException e1) {
                    hasNext = false;
                }
                catch (ContinueException e1) {}
            }
            return 0;
        }
        Node.YyStatement is1st = e;
        if (is1st instanceof Node.While) {
            Node.While x = (Node.While)is1st;
            boolean isDO = Keyword.SymDO == id || Keyword.SyyBDO == id;
            boolean hasNext = true;
            while (hasNext && (isDO || Eval._if(this.eval(x.cc)))) {
                try {
                    this.eval(x.stmt);
                }
                catch (BreakException ex) {
                    hasNext = false;
                }
                catch (ContinueException continueException) {
                    // empty catch block
                }
                if (!hasNext || !isDO) continue;
                hasNext = Eval._if(this.eval(x.cc));
            }
            return 0;
        }
        Node.YyStatement isDO = e;
        if (isDO instanceof Node.Del) {
            Node.Del x = (Node.Del)isDO;
            idx = this.mkIndex(x.e.index);
            if ("$".equals(x.e.name)) {
                BuiltInVar.$.putAt(idx, "");
            } else {
                _VARIABLES._remove(x.e.name, idx);
            }
            return 0;
        }
        idx = e;
        if (idx instanceof Node.Print) {
            Node.Print x = (Node.Print)idx;
            file = Objects.toString(this.eval(x.filename), "");
            Object[] vals = this.evalArgs(x.args);
            if ("print".equals(x.name)) {
                return Eval.print(x.rid, (String)file, vals);
            }
            return Eval._printf(x.rid, (String)file, vals);
        }
        if (e instanceof Node.Try) {
            return this.tryCatch((Node.Try)e);
        }
        file = e;
        if (file instanceof Node.Throw) {
            Node.Throw x = (Node.Throw)file;
            Object o = this.eval(x.expr);
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return 0;
        }
        if (e instanceof Node.FnI) {
            return 0;
        }
        throw new IllegalStateException("unmatch: " + Debug.objectOf(e));
    }
}

