/** AWK~plus - Fibonacci number　& Annotation.
 */
val number: int = 23 # 番目まで
val expect: int = 28657 # 答え
BEGIN {
    fibonacci
    print "."
}
# フィボナッチ数
@TypeChecked  # 型推論をクラスファイルに反映しない.
function fibonacci() {
    print "   ." toString()
    @CompileStatic  # 型推論をクラスファイルに反映(ダイナミック言語としての柔軟さは、失われる)
    function fib1(n: Integer): Integer {
        if (2 > n) return n
        return fib1(n - 1) + fib1(n - 2)
    }
    @CompileStatic  # Reflect type inference in class files.
    function fib2(n: int): int { # 'int'で高速化(Speed up with 'int')
        if (2 > n) return n
        return fib2(n - 1) + fib2(n - 2) 
    }
    var start: double = systime()
    var actual: int = fib1(number)
    printf "\t.fib1: %d %.6gsec.\n", actual, systime() - start
    assertEquals(expect, actual)

    start = systime()
    actual = fib2(number)
    printf "\t.fib2: %d %.6gsec.\n", actual, systime() - start
    assertEquals(expect, actual)
}
@CompileStatic  # 型推論をクラスファイルに反映.
@Override
function toString(): String {
    return "Fibonacci number."
}