/*
 * Decompiled with CFR 0.152.
 */
package plus.eval;

import java.util.Arrays;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import plus.BiBase;
import plus.concurrent.AtomicMap;
import plus.concurrent.AtomicNumber;
import plus.eval.EvalVar;
import plus.exception.ReturnException;
import plus.lex.Flags;
import plus.lex.Node;
import plus.reflect.Listener;
import plus.runtime.BuiltInVar;
import plus.util.Debug;
import plus.variable.Frame;

abstract class EvalFunc
extends EvalVar {
    private static final ReentrantLock SYNC = new ReentrantLock();

    EvalFunc() {
    }

    private int setUserCallParam(Node.Func fn, Object[] args, Object[] vals) {
        assert (null != args && null != vals);
        int argslen = args.length;
        if (1 <= argslen && 0 == fn.argsLength) {
            throw new IllegalArgumentException(fn.name + Debug.objectOf(args));
        }
        int idx = 0;
        for (int k = 0; argslen > k; ++k) {
            String id = fn.parm[idx].name;
            int typ = fn.parm[idx].nType;
            if (Flags.isVarArgs(typ)) {
                Object[] arr = new Object[argslen - k];
                int i = 0;
                while (argslen > k) {
                    Object w;
                    if (Flags.isReference(typ)) {
                        assert (args[k] instanceof Node.YyVariable);
                        x = (Node.YyVariable)args[k];
                        w = new Reference(x.name, this.mkIndex(x.index));
                    } else if (!Flags.isArray(typ)) {
                        w = vals[k];
                    } else {
                        assert (args[k] instanceof Node.NAME);
                        x = (Node.NAME)args[k];
                        w = _VARIABLES._allocArray(((Node.NAME)x).name);
                    }
                    arr[i] = w;
                    ++k;
                    ++i;
                }
                Frame._putLocalVar(id, arr);
            } else if (!Flags.isArray(typ)) {
                Frame._putLocalVar(id, vals[k]);
            } else {
                Object x = args[k];
                if (x instanceof Node.NAME) {
                    _VARIABLES._allocLocalArray(id, ((Node.NAME)x).name);
                } else if (!(x instanceof AtomicMap) && !(x instanceof Object[])) {
                    throw new IllegalStateException("unmatch: " + Debug.objectOf(x));
                }
            }
            ++idx;
        }
        return idx;
    }

    private void setUserLocalVars(Node.Func fn, int ix) {
        int len = fn.parm.length;
        for (int i = ix; len > i; ++i) {
            String id = fn.parm[i].name;
            int typ = fn.parm[i].nType;
            if (Flags.isVarArgs(typ)) {
                Frame._putLocalVar(id, EMPTY_ARRAY);
                continue;
            }
            if (Flags.isArray(typ)) {
                _VARIABLES._allocLocalArray(id, null);
                continue;
            }
            Object w = Flags.isInteger(typ) || Flags.isNumber(typ) ? new AtomicNumber() : (Flags.isString(typ) ? "" : Integer.valueOf(0));
            Frame._putLocalVar(id, w);
        }
    }

    Object callFunction(String name, Object[] args) {
        return this.sTree.func.containsKey(name) ? this.userFunction(name, args, this.evalArgs(args)) : this.builtinFunction(name, args, this.evalArgs(args));
    }

    Object userFunction(String name, Object[] args, Object[] vals) {
        Object rs;
        Frame._startLocal();
        Node.Func fn = this.sTree.func.get(name);
        this.setUserLocalVars(fn, this.setUserCallParam(fn, args, vals));
        try {
            rs = this.eval(fn.stmt);
        }
        catch (ReturnException ex) {
            rs = ex.value();
        }
        Frame._endLocal();
        return rs;
    }

    private Object builtinFunction(String x, Object[] args, Object[] vals) {
        if ("INDEX".equals(x)) {
            return 0 == vals.length ? null : EvalFunc._index(vals);
        }
        if ("cat_".equals(x)) {
            return EvalFunc._cat(vals);
        }
        if ("double".equals(x)) {
            return EvalFunc._double(vals[0]);
        }
        if ("float".equals(x)) {
            return Float.valueOf(EvalFunc._float(vals[0]));
        }
        if ("long".equals(x)) {
            return EvalFunc._long(vals[0]);
        }
        if ("int".equals(x)) {
            return EvalFunc._int(vals[0]);
        }
        if ("gsub".equals(x)) {
            vals = this.preGsub(args, vals);
            int cc = EvalFunc.gsub(vals);
            if (2 < vals.length) {
                this.postGsub((Node.YyVariable)args[2]);
            }
            return cc;
        }
        if ("sub".equals(x)) {
            vals = this.preGsub(args, vals);
            int cc = EvalFunc.sub(vals);
            if (2 < vals.length) {
                this.postGsub((Node.YyVariable)args[2]);
            }
            return cc;
        }
        if ("assertEquals".equals(x)) {
            return EvalFunc.assertEquals(EvalFunc.scriptLineNumber(), vals);
        }
        if ("assertTrue".equals(x)) {
            return EvalFunc.assertTrue(EvalFunc.scriptLineNumber(), vals);
        }
        System.err.println(new TreeSet<String>(this.sTree.func.keySet()));
        throw new IllegalArgumentException("undefined: '" + x + "'");
    }

    private Object[] preGsub(Object[] args, Object[] vals) {
        if (2 < args.length) {
            Object object = args[2];
            if (object instanceof Node.YyVariable) {
                Node.YyVariable x = (Node.YyVariable)object;
                if ("$[0]".equals(x.toString())) {
                    return Arrays.copyOf(vals, 2);
                }
            } else {
                throw new IllegalArgumentException("Target must be a variable. " + String.valueOf(args[2]) + " " + String.valueOf(args[2].getClass()));
            }
        }
        return vals;
    }

    private void postGsub(Node.YyVariable e) {
        String x = BuiltInVar.RESULT.toString();
        EvalFunc._putValue(e.name, this.mkIndex(e.index), "=", x);
    }

    protected static class Reference
    extends Listener {
        private final String name;
        private final String index;
        private Object value;

        Reference(String name, String index) {
            this.name = name;
            this.index = index;
            this.value = EvalVar._getRefValue(name, index);
        }

        @Override
        public Object apply(Object ... x) {
            return this.value;
        }

        @Override
        public Object update(Object x) {
            this.value = EvalVar._putRefValue(this.name, this.index, x);
            return this.value;
        }

        public String toString() {
            return this.name + "[" + this.index + "] " + String.valueOf(this.value);
        }
    }

    protected class ConcurrentFunction
    extends Function {
        ConcurrentFunction(EvalFunc this$0, Object obj, String name, Object[] args) {
            super(obj, name, args);
        }

        @Override
        public Object apply(Object ... a) {
            SYNC.lock();
            try {
                Object object = super.apply(a);
                return object;
            }
            finally {
                SYNC.unlock();
            }
        }
    }

    protected class Function
    extends Listener {
        private final Object obj;
        private final String name;
        private final Object[] args;
        private final AtomicMap closure;

        Function(Object obj, String name, Object[] args) {
            this.obj = obj;
            this.name = name;
            this.args = (Object[])args.clone();
            this.closure = Frame._cloneLocalContext();
        }

        @Override
        public Object apply(Object ... a) {
            Object[] arr = 0 == a.length ? this.args : a;
            Frame._startNewContext(this.closure);
            return null == this.obj ? EvalFunc.this.userFunction(this.name, arr, arr) : BiBase._invoke(this.obj, this.name, arr);
        }

        @Override
        public Object call() {
            return this.apply(this.args);
        }

        @Override
        public String getName() {
            return this.name.replaceFirst("^.*[$]", "");
        }

        public String toString() {
            return this.name;
        }
    }
}

