/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plus.BiIO;

public class NanoTools {
    private Analysis ana;
    private boolean isRemove;
    private static final char RE_QUOTE = '\'';
    private static final char BOM_QUOTE_BE = '\ufeff';
    private static final Pattern IS_REDIRECT = Pattern.compile("([12]?)(>{1,2})\\s*('?)(.+)");
    private Redirect __STDOUT;
    private Redirect __STDERR;
    private static final Redirect defaultOUT = new Redirect(false, "", "", "/dev/stdout", false);
    private static final Redirect defaultERR = new Redirect(false, "", "", "/dev/stderr", true);
    private static final int STATUS_ERROR = 3;
    private static final int STATUS_WARNING = 2;
    private static final int STATUS_FILE = 1;
    private static final int STATUS_INFORMATION = 1;
    private static final int STATUS_NORMAL = 0;
    private static final int FLAG_ROOT = 1;
    private static final int FLAG_DIRECTORY = 2;
    private static final int FLAG_FILE = 4;
    private static final Pattern IS_PATH_HAS_FILE_UNIX = Pattern.compile("(.*/)*([^/]*)$");
    private static final Pattern IS_PATH_HAS_FILE_WIN = Pattern.compile("(.*[/\\\\])*([^/\\\\]*)$");
    private static final Pattern IS_PATH_HAS_FILE = File.separatorChar == '/' ? IS_PATH_HAS_FILE_UNIX : IS_PATH_HAS_FILE_WIN;
    private final Map<String, Object> optAll = new TreeMap<String, Object>();
    private final Set<String> optIn = new TreeSet<String>();
    private final Set<String> optARGV = new HashSet<String>(32);
    private static int MAX_PATH = 260;
    private static int DISPLAY_WIDTH = 40;
    private static final String FILE = "file";
    private static final String MX_260 = "260";
    private static final String MX_no260 = "no260";
    private static final String ROOT = "root";
    private static final String SYNC = "sync";
    private static final String SIMPLE = "0";
    private static final String COMMA = ",";
    private static final String UNIT = "k";
    private static final String PATH = "path";
    private static final String noRECURSIVE = "noRecursive";
    private static final String MAX_PATH_KEY = "MAX_PATH";
    private static final String DISPLAY_WIDTH_KEY = "DISPLAY_WIDTH";
    private static final Pattern IS_SET = Pattern.compile("(\\w+)=([-+]?\\d+)");
    private static final boolean _STDOUT = true;
    private static final boolean _STDERR = false;
    private static final long FAT_TIME_ERROR = 2000L;
    private static final String NUMBER_UNIT = " KMGTPEZY";
    private static final boolean USE_PATH_NAME = true;
    private static final String RESET = "\u001b[m";
    private static final String RED = "\u001b[91m";
    private static final String GREEN = "\u001b[92m";
    private static final String YELLOW = "\u001b[93m";
    private static final String BLUE = "\u001b[94m";
    private static final String MAGENTA = "\u001b[95m";
    private static final String CYAN = "\u001b[96m";

    private void Initialize(String input, Object ... x) {
        this.ana = new Analysis(input);
        this.isRemove = false;
        this.optAll.clear();
        this.optIn.clear();
        this.optARGV.clear();
        for (Object o : x) {
            String[] opts = o.toString().trim().toLowerCase().split("\\s+");
            this.optARGV.addAll(List.of(opts));
        }
        this.optARGV.remove("");
        this.__STDOUT = defaultOUT;
        this.__STDERR = defaultERR;
        this.redirect(x);
    }

    private void close() {
        this.closeImpl(this.__STDOUT);
        this.closeImpl(this.__STDERR);
    }

    private void closeImpl(Redirect re) {
        try {
            BiIO.fflush(re.file);
            if (re.defined) {
                BiIO.close(re.file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.throwMessage("close", re.name));
        }
    }

    private void redirect(Object ... x) {
        for (Object o : x) {
            String e;
            int ix1;
            if (!(o instanceof String) || (ix1 = (e = (String)o).indexOf(62)) < 0) continue;
            int ix2 = e.indexOf(62, ix1 + 2);
            if (ix2 >= 0) {
                if ((ix2 = e.lastIndexOf(32, ix2)) >= 0) {
                    this.redirectImpl(e.substring(0, ix2));
                    this.redirectImpl(e.substring(ix2 + 1));
                    continue;
                }
                throw new IllegalArgumentException(NanoTools.throwMessage("redirect", e));
            }
            this.redirectImpl(e);
        }
    }

    private void redirectImpl(String input) {
        String src = input.trim().replace("\\'", Character.toString('\ufeff'));
        Matcher m = IS_REDIRECT.matcher(src);
        if (m.find()) {
            String rno = NanoTools.getValue(m.group(1));
            String rid = NanoTools.getValue(m.group(2));
            boolean brackets = !NanoTools.getValue(m.group(3)).isEmpty();
            String file = NanoTools.getValue(m.group(4));
            if (brackets) {
                int ix = file.lastIndexOf(39);
                if (ix >= 0) {
                    file = file.substring(0, ix);
                } else {
                    throw new IllegalArgumentException(NanoTools.throwMessage("Paired <'> mistake", input));
                }
            }
            file = file.trim().replace('\ufeff', '\'');
            String name = rno + rid + file;
            Redirect re = new Redirect(true, name, rid, file, rno.equals("2"));
            if (re.isErr) {
                this.__STDERR = re;
            } else {
                this.__STDOUT = re;
            }
            this.optIn.add(name);
        }
    }

    private static int checkPath(Path input, int flags) {
        Path path = input.normalize().toAbsolutePath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean isRoot = path.equals(path.getRoot());
            if (isRoot && (flags & 1) == 0) {
                NanoTools.rootCannotBeSpecified(input);
                return 3;
            }
            return 0;
        }
        if ((flags & 4) != 0) {
            return Files.exists(path, new LinkOption[0]) ? 0 : 1;
        }
        NanoTools.noSubfolderExist(input);
        return 2;
    }

    private static Path createOutFolder(String output) {
        String src = output.trim();
        Path out = Path.of(src, new String[0]).normalize();
        if (Files.exists(out, new LinkOption[0])) {
            return out;
        }
        try {
            Matcher m = IS_PATH_HAS_FILE.matcher(src);
            if (m.matches()) {
                Path path;
                boolean hasFile = !NanoTools.getValue(m.group(2)).isEmpty();
                Path path2 = path = hasFile ? out.getParent() : out;
                if (null != path) {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.throwMessage("md " + src, e));
        }
        return out;
    }

    private static boolean isLonger260(File input) {
        return input.getPath().length() > MAX_PATH;
    }

    private boolean applyOption(String name, boolean ... value) {
        boolean val = value.length == 0;
        String key = name.toLowerCase();
        String key2 = key.startsWith("no") ? "-" + key.substring(2) : key;
        for (String x : this.optARGV) {
            if (x.isEmpty() || !key.startsWith(x) && !key2.startsWith(x)) continue;
            this.optIn.add(name);
            this.optAll.put(name, val);
            return val;
        }
        this.optAll.put(name, !val);
        return !val;
    }

    private int applyShellVariable(String name, int value) {
        String key = name.toLowerCase();
        for (String x : this.optARGV) {
            if (x.isEmpty()) continue;
            Matcher m = IS_SET.matcher(x);
            while (m.find()) {
                String g1 = NanoTools.getValue(m.group(1));
                if (!key.startsWith(g1)) continue;
                String g2 = NanoTools.getValue(m.group(2));
                int val = Integer.parseInt(g2);
                String var = name + "=" + g2;
                this.optIn.add(BLUE + var + RESET);
                return val;
            }
        }
        this.optIn.add(name + "=" + value);
        return value;
    }

    private boolean getBooOption(String name) {
        Object o;
        if (this.optAll.containsKey(name) && (o = this.optAll.get(name)) instanceof Boolean) {
            Boolean e = (Boolean)o;
            return e;
        }
        throw new RuntimeException(NanoTools.throwMessage("No option", name));
    }

    private void resetOptions(String ... x) {
        for (String key : x) {
            if (!this.optAll.containsKey(key)) {
                throw new RuntimeException(NanoTools.throwMessage("No option", key));
            }
            this.optAll.put(key, false);
            this.optIn.remove(key);
        }
    }

    private String listOptions() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(BLUE);
        for (String x : this.optIn) {
            sb.append(' ').append(x);
        }
        return sb.append(RESET).toString();
    }

    private static boolean isSystem(Path path) {
        String str = path.toString();
        return str.contains("System Volume Information") || str.contains("$RECYCLE.BIN");
    }

    private static boolean isSystem(File path) {
        return NanoTools.isSystem(path.toPath());
    }

    private boolean isMatch(Path path) {
        return this.isMatch(path.toFile());
    }

    private boolean isMatch(File path) {
        if (path.exists() && !path.isDirectory()) {
            if (this.ana.alwaysTrue) {
                return true;
            }
            String name = path.getName();
            return this.ana.regex.matcher(name).matches();
        }
        return false;
    }

    private static void setLastModified(Path path, long time) {
        File file = path.toFile();
        if (0L < time && time != file.lastModified() && !file.setLastModified(time)) {
            throw new RuntimeException(NanoTools.throwMessage("setLastModified", path));
        }
    }

    private boolean safetyRemove(Path path) {
        return this.isRemove && Files.exists(path, new LinkOption[0]) && !NanoTools.isSystem(path) && path.toFile().delete();
    }

    private void printX(boolean stdout, String x) {
        Redirect re = stdout ? this.__STDOUT : this.__STDERR;
        BiIO.print(re.rid, re.file, x);
    }

    private void printX(boolean stdout, File file, boolean ... type) {
        Redirect re;
        Redirect redirect = re = stdout ? this.__STDOUT : this.__STDERR;
        if (re.defined()) {
            this.printX(stdout, NanoTools.applySlashSeparator(file, type));
        } else {
            this.printX(stdout, NanoTools.truncatePath(file, type));
        }
    }

    private String sprintX(boolean stdout, File file, boolean ... type) {
        Redirect re;
        Redirect redirect = re = stdout ? this.__STDOUT : this.__STDERR;
        if (re.defined()) {
            return NanoTools.applySlashSeparator(file, type);
        }
        return NanoTools.truncatePath(file, type);
    }

    public int set(Object ... x) {
        this.Initialize("./", x);
        boolean hasARGV = this.optARGV.size() > 0;
        MAX_PATH = this.applyShellVariable(MAX_PATH_KEY, MAX_PATH);
        DISPLAY_WIDTH = this.applyShellVariable(DISPLAY_WIDTH_KEY, DISPLAY_WIDTH);
        String args = hasARGV ? this.listOptions() : "";
        NanoTools.messageTitle("set", args);
        if (!hasARGV) {
            for (String k : this.optIn) {
                System.out.println(k);
            }
        }
        NanoTools.messageCYAN("Number of processed", this.optIn.size());
        return 0;
    }

    public int copy(String input, String output, Object ... x) {
        this.Initialize(input, x);
        Path in = this.ana.path;
        Path out = NanoTools.createOutFolder(output);
        this.isRemove = this.applyOption(SYNC, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + " " + output + this.listOptions();
        NanoTools.messageTitle("copy", args);
        if (in.compareTo(out) == 0) {
            NanoTools.inputAndOutputAreSamePath(in);
            return 3;
        }
        int rc = NanoTools.checkPath(in, 7);
        int ro = NanoTools.checkPath(out, 7);
        if ((rc = Math.max(rc, ro)) <= 1) {
            TreeSet<File> set = new TreeSet<File>();
            if (this.isRemove) {
                this.copySync(set, in, out);
                if (set.size() > 0) {
                    for (File sync : set) {
                        this.printX(false, sync, new boolean[0]);
                    }
                    NanoTools.messageCYAN("Synchronized", set.size());
                    set.clear();
                }
            }
            this.copyImpl(set, in, out, isRecursive);
            for (File file : set) {
                this.printX(true, file, new boolean[0]);
            }
            this.isRemove = true;
            this.setDateForChildElement(out);
            NanoTools.messageCYAN("Number of processed", set.size());
        }
        this.close();
        return rc;
    }

    private void copyImpl(Set<File> set, Path input, Path output, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            File[] files = input.toFile().listFiles();
            if (null != files) {
                for (File file : files) {
                    if (NanoTools.isSystem(file)) continue;
                    Path newIn = file.toPath();
                    Path newOut = output.resolve(newIn.getFileName());
                    if (file.isDirectory()) {
                        if (!recursive) continue;
                        NanoTools.createDirectory(newIn, newOut);
                        this.copyImpl(set, newIn, newOut, recursive);
                        continue;
                    }
                    this.atomicSingleCopy(set, newIn, newOut);
                }
            }
        } else {
            this.atomicSingleCopy(set, input, output);
        }
    }

    private void copySync(Set<File> syn, Path input, Path output) {
        File[] files;
        HashMap<String, File> map = new HashMap<String, File>(256);
        if (NanoTools.isSystem(input) || NanoTools.isSystem(output)) {
            return;
        }
        if (Files.isDirectory(output, new LinkOption[0]) && null != (files = output.toFile().listFiles())) {
            for (File file : files) {
                if (NanoTools.isSystem(file)) continue;
                map.put(file.getName(), file);
            }
        }
        if (Files.exists(output, new LinkOption[0])) {
            File file = output.toFile();
            map.put(file.getName(), file);
        }
        if (Files.isDirectory(input, new LinkOption[0]) && null != (files = input.toFile().listFiles())) {
            for (File file : files) {
                if (NanoTools.isSystem(file)) continue;
                String name = file.getName();
                Path newIn = file.toPath();
                Path newOut = output.resolve(name);
                map.remove(name);
                if (!file.isDirectory()) continue;
                this.copySync(syn, newIn, newOut);
            }
        }
        if (Files.exists(input, new LinkOption[0])) {
            String name = input.toFile().getName();
            map.remove(name);
        }
        for (File file : map.values()) {
            this.copySyncRemove(syn, file.toPath());
        }
    }

    private void copySyncRemove(Set<File> syn, Path input) {
        boolean isFile;
        if (NanoTools.isSystem(input)) {
            return;
        }
        File[] files = input.toFile().listFiles();
        if (null != files) {
            for (File file : files) {
                if (NanoTools.isSystem(file)) continue;
                Path in = file.toPath();
                if (file.isDirectory()) {
                    this.copySyncRemove(syn, in);
                    this.safetyRemove(in);
                    continue;
                }
                if (!this.safetyRemove(in)) continue;
                syn.add(file);
            }
        }
        boolean bl = isFile = !Files.isDirectory(input, new LinkOption[0]);
        if (this.safetyRemove(input) && isFile) {
            syn.add(input.toFile());
        }
    }

    public int move(String input, String output, Object ... x) {
        this.Initialize(input, x);
        Path in = this.ana.path;
        Path out = NanoTools.createOutFolder(output);
        this.isRemove = true;
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + " " + output + this.listOptions();
        NanoTools.messageTitle("move", args);
        if (in.compareTo(out) == 0) {
            NanoTools.inputAndOutputAreSamePath(in);
            return 3;
        }
        int rc = NanoTools.checkPath(in, 7);
        int ro = NanoTools.checkPath(out, 7);
        if ((rc = Math.max(rc, ro)) <= 1) {
            TreeSet<File> set = new TreeSet<File>();
            this.moveImpl(set, in, out, isRecursive);
            for (File file : set) {
                this.printX(true, file, new boolean[0]);
            }
            this.setDateForChildElement(out);
            NanoTools.messageCYAN("Number of processed", set.size());
        }
        this.close();
        return rc;
    }

    private void moveImpl(Set<File> set, Path input, Path output, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            File[] files = input.toFile().listFiles();
            if (null != files) {
                for (File file : files) {
                    if (NanoTools.isSystem(file)) continue;
                    Path newIn = file.toPath();
                    Path newOut = output.resolve(newIn.getFileName());
                    if (file.isDirectory()) {
                        if (!recursive) continue;
                        NanoTools.createDirectory(newIn, newOut);
                        this.moveImpl(set, newIn, newOut, recursive);
                        this.safetyRemove(newIn);
                        continue;
                    }
                    this.atomicSingleMove(set, newIn, newOut);
                }
            } else if (Files.exists(input, new LinkOption[0])) {
                long lastMod = input.toFile().lastModified();
                NanoTools.setLastModified(output, lastMod);
            }
        } else {
            this.atomicSingleMove(set, input, output);
            this.safetyRemove(input);
        }
        this.safetyRemove(input);
    }

    private long setDateForChildElement(Path input) {
        File[] files;
        if (NanoTools.isSystem(input)) {
            return 0L;
        }
        long modTime = 0L;
        if (Files.isDirectory(input, new LinkOption[0]) && null != (files = input.toFile().listFiles())) {
            for (File file : files) {
                if (NanoTools.isSystem(file)) continue;
                Path path = file.toPath();
                long time = file.isDirectory() ? this.setDateForChildElement(path) : file.lastModified();
                if (modTime >= time) continue;
                modTime = time;
            }
        }
        if (Files.isDirectory(input, new LinkOption[0]) && !this.safetyRemove(input)) {
            NanoTools.setLastModified(input, modTime);
        }
        return modTime;
    }

    private synchronized void atomicSingleCopy(Set<File> set, Path input, Path output) {
        try {
            output = this.isAtomicSameFile(input, output);
            if (output == null) {
                return;
            }
            Files.deleteIfExists(output);
            Files.copy(input, output, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            if (Files.exists(output, new LinkOption[0])) {
                set.add(input.toFile());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.throwMessage("copy", e));
        }
    }

    private synchronized void atomicSingleMove(Set<File> set, Path input, Path output) {
        try {
            output = this.isAtomicSameFile(input, output);
            if (output == null) {
                return;
            }
            Files.deleteIfExists(output);
            Files.move(input, output, StandardCopyOption.REPLACE_EXISTING);
            if (Files.exists(output, new LinkOption[0])) {
                set.add(input.toFile());
                this.safetyRemove(input);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.throwMessage("move", e));
        }
    }

    private Path isAtomicSameFile(Path input, Path output) {
        Path outParent;
        if (!Files.exists(input, new LinkOption[0]) || Files.isDirectory(input, new LinkOption[0])) {
            throw new RuntimeException(NanoTools.throwMessage("File required", input));
        }
        if (!this.isMatch(input)) {
            return null;
        }
        if (NanoTools.isSystem(input)) {
            return null;
        }
        if (Files.exists(output, new LinkOption[0]) && Files.isDirectory(output, new LinkOption[0])) {
            output = output.resolve(input.getFileName());
        }
        if (input.compareTo(output) == 0) {
            return null;
        }
        Path inParent = input.getParent();
        if (inParent != null && (outParent = output.getParent()) != null) {
            NanoTools.createDirectory(inParent, outParent);
        }
        if (Files.exists(output, new LinkOption[0]) && !Files.isDirectory(output, new LinkOption[0]) && input.getFileName().equals(output.getFileName())) {
            File iFile = input.toFile();
            File oFile = output.toFile();
            boolean length = iFile.length() == oFile.length();
            long iMod = iFile.lastModified() / 2000L;
            long oMod = oFile.lastModified() / 2000L;
            if (length && iMod == oMod) {
                return null;
            }
        }
        return output;
    }

    private static void createDirectory(Path input, Path output) {
        try {
            if (Files.isDirectory(input, new LinkOption[0])) {
                FileTime fileTime = Files.getLastModifiedTime(input, new LinkOption[0]);
                if (!Files.exists(output, new LinkOption[0])) {
                    Files.createDirectories(output, new FileAttribute[0]);
                }
                Files.setLastModifiedTime(output, fileTime);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.throwMessage("Create directory", output));
        }
    }

    public int remove(String input, Object ... x) {
        int rc;
        this.Initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = true;
        boolean isRoot = this.applyOption(ROOT, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("remove", args);
        int flags = 6;
        if (isRoot) {
            flags |= 1;
        }
        if ((rc = NanoTools.checkPath(in, flags)) <= 1) {
            TreeSet<File> set = new TreeSet<File>();
            this.removeImpl(set, in, isRecursive);
            for (File remove : set) {
                if (remove.isDirectory()) continue;
                this.printX(true, remove, new boolean[0]);
            }
            this.setDateForChildElement(in);
            NanoTools.messageCYAN("Number of processed", set.size());
        }
        this.close();
        return rc;
    }

    private void removeImpl(Set<File> set, Path input, boolean recursive) {
        block13: {
            if (NanoTools.isSystem(input)) {
                return;
            }
            if (Files.isDirectory(input, new LinkOption[0])) {
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                    for (Path path : ds) {
                        if (NanoTools.isSystem(path)) continue;
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            if (!recursive) continue;
                            this.removeImpl(set, path, recursive);
                            if (!this.safetyRemove(path)) continue;
                            set.add(path.toFile());
                            continue;
                        }
                        if (!this.isMatch(path) || !this.safetyRemove(path)) continue;
                        set.add(path.toFile());
                    }
                    this.safetyRemove(input);
                    break block13;
                }
                catch (IOException e) {
                    throw new RuntimeException(NanoTools.throwMessage("remove", e));
                }
            }
            if (this.isMatch(input) && Files.exists(input, new LinkOption[0])) {
                this.safetyRemove(input);
                set.add(input.toFile());
            }
        }
    }

    public int tree(String input, Object ... x) {
        this.Initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = false;
        boolean isFile = this.applyOption(FILE, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("tree", args);
        int rc = NanoTools.checkPath(in, 3);
        if (rc <= 1) {
            int max = this.treeImpl(in.toFile(), "", isFile, isRecursive);
            NanoTools.messageCYAN(MAX_PATH_KEY, max + " chars");
        }
        this.close();
        return rc;
    }

    private int treeImpl(File input, String indent, boolean isFile, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return 0;
        }
        int max = 0;
        if (input.isDirectory()) {
            File[] files = input.listFiles();
            if (null != files) {
                String x;
                TreeSet<File> set = new TreeSet<File>(List.of(files));
                for (File file : set) {
                    if (NanoTools.isSystem(file) || !file.isFile() || !this.isMatch(file)) continue;
                    if (isFile) {
                        x = indent + "| " + this.truncateTree(file);
                        this.printX(true, x);
                    }
                    max = Math.max(max, file.getPath().length());
                }
                for (File file : set) {
                    if (NanoTools.isSystem(file) || !file.isDirectory() || NanoTools.isSystem(file)) continue;
                    x = indent + "/" + this.truncateTree(file);
                    this.printX(true, x);
                    max = Math.max(max, file.getPath().length());
                    if (!recursive) continue;
                    max = Math.max(max, this.treeImpl(file, indent + " ", isFile, recursive));
                }
            } else if (this.isMatch(input)) {
                if (isFile) {
                    String x = indent + "| " + this.truncateTree(input);
                    this.printX(true, x);
                }
                max = input.getPath().length();
            }
        }
        return max;
    }

    public int ls(String input, Object ... x) {
        boolean isAttr;
        this.Initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = false;
        boolean isPath = this.applyOption(PATH, new boolean[0]);
        boolean isSimple = this.applyOption(SIMPLE, new boolean[0]);
        boolean isComma = this.applyOption(COMMA, new boolean[0]);
        boolean isUnit = this.applyOption(UNIT, new boolean[0]);
        boolean is260 = this.applyOption(MX_260, new boolean[0]);
        boolean isNo260 = this.applyOption(MX_no260, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        boolean bl = isAttr = isPath || isSimple || isComma || isUnit;
        if (isPath) {
            this.resetOptions(SIMPLE, COMMA, UNIT);
        }
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("ls", args);
        int rc = NanoTools.checkPath(in, 3);
        if (rc <= 1) {
            TreeSet<File> set = new TreeSet<File>();
            this.lsImpl(set, in.toFile(), is260, isNo260, isRecursive);
            for (File file : set) {
                String ls = this.lsAttr(file, isAttr);
                this.printX(true, ls);
            }
            NanoTools.messageCYAN("Number of processed", set.size());
        }
        this.close();
        return rc;
    }

    private void lsImpl(Set<File> set, File input, boolean is260, boolean isNo260, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (input.isDirectory()) {
            File[] files = input.listFiles();
            if (null != files) {
                for (File file : files) {
                    if (NanoTools.isSystem(file)) continue;
                    if (file.isDirectory()) {
                        if (!recursive) continue;
                        this.lsImpl(set, file, is260, isNo260, recursive);
                        continue;
                    }
                    this.lsSelect260(set, file, is260, isNo260);
                }
            } else {
                this.lsSelect260(set, input, is260, isNo260);
            }
        }
    }

    private String lsAttr(File input, boolean isAttr) {
        StringBuilder sb = new StringBuilder(256);
        if (isAttr) {
            SimpleDateFormat sdf = new SimpleDateFormat("yy/MM/dd HH:mm");
            String daytime = sdf.format(input.lastModified());
            String len = this.lsLength(this.getBooOption(PATH) ? (long)input.getPath().length() : input.length());
            sb.append(daytime).append('\t');
            sb.append(len).append('\t');
        }
        String path = this.sprintX(true, input, new boolean[0]);
        return sb.append(path).toString();
    }

    private void lsSelect260(Set<File> set, File input, boolean is260, boolean isNo260) {
        if (this.isMatch(input)) {
            if (is260) {
                if (NanoTools.isLonger260(input)) {
                    set.add(input);
                }
            } else if (isNo260) {
                if (!NanoTools.isLonger260(input)) {
                    set.add(input);
                }
            } else {
                set.add(input);
            }
        }
    }

    private String lsLength(long len) {
        if (this.getBooOption(PATH)) {
            return String.format("%, 7d", len);
        }
        if (this.getBooOption(COMMA)) {
            return String.format("%,d", len);
        }
        if (this.getBooOption(UNIT)) {
            for (int i = 0; i < NUMBER_UNIT.length(); ++i) {
                if (len < 1024L) {
                    String unit = Character.toString(NUMBER_UNIT.charAt(i));
                    return String.format("%3d %s", len, unit);
                }
                len /= 1024L;
            }
        }
        return Long.toString(len);
    }

    private String truncateTree(File input) {
        StringBuilder sb = new StringBuilder(DISPLAY_WIDTH + 16);
        sb.append(this.sprintX(true, input, true)).append(' ');
        String path = input.getPath();
        String name = input.getName();
        String info = name.length() + "/" + path.length();
        String maxPathID = NanoTools.isLonger260(input) ? " *" : "";
        sb.append((String)(maxPathID.isEmpty() ? info : NanoTools.color(MAGENTA, info + maxPathID)));
        return sb.toString();
    }

    private static String truncatePath(File input, boolean ... type) {
        String path = NanoTools.applySlashSeparator(input, type);
        int len = path.length();
        if (DISPLAY_WIDTH < len) {
            int PathUnitHalfSize = DISPLAY_WIDTH / 2;
            return path.substring(0, PathUnitHalfSize) + "\u2026" + path.substring(len - PathUnitHalfSize);
        }
        return path;
    }

    private static String applySlashSeparator(File input, boolean ... type) {
        if (type.length != 0) {
            return input.getName();
        }
        String path = input.getPath();
        return File.separatorChar == '/' ? path : path.replace('\\', '/');
    }

    static String color(String color, String message) {
        return color + message + RESET;
    }

    private static void messageTitle(String name, Object arg) {
        System.out.println(NanoTools.color(YELLOW, name + " ") + String.valueOf(arg));
    }

    private static void messageCYAN(String name, Object arg) {
        System.err.println(NanoTools.color(CYAN, name + ": ") + String.valueOf(arg));
    }

    private static void messageGREEN(String name, Object arg) {
        System.err.println(NanoTools.color(GREEN, name + ": ") + String.valueOf(arg));
    }

    private static void messageMAGENTA(String name, Object arg) {
        System.err.println(NanoTools.color(MAGENTA, name + ": ") + String.valueOf(arg));
    }

    private static void messageRED(String name, Object arg) {
        System.err.println(NanoTools.color(RED, name + ": ") + String.valueOf(arg));
    }

    private static String throwMessage(String name, Object arg) {
        return NanoTools.color(RED, name + ": ") + String.valueOf(arg);
    }

    private static void rootCannotBeSpecified(Path path) {
        NanoTools.messageRED("Root folder cannot be specified", NanoTools.applySlashSeparator(path.toFile(), new boolean[0]));
    }

    private static void inputAndOutputAreSamePath(Path path) {
        NanoTools.messageRED("Input and output are the same path", NanoTools.applySlashSeparator(path.toFile(), new boolean[0]));
    }

    private static void noSubfolderExist(Path path) {
        NanoTools.messageMAGENTA("Path does not defined", NanoTools.applySlashSeparator(path.toFile(), new boolean[0]));
    }

    private static String getValue(String x) {
        return x == null ? "" : x;
    }

    static class Analysis {
        private static final Pattern SPLIT_PATH = IS_PATH_HAS_FILE;
        private static final Pattern WILD_CARD_ALL = Pattern.compile(".*");
        final String virtualPath;
        final Path path;
        final Pattern regex;
        final boolean alwaysTrue;

        Analysis(String input) {
            String g2;
            String path = input.trim();
            String wild = "";
            Pattern regex = WILD_CARD_ALL;
            Matcher m = SPLIT_PATH.matcher(path);
            if (m.matches() && Analysis.hasWildcard(g2 = NanoTools.getValue(m.group(2).trim()))) {
                path = NanoTools.getValue(m.group(1)).trim();
                wild = g2;
                regex = Analysis.mkWildcard(g2);
            }
            if (path.isEmpty()) {
                path = "./";
            }
            this.path = Path.of(path, new String[0]);
            this.virtualPath = path + (wild.isEmpty() ? "" : NanoTools.color(NanoTools.BLUE, wild));
            this.regex = regex;
            this.alwaysTrue = WILD_CARD_ALL.equals(regex);
        }

        private static boolean hasWildcard(String wild) {
            for (int i = 0; i < wild.length(); ++i) {
                char c = wild.charAt(i);
                if (0 > "*?|".indexOf(c)) continue;
                return true;
            }
            return wild.endsWith(".");
        }

        private static Pattern mkWildcard(String wild) {
            StringBuilder sb = new StringBuilder(128);
            if (wild.endsWith(".")) {
                wild = wild.substring(0, wild.length() - 1);
            }
            if (wild.isEmpty()) {
                wild = "*";
            }
            block5: for (int i = 0; i < wild.length(); ++i) {
                char c = wild.charAt(i);
                switch (c) {
                    case '*': {
                        sb.append(".*");
                        continue block5;
                    }
                    case '?': {
                        sb.append('.');
                        continue block5;
                    }
                    case '.': {
                        sb.append("\\.");
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return Pattern.compile(sb.toString(), 2);
        }
    }

    record Redirect(boolean defined, String name, String rid, String file, boolean isErr) {
    }
}

