/** AWK~plus - Image Viewer.
 */
import java.awt.Point
import java.awt.event.ActionListener
import java.awt.event.MouseEvent
import javax.swing.ImageIcon
import javax.swing.JFrame
import javax.swing.JLabel
import javax.swing.SwingConstants
import javax.swing.Timer
import plus.awt.Mouse
import plus.reflect.Reflection
val imageLabel = new JLabel("", SwingConstants.CENTER)
val frame = new JFrame("AWK~plus - ImageViewer")
val DELAY_SECONDS = 10  # 表示間隔
val FRAME_HEIGHT = 600  # 画像サイズ
val FRAME_WIDTH = 400
var imgnumber = 0
var images = ""
var imgpos = -1
BEGIN {
    images = ARGV[1]    # 画像のパス
    imgnumber = ARGV[2] # 画像の枚数
    frame.setDefaultCloseOperation(3)
    val dim = frame.getToolkit().getScreenSize
    frame.setLocation(new Point(dim.width - 8 - FRAME_WIDTH, dim.height - 32 - FRAME_HEIGHT))
    val container = frame.getContentPane
        container.add(imageLabel)
    val adapter = new Mouse(.mouseDragged(null), .mousePressed(null))
        container.addMouseListener(adapter); container.addMouseMotionListener(adapter)
    actionPerformed(null)
    frame.pack
    frame.setVisible(true)
    val actionListener: ActionListener =
        Reflection.implement("java.awt.event.ActionListener", .actionPerformed(null))
    new Timer(1000 * DELAY_SECONDS, actionListener).start
}
function actionPerformed(actionEvent) {
    imgpos = ++imgpos % imgnumber
    imageLabel.setIcon(new ImageIcon(images "/" imgpos ".jpg"))
}
function mouseDragged(e: MouseEvent) {
    val opacity: Float = 0.01 * (100 - Math.abs(e.getY) % 100)
    frame.setOpacity(opacity)  # Java8 No longer supported
}
function mousePressed(e: MouseEvent) {  # Right button click
    if (1 != e.getButton) frame.setAlwaysOnTop(!frame.isAlwaysOnTop)
}