/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plus.BiIO;

public class NanoTools {
    private final ExecutorService pool = Executors.newWorkStealingPool();
    private final Set<File> set = new TreeSet<File>();
    private final List<Path> drop = new ArrayList<Path>(192);
    private final Map<Path, FileTime> mod = new HashMap<Path, FileTime>(192);
    private final AtomicInteger atom = new AtomicInteger();
    private long start;
    private Analysis ana;
    private boolean isRemove;
    private int DISPLAY_WIDTH = 40;
    private int MAX_PATH = 260;
    private static final String DISPLAY_WIDTH_KEY = "DISPLAY_WIDTH";
    private static final String MAX_PATH_KEY = "MAX_PATH";
    private static final int STATUS_ERROR = 3;
    private static final int STATUS_WARNING = 2;
    private static final int STATUS_FILE = 1;
    private static final int STATUS_INFORMATION = 1;
    private static final int STATUS_NORMAL = 0;
    private static final int CHK_ROOT = 1;
    private static final int CHK_DIRECTORY = 2;
    private static final int CHK_FILE = 4;
    private static final String RE_QUOTE = "'";
    private static final String RE_ESCAPE_01 = "\\'";
    private static final String RE_ESCAPE_02 = "''";
    private static final String BOM_QUOTE_BE = "\ufeff";
    private static final Pattern IS_REDIRECT = Pattern.compile("([12]?)(>{1,2})\\s*('?)(.+)");
    private Redirect __STDOUT;
    private Redirect __STDERR;
    private static final Redirect defaultOUT = new Redirect(false, "", "", "/dev/stdout", false);
    private static final Redirect defaultERR = new Redirect(false, "", "", "/dev/stderr", true);
    private final Map<String, Object> optAll = new TreeMap<String, Object>();
    private final Set<String> optIn = new TreeSet<String>();
    private final Set<String> optARGV = new HashSet<String>(32);
    private static final String CLEAN = "clean";
    private static final String COMMA = ",";
    private static final String FILE = "file";
    private static final String MX_260 = "260";
    private static final String MX_no260 = "no260";
    private static final String PATH = "path";
    private static final String PRO = "progress";
    private static final String ROOT = "root";
    private static final String SIMPLE = "0";
    private static final String SYNC = "sync";
    private static final String UNIT = "k";
    private static final String noRECURSIVE = "noRecursive";
    private static final String noTIME = "noTime";
    private static final Pattern IS_SET = Pattern.compile("(\\w+)=([-+]?\\d+)");
    private static final boolean _STDOUT = true;
    private static final boolean _STDERR = false;
    private static final int CLN_MOD_TIME = 1;
    private static final int CLN_EMPTY_FOLDER = 2;
    private static final int clean_FILE = 0;
    private static final int clean_FOLDER = 1;
    private static final int ACT_SKIP = -2;
    private static final int ACT_SAME_PATH = -1;
    private static final int ACT_SAME_FILE = 0;
    private static final int ACT_ACCEPT = 1;
    private static final boolean _COPY = true;
    private static final boolean _MOVE = false;
    private static final Action ACTION_HAS_SKIP = new Action(-2, null);
    private static final Action ACTION_HAS_SAME_PATH = new Action(-1, null);
    private static final long FAT_TIME_ERROR = 2000L;
    private static final String NUMBER_UNIT = "BKMGTPEZY";
    private static final boolean USE_PATH_NAME = true;
    private static final String RESET = "\u001b[m";
    private static final String RED = "\u001b[91m";
    private static final String GREEN = "\u001b[92m";
    private static final String YELLOW = "\u001b[93m";
    private static final String BLUE = "\u001b[94m";
    private static final String MAGENTA = "\u001b[95m";
    private static final String CYAN = "\u001b[96m";

    private void initialize(String input, Object ... x) {
        this.start = System.currentTimeMillis();
        this.ana = new Analysis(input, this.DISPLAY_WIDTH);
        this.isRemove = false;
        this.atom.set(0);
        this.set.clear();
        this.mod.clear();
        this.drop.clear();
        this.optAll.clear();
        this.optIn.clear();
        this.optARGV.clear();
        for (Object o : x) {
            String[] opts = o.toString().trim().toLowerCase().split("\\s+");
            this.optARGV.addAll(List.of(opts));
        }
        this.optARGV.remove("");
        this.__STDOUT = defaultOUT;
        this.__STDERR = defaultERR;
        this.redirect(x);
    }

    private void close() {
        this.closeImpl(this.__STDOUT);
        this.closeImpl(this.__STDERR);
    }

    private void closeImpl(Redirect re) {
        try {
            BiIO.fflush(re.file);
            if (re.redirect) {
                BiIO.close(re.file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(this.exception("close", re.name));
        }
    }

    private static Path getParent(Path path) {
        Path pa = Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
        return pa == null ? path.getRoot() : pa;
    }

    private Output createOutFolder(Path input, String output) {
        Path parent;
        String src = output.trim();
        Path out = Path.of(src, new String[0]);
        Path in = NanoTools.getParent(input);
        boolean createHolder = false;
        if (src.endsWith("/")) {
            if (Files.notExists(out, new LinkOption[0]) && this.createFolder(in, out)) {
                createHolder = true;
            }
        } else if (!Files.isDirectory(out, new LinkOption[0]) && (parent = NanoTools.getParent(out)) != null && Files.notExists(parent, new LinkOption[0]) && this.createFolder(in, parent)) {
            createHolder = true;
        }
        return new Output(out, createHolder);
    }

    private void finishAsyncIO(Progress pro, Path output) {
        try {
            while (this.atom.get() > 0) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        pro.flush();
        this.finishAsyncIOImpl(pro, NanoTools.getParent(output));
    }

    private void finishAsyncIOImpl(Progress pro, Path output) {
        if (NanoTools.isSystem(output)) {
            return;
        }
        if (Files.isDirectory(output, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(output);){
                for (Path path : ds) {
                    if (!Files.isDirectory(path, new LinkOption[0]) || NanoTools.isSystem(path)) continue;
                    this.finishAsyncIOImpl(pro, path);
                }
                if (this.removeStartFolder(output)) {
                    pro.decrementFolder();
                } else {
                    FileTime time = this.mod.get(output);
                    if (time != null) {
                        Files.setLastModifiedTime(output, time);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(this.exception("cleanup", e));
            }
        }
    }

    private void finishAsyncDropFileMove(Path input) {
        for (Path path : this.drop) {
            this.removeSafetyFile(path);
        }
        this.finishAsyncDropFileImpl(NanoTools.getParent(input));
    }

    private void finishAsyncDropFileImpl(Path input) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                for (Path path : ds) {
                    if (!Files.isDirectory(path, new LinkOption[0]) || NanoTools.isSystem(path)) continue;
                    this.finishAsyncDropFileImpl(path);
                }
                this.removeNoTime0Folder(input);
            }
            catch (IOException e) {
                throw new RuntimeException(this.exception("moveDrop", e));
            }
        }
    }

    private static int checkPath(Path input, int flags) {
        Path path = input.toAbsolutePath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean isRoot = path.equals(path.getRoot());
            if (isRoot && (flags & 1) == 0) {
                NanoTools.rootCannotBeSpecified(input);
                return 3;
            }
            return 0;
        }
        if ((flags & 4) != 0) {
            return Files.exists(path, new LinkOption[0]) ? 0 : 1;
        }
        NanoTools.wrongPathSpecified(input);
        return 2;
    }

    private void redirect(Object ... x) {
        for (Object o : x) {
            String arg = o.toString().trim();
            int ix1 = arg.indexOf(62);
            if (ix1 < 0) continue;
            int ix2 = arg.indexOf(62, ix1 + 2);
            if (ix2 >= 0) {
                if ((ix2 = arg.lastIndexOf(32, ix2)) >= 0) {
                    this.redirectImpl(arg.substring(0, ix2));
                    this.redirectImpl(arg.substring(ix2 + 1));
                    continue;
                }
                throw new IllegalArgumentException(this.exception("redirect", arg));
            }
            this.redirectImpl(arg);
        }
    }

    private void redirectImpl(String redirect) {
        String src = redirect.trim().replace(RE_ESCAPE_01, BOM_QUOTE_BE).replace(RE_ESCAPE_02, BOM_QUOTE_BE);
        Matcher m = IS_REDIRECT.matcher(src);
        if (m.find()) {
            String rno = NanoTools.getValue(m.group(1));
            String rid = NanoTools.getValue(m.group(2));
            boolean brackets = !NanoTools.getValue(m.group(3)).isEmpty();
            String file = NanoTools.getValue(m.group(4));
            if (brackets) {
                int ix = file.lastIndexOf(RE_QUOTE);
                if (ix >= 0) {
                    file = file.substring(0, ix);
                } else {
                    throw new IllegalArgumentException(this.exception("Paired <'> mistake", redirect));
                }
            }
            file = file.trim().replace(BOM_QUOTE_BE, RE_QUOTE);
            String name = rno + rid + file;
            Redirect re = new Redirect(true, name, rid, file, rno.equals("2"));
            if (re.isErr) {
                this.__STDERR = re;
            } else {
                this.__STDOUT = re;
            }
            this.optIn.add(name);
        }
    }

    private boolean isLonger260(Path input) {
        return input.toString().length() > this.MAX_PATH;
    }

    private boolean applyOption(String name, boolean ... value) {
        boolean val = value.length == 0;
        String key = name.toLowerCase();
        String key2 = key.startsWith("no") ? "-" + key.substring(2) : key;
        for (String x : this.optARGV) {
            if (x.isEmpty() || !key.startsWith(x) && !key2.startsWith(x)) continue;
            this.optIn.add(name);
            this.optAll.put(name, val);
            return val;
        }
        this.optAll.put(name, !val);
        return !val;
    }

    private int applyShellVariable(String name, int value) {
        String key = name.toLowerCase();
        for (String x : this.optARGV) {
            if (x.isEmpty()) continue;
            Matcher m = IS_SET.matcher(x);
            while (m.find()) {
                String g1 = NanoTools.getValue(m.group(1));
                if (!key.startsWith(g1)) continue;
                String g2 = NanoTools.getValue(m.group(2));
                int val = Integer.parseInt(g2);
                String var = name + "=" + g2;
                this.optIn.add(BLUE + var + RESET);
                return val;
            }
        }
        this.optIn.add(name + "=" + value);
        return value;
    }

    private boolean getBooOption(String key) {
        Object o;
        if (this.optAll.containsKey(key) && (o = this.optAll.get(key)) instanceof Boolean) {
            Boolean e = (Boolean)o;
            return e;
        }
        throw new RuntimeException(this.exception("No option", key));
    }

    private void resetOptions(String ... x) {
        for (String key : x) {
            if (!this.optAll.containsKey(key)) {
                throw new RuntimeException(this.exception("No option", key));
            }
            this.optAll.put(key, false);
            this.optIn.remove(key);
        }
    }

    private String listOptions() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(BLUE);
        for (String x : this.optIn) {
            sb.append(' ').append(x);
        }
        return sb.append(RESET).toString();
    }

    private static boolean isSystem(Path path) {
        String str = path.toString();
        return str.contains("System Volume Information") || str.contains("$RECYCLE.BIN");
    }

    private static boolean isSystem(File path) {
        return NanoTools.isSystem(path.toPath());
    }

    private boolean isMatch(Path path) {
        return this.isMatch(path.toFile());
    }

    private boolean isMatch(File path) {
        if (path.exists() && !path.isDirectory()) {
            if (this.ana.alwaysTrue) {
                return true;
            }
            String name = path.getName();
            return this.ana.regex.matcher(name).matches();
        }
        return false;
    }

    private boolean removeStartFolder(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean started = this.getModifiedTime(path).toMillis() >= this.start;
            return started && this.removeSafetyFolder(path);
        }
        return false;
    }

    private boolean removeNoTime0Folder(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean time0 = this.getModifiedTime(path).toMillis() != 0L;
            return time0 && this.removeSafetyFolder(path);
        }
        return false;
    }

    private boolean removeSafetyFolder(Path path) {
        File file = path.toFile();
        return this.isRemove && !NanoTools.isSystem(path) && Files.isDirectory(path, new LinkOption[0]) && file.delete();
    }

    private boolean removeSafetyFile(Path path) {
        File file = path.toFile();
        return this.isRemove && !NanoTools.isSystem(path) && file.isFile() && file.delete();
    }

    private long getFileSize(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw new RuntimeException(this.exception("getFileSize", e));
        }
    }

    private FileTime getModifiedTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(this.exception("getModifiedTime", e));
        }
    }

    private void setModifiedTime(Path path, FileTime time) {
        try {
            Files.setLastModifiedTime(path, time);
        }
        catch (IOException e) {
            throw new RuntimeException(this.exception("setModifiedTime", e));
        }
    }

    private boolean createFolder(Path input, Path output) {
        try {
            FileTime time = this.getModifiedTime(input);
            this.mod.put(output, time);
            if (Files.notExists(output, new LinkOption[0])) {
                Files.createDirectories(output, new FileAttribute[0]);
                if (time.toMillis() == 0L) {
                    this.setModifiedTime(output, time);
                }
                return true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(this.exception("Make directory", e));
        }
        return false;
    }

    private void printX(boolean stdout, String x) {
        Redirect re = stdout ? this.__STDOUT : this.__STDERR;
        BiIO.print(re.rid, re.file, x);
    }

    private void printX(boolean stdout, File file, boolean ... type) {
        Redirect re;
        Redirect redirect = re = stdout ? this.__STDOUT : this.__STDERR;
        if (re.redirect) {
            this.printX(stdout, NanoTools.applySlashSeparator(file, type));
        } else {
            this.printX(stdout, this.pack(file, type));
        }
    }

    private String sprintX(boolean stdout, File file, boolean ... type) {
        Redirect re;
        Redirect redirect = re = stdout ? this.__STDOUT : this.__STDERR;
        if (re.redirect) {
            return NanoTools.applySlashSeparator(file, type);
        }
        return this.pack(file, type);
    }

    public int set(Object ... x) {
        this.initialize("./", x);
        boolean hasARGV = this.optARGV.size() > 0;
        this.DISPLAY_WIDTH = this.applyShellVariable(DISPLAY_WIDTH_KEY, this.DISPLAY_WIDTH);
        this.MAX_PATH = this.applyShellVariable(MAX_PATH_KEY, this.MAX_PATH);
        String args = hasARGV ? this.listOptions() : "";
        NanoTools.messageTitle("set", args);
        if (!hasARGV) {
            for (String k : this.optIn) {
                System.out.println(k);
            }
        }
        this.messageFinish("Number of processed", this.optIn.size(), "");
        return 0;
    }

    public int clean(String input, Object ... x) {
        int flags;
        this.initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = true;
        boolean isClean = this.applyOption(CLEAN, new boolean[0]);
        boolean isTime = this.applyOption(noTIME, false);
        int n = flags = isTime ? 1 : 0;
        if (isClean) {
            flags |= 2;
        }
        String args = this.ana.virtualPath + " " + this.listOptions();
        NanoTools.messageTitle(CLEAN, args);
        int[] cf = new int[2];
        int ri = NanoTools.checkPath(in, 3);
        if (ri <= 1) {
            this.cleanupFolderImpl(in, cf, true, flags);
        }
        this.messageFinish("Number of processed", cf[0], cf[1]);
        return 0;
    }

    private long cleanupFolderImpl(Path input, int[] cf, boolean warning, int flags) {
        if (NanoTools.isSystem(input)) {
            return 0L;
        }
        File inputFile = input.toFile();
        boolean isTime = (flags & 1) != 0;
        boolean isEmpty = (flags & 2) != 0;
        long modTime = 0L;
        if (Files.isDirectory(input, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                for (Path path : ds) {
                    long time;
                    if (NanoTools.isSystem(path)) continue;
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        time = this.cleanupFolderImpl(path, cf, warning, flags);
                        if (warning && !isEmpty && time == 0L && Files.isDirectory(path, new LinkOption[0])) {
                            NanoTools.messageMAGENTA("Empty folder", this.pack(path.toFile(), new boolean[0]));
                        }
                        cf[1] = cf[1] + 1;
                    } else {
                        time = this.getModifiedTime(path).toMillis();
                        cf[0] = cf[0] + 1;
                    }
                    if (modTime >= time) continue;
                    modTime = time;
                }
                if (Files.isDirectory(input, new LinkOption[0])) {
                    long time2 = this.getModifiedTime(input).toMillis();
                    if (isTime && time2 != modTime) {
                        FileTime fileTime = FileTime.fromMillis(modTime);
                        this.setModifiedTime(input, fileTime);
                    }
                    if (isEmpty && this.removeNoTime0Folder(input)) {
                        if (warning) {
                            NanoTools.messageMAGENTA("remove", this.pack(inputFile, new boolean[0]));
                        }
                        cf[1] = cf[1] - 1;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(this.exception("cleanup", e));
            }
        }
        return modTime;
    }

    public int copy(String input, String output, Object ... x) {
        this.initialize(input, x);
        Path in = this.ana.path;
        Output cf = this.createOutFolder(in, output);
        Path out = cf.path;
        this.isRemove = true;
        boolean isPro = this.applyOption(PRO, new boolean[0]);
        boolean isSync = this.applyOption(SYNC, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + " " + this.pack(output) + this.listOptions();
        NanoTools.messageTitle("copy", args);
        if (in.equals(out)) {
            NanoTools.inputAndOutputAreSamePath(in);
            return 3;
        }
        int ri = NanoTools.checkPath(in, 7);
        int ro = NanoTools.checkPath(out, 7);
        if ((ri = Math.max(ri, ro)) <= 1) {
            Progress pro = new Progress(false, isPro);
            if (isSync) {
                this.copySync(pro, in, out);
                pro.flush();
                if (pro.fileNumber > 0) {
                    if (pro.printX) {
                        for (File sync : this.set) {
                            this.printX(false, sync, new boolean[0]);
                        }
                    }
                    NanoTools.messageCYAN("Synchronized", pro.fileNumber);
                }
            }
            pro = new Progress(true, isPro);
            if (cf.createHolder) {
                pro.incrementFolder();
            }
            this.copyImpl(pro, in, out, isRecursive);
            pro.flush();
            if (pro.printX) {
                for (File copy : this.set) {
                    this.printX(true, copy, new boolean[0]);
                }
            }
            this.finishAsyncIO(pro, out);
            this.messageFinish("Number of processed", pro.fileNumber, pro.fileSize);
        }
        this.close();
        return ri;
    }

    private void copyImpl(Progress pro, Path input, Path output, boolean recursive) {
        block14: {
            if (NanoTools.isSystem(input)) {
                return;
            }
            if (Files.isDirectory(input, new LinkOption[0])) {
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                    for (Path path : ds) {
                        if (NanoTools.isSystem(path)) continue;
                        Path newOut = output.resolve(path.getFileName());
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            if (!recursive) continue;
                            if (this.createFolder(path, newOut)) {
                                pro.incrementFolder();
                            }
                            this.copyImpl(pro, path, newOut, recursive);
                            continue;
                        }
                        if (!this.isMatch(path)) continue;
                        this.atomicCopy(pro, path, newOut);
                    }
                    break block14;
                }
                catch (IOException e) {
                    throw new RuntimeException(this.exception("copy", e));
                }
            }
            if (this.isMatch(input) && Files.exists(input, new LinkOption[0])) {
                this.atomicCopy(pro, input, output);
            }
        }
    }

    private void copySync(Progress pro, Path input, Path output) {
        File[] files;
        HashMap<String, File> map = new HashMap<String, File>(512);
        if (NanoTools.isSystem(input) || NanoTools.isSystem(output)) {
            return;
        }
        if (Files.isDirectory(output, new LinkOption[0]) && null != (files = output.toFile().listFiles())) {
            for (File file : files) {
                if (NanoTools.isSystem(file)) continue;
                map.put(file.getName(), file);
            }
        }
        if (Files.exists(output, new LinkOption[0])) {
            File file = output.toFile();
            map.put(file.getName(), file);
        }
        if (Files.isDirectory(input, new LinkOption[0]) && null != (files = input.toFile().listFiles())) {
            for (File file : files) {
                if (NanoTools.isSystem(file)) continue;
                String name = file.getName();
                Path newIn = file.toPath();
                Path newOut = output.resolve(name);
                map.remove(name);
                if (!file.isDirectory()) continue;
                this.copySync(pro, newIn, newOut);
            }
        }
        if (Files.exists(input, new LinkOption[0])) {
            String name = input.toFile().getName();
            map.remove(name);
        }
        for (File file : map.values()) {
            this.copySyncRemove(pro, file.toPath());
        }
    }

    private void copySyncRemove(Progress pro, Path input) {
        block14: {
            if (NanoTools.isSystem(input)) {
                return;
            }
            if (Files.isDirectory(input, new LinkOption[0])) {
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                    for (Path path : ds) {
                        if (NanoTools.isSystem(path)) continue;
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            this.copySyncRemove(pro, path);
                            pro.incrementFolder();
                            continue;
                        }
                        if (!this.isMatch(path)) continue;
                        long size = this.getFileSize(path);
                        if (!this.removeSafetyFile(path)) continue;
                        pro.addFile(path, size);
                    }
                    this.removeSafetyFolder(input);
                    break block14;
                }
                catch (IOException e) {
                    throw new RuntimeException(this.exception(SYNC, e));
                }
            }
            if (Files.exists(input, new LinkOption[0])) {
                long size = this.getFileSize(input);
                if (this.removeSafetyFile(input)) {
                    pro.addFile(input, size);
                }
            }
        }
    }

    public int move(String input, String output, Object ... x) {
        this.initialize(input, x);
        Path in = this.ana.path;
        Output cf = this.createOutFolder(in, output);
        Path out = cf.path;
        this.isRemove = true;
        boolean isPro = this.applyOption(PRO, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + " " + this.pack(output) + this.listOptions();
        NanoTools.messageTitle("move", args);
        if (in.equals(out)) {
            NanoTools.inputAndOutputAreSamePath(in);
            return 3;
        }
        int ri = NanoTools.checkPath(in, 7);
        int ro = NanoTools.checkPath(out, 7);
        if ((ri = Math.max(ri, ro)) <= 1) {
            Progress pro = new Progress(true, isPro);
            if (cf.createHolder) {
                pro.incrementFolder();
            }
            this.moveImpl(pro, in, out, isRecursive);
            pro.flush();
            if (pro.printX) {
                for (File move : this.set) {
                    this.printX(true, move, new boolean[0]);
                }
            }
            this.finishAsyncIO(pro, out);
            this.finishAsyncDropFileMove(in);
            this.messageFinish("Number of processed", pro.fileNumber, pro.fileSize);
        }
        this.close();
        return ri;
    }

    private void moveImpl(Progress pro, Path input, Path output, boolean recursive) {
        block14: {
            if (NanoTools.isSystem(input)) {
                return;
            }
            if (Files.isDirectory(input, new LinkOption[0])) {
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                    for (Path path : ds) {
                        if (NanoTools.isSystem(path)) continue;
                        Path newOut = output.resolve(path.getFileName());
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            if (!recursive) continue;
                            if (this.createFolder(path, newOut)) {
                                pro.incrementFolder();
                            }
                            this.moveImpl(pro, path, newOut, recursive);
                            continue;
                        }
                        if (!this.isMatch(path)) continue;
                        this.atomicMove(pro, path, newOut);
                    }
                    break block14;
                }
                catch (IOException e) {
                    throw new RuntimeException(this.exception("move", e));
                }
            }
            if (this.isMatch(input) && Files.exists(input, new LinkOption[0])) {
                this.atomicMove(pro, input, output);
            }
        }
    }

    private void atomicCopy(Progress pro, Path input, Path output) {
        Action act = this.isAtomicSameFile(input, output);
        output = act.path;
        if (output == null || act.action == 0) {
            return;
        }
        this.atom.getAndIncrement();
        this.pool.submit(new AsyncIO(pro, true, act.action, input, output));
    }

    private void atomicMove(Progress pro, Path input, Path output) {
        Action act = this.isAtomicSameFile(input, output);
        output = act.path;
        if (output == null) {
            return;
        }
        this.atom.getAndIncrement();
        this.pool.submit(new AsyncIO(pro, false, act.action, input, output));
        if (act.action == 0) {
            this.drop.add(input);
        }
    }

    private Action isAtomicSameFile(Path input, Path output) {
        Path inParent;
        if (!Files.exists(input, new LinkOption[0]) || Files.isDirectory(input, new LinkOption[0])) {
            throw new RuntimeException(this.exception("File does not exist", input));
        }
        if (!this.isMatch(input) || NanoTools.isSystem(input)) {
            return ACTION_HAS_SKIP;
        }
        if (Files.isDirectory(output, new LinkOption[0])) {
            output = output.resolve(input.getFileName());
        }
        if (input.equals(output)) {
            NanoTools.inputAndOutputAreSamePath(input);
            return ACTION_HAS_SAME_PATH;
        }
        Path outParent = NanoTools.getParent(output);
        if (outParent != null && !Files.exists(outParent, new LinkOption[0]) && (inParent = NanoTools.getParent(input)) != null) {
            this.createFolder(inParent, outParent);
        }
        if (Files.exists(output, new LinkOption[0]) && !Files.isDirectory(output, new LinkOption[0]) && input.getFileName().equals(output.getFileName())) {
            long iSize = this.getFileSize(input);
            long oSize = this.getFileSize(output);
            long iMod = this.getModifiedTime(input).toMillis() / 2000L;
            long oMod = this.getModifiedTime(output).toMillis() / 2000L;
            if (iSize == oSize && iMod == oMod) {
                return new Action(0, output);
            }
        }
        return new Action(1, output);
    }

    public int remove(String input, Object ... x) {
        int ri;
        this.initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = true;
        boolean isPro = this.applyOption(PRO, new boolean[0]);
        boolean isRoot = this.applyOption(ROOT, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("remove", args);
        int check = 6;
        if (isRoot) {
            check |= 1;
        }
        if ((ri = NanoTools.checkPath(in, check)) <= 1) {
            Progress pro = new Progress(true, isPro);
            this.removeImpl(pro, in, isRecursive);
            pro.flush();
            if (pro.printX) {
                for (File remove : this.set) {
                    if (remove.isDirectory()) continue;
                    this.printX(true, remove, new boolean[0]);
                }
            }
            this.messageFinish("Number of processed", pro.fileNumber, pro.fileSize);
        }
        this.close();
        return ri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeImpl(Progress pro, Path input, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                for (Path path : ds) {
                    if (NanoTools.isSystem(path)) continue;
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        if (!recursive) continue;
                        this.removeImpl(pro, path, recursive);
                        continue;
                    }
                    if (!this.isMatch(path)) continue;
                    long size = this.getFileSize(path);
                    if (!this.removeSafetyFile(path)) continue;
                    pro.addFile(path, size);
                }
                if (!this.removeNoTime0Folder(input)) return;
                pro.incrementFolder();
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(this.exception("remove", e));
            }
        } else {
            if (!this.isMatch(input) || !Files.exists(input, new LinkOption[0])) return;
            long size = this.getFileSize(input);
            if (!this.removeSafetyFile(input)) return;
            pro.addFile(input, size);
        }
    }

    public int tree(String input, Object ... x) {
        this.initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = false;
        boolean isFile = this.applyOption(FILE, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("tree", args);
        int ri = NanoTools.checkPath(in, 3);
        if (ri <= 1) {
            int max = this.treeImpl(in.toFile(), "", isFile, isRecursive);
            this.messageFinish(MAX_PATH_KEY, max, " chars");
        }
        this.close();
        return ri;
    }

    private int treeImpl(File input, String indent, boolean isFile, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return 0;
        }
        int max = 0;
        if (input.isDirectory()) {
            File[] files = input.listFiles();
            if (null != files) {
                String x;
                TreeSet<File> set = new TreeSet<File>(List.of(files));
                for (File file : set) {
                    if (NanoTools.isSystem(file) || !file.isFile() || !this.isMatch(file)) continue;
                    if (isFile) {
                        x = indent + "| " + this.packTree(file);
                        this.printX(true, x);
                    }
                    max = Math.max(max, file.getPath().length());
                }
                for (File file : set) {
                    if (NanoTools.isSystem(file) || !file.isDirectory()) continue;
                    x = indent + "/" + this.packTree(file);
                    this.printX(true, x);
                    max = Math.max(max, file.getPath().length());
                    if (!recursive) continue;
                    max = Math.max(max, this.treeImpl(file, indent + " ", isFile, recursive));
                }
            } else if (this.isMatch(input)) {
                if (isFile) {
                    String x = indent + "| " + this.packTree(input);
                    this.printX(true, x);
                }
                max = input.getPath().length();
            }
        }
        return max;
    }

    public int ls(String input, Object ... x) {
        boolean isAttr;
        this.initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = false;
        boolean isPath = this.applyOption(PATH, new boolean[0]);
        boolean isSimple = this.applyOption(SIMPLE, new boolean[0]);
        boolean isComma = this.applyOption(COMMA, new boolean[0]);
        boolean isUnit = this.applyOption(UNIT, new boolean[0]);
        boolean is260 = this.applyOption(MX_260, new boolean[0]);
        boolean isNo260 = this.applyOption(MX_no260, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        boolean bl = isAttr = isPath || isSimple || isComma || isUnit;
        if (isPath) {
            this.resetOptions(SIMPLE, COMMA, UNIT);
        }
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("ls", args);
        int ri = NanoTools.checkPath(in, 3);
        if (ri <= 1) {
            this.lsImpl(in, is260, isNo260, isRecursive);
            for (File file : this.set) {
                String ls = this.lsAttr(file, isAttr);
                this.printX(true, ls);
            }
            this.messageFinish("Number of processed", this.set.size(), "");
        }
        this.close();
        return ri;
    }

    private void lsImpl(Path input, boolean is260, boolean isNo260, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                for (Path path : ds) {
                    if (NanoTools.isSystem(path)) continue;
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        if (!recursive) continue;
                        this.lsImpl(path, is260, isNo260, recursive);
                        continue;
                    }
                    this.lsSelect260(path, is260, isNo260);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(this.exception("ls", e));
            }
        }
    }

    private String lsAttr(File input, boolean isAttr) {
        StringBuilder sb = new StringBuilder(256);
        if (isAttr) {
            SimpleDateFormat sdf = new SimpleDateFormat("yy/MM/dd HH:mm");
            long time = this.getModifiedTime(input.toPath()).toMillis();
            String daytime = sdf.format(time);
            String len = this.lsLength(this.getBooOption(PATH) ? (long)input.getPath().length() : input.length());
            sb.append(daytime).append('\t');
            sb.append(len).append('\t');
        }
        String path = this.sprintX(true, input, new boolean[0]);
        return sb.append(path).toString();
    }

    private void lsSelect260(Path input, boolean is260, boolean isNo260) {
        if (this.isMatch(input)) {
            File in = input.toFile();
            if (is260) {
                if (this.isLonger260(input)) {
                    this.set.add(in);
                }
            } else if (isNo260) {
                if (!this.isLonger260(input)) {
                    this.set.add(in);
                }
            } else {
                this.set.add(in);
            }
        }
    }

    private String lsLength(long len) {
        if (this.getBooOption(PATH)) {
            return String.format("%, 7d", len);
        }
        if (this.getBooOption(COMMA)) {
            return String.format("%,d", len);
        }
        if (this.getBooOption(UNIT)) {
            return NanoTools.formatUnit(len);
        }
        return Long.toString(len);
    }

    private static String formatUnit(long length) {
        double len = length;
        for (int i = 0; i < NUMBER_UNIT.length(); ++i) {
            if (len < 1024.0) {
                String unit = Character.toString(NUMBER_UNIT.charAt(i));
                return String.format("%3.1f %s", len, unit);
            }
            len /= 1024.0;
        }
        return Long.toString((long)len);
    }

    private String packTree(File input) {
        StringBuilder sb = new StringBuilder(this.DISPLAY_WIDTH + 32);
        sb.append(this.sprintX(true, input, true)).append(' ');
        String path = input.getPath();
        String name = input.getName();
        String info = name.length() + "/" + path.length();
        String maxPathID = this.isLonger260(input.toPath()) ? " *" : "";
        sb.append((String)(maxPathID.isEmpty() ? info : NanoTools.color(MAGENTA, info + maxPathID)));
        return sb.toString();
    }

    private String pack(File file, boolean ... type) {
        String str = NanoTools.applySlashSeparator(file, type);
        return NanoTools.pack(str, this.DISPLAY_WIDTH);
    }

    private String pack(String source) {
        return NanoTools.pack(source, this.DISPLAY_WIDTH);
    }

    private static String pack(String source, int DISPLAY_WIDTH) {
        int len = source.length();
        if (len > DISPLAY_WIDTH) {
            int half = DISPLAY_WIDTH / 2;
            return source.substring(0, half) + "\u2026" + source.substring(len - half + 1);
        }
        return source;
    }

    private static String applySlashSeparator(File input, boolean ... type) {
        if (type.length != 0) {
            return input.getName();
        }
        String path = input.getPath();
        return File.separatorChar == '/' ? path : path.replace('\\', '/');
    }

    static String color(String color, String message) {
        return color + message + RESET;
    }

    private static void messageTitle(String name, Object arg) {
        System.out.println(NanoTools.color(YELLOW, name + " ") + String.valueOf(arg));
    }

    private void messageFinish(String name, int arg1, Object arg2) {
        Object str2;
        String cyan = NanoTools.color(CYAN, name + ": ");
        String ela = NanoTools.elapsedTime(System.currentTimeMillis() - this.start);
        String str1 = String.format(", %,d", arg1);
        if (arg2 instanceof Long) {
            Long e = (Long)arg2;
            str2 = " (" + NanoTools.formatUnit(e).trim() + ")";
        } else if (arg2 instanceof Integer) {
            Integer e = (Integer)arg2;
            str2 = String.format(" (%,d)", e);
        } else {
            str2 = arg2.toString();
        }
        String foo = cyan + ela + str1 + (String)str2;
        System.err.println(foo);
    }

    private static String elapsedTime(long millis) {
        Calendar cl = Calendar.getInstance();
        cl.setTimeInMillis(millis);
        cl.set(15, -21600000);
        SimpleDateFormat sdf = new SimpleDateFormat("H:m:s.SSS");
        return sdf.format(cl.getTime());
    }

    private static void messageCYAN(String name, Object arg) {
        System.err.println(NanoTools.color(CYAN, name + ": ") + String.valueOf(arg));
    }

    private static void messageGREEN(String name, Object arg) {
        System.err.println(NanoTools.color(GREEN, name + ": ") + String.valueOf(arg));
    }

    private static void messageBLUE(String name, Object arg) {
        System.err.println(NanoTools.color(BLUE, name + ": ") + String.valueOf(arg));
    }

    private static void messageMAGENTA(String name, Object arg) {
        System.err.println(NanoTools.color(MAGENTA, name + ": ") + String.valueOf(arg));
    }

    private static void messageRED(String name, Object arg) {
        System.err.println(NanoTools.color(RED, name + ": ") + String.valueOf(arg));
    }

    private String exception(String name, String str) {
        return NanoTools.color(RED, name + ": ") + str;
    }

    private String exception(String name, Path path) {
        return NanoTools.color(RED, name + ": ") + this.pack(path.toFile(), new boolean[0]);
    }

    private String exception(String name, Throwable e) {
        return NanoTools.color(RED, name + ": ") + String.valueOf(e);
    }

    private static void rootCannotBeSpecified(Path path) {
        NanoTools.messageRED("Root folder cannot be specified", NanoTools.applySlashSeparator(path.toFile(), new boolean[0]));
    }

    private static void inputAndOutputAreSamePath(Path path) {
        NanoTools.messageRED("Input and path are the same path", NanoTools.applySlashSeparator(path.toFile(), new boolean[0]));
    }

    private static void wrongPathSpecified(Path path) {
        NanoTools.messageMAGENTA("Wrong path specified", NanoTools.applySlashSeparator(path.toFile(), new boolean[0]));
    }

    private static String getValue(String x) {
        return x == null ? "" : x;
    }

    private static class Analysis {
        private static final Pattern IS_PATH_HAS_FILE_UNIX = Pattern.compile("(.*/)*([^/]*)$");
        private static final Pattern IS_PATH_HAS_FILE_WIN = Pattern.compile("(.*[/\\\\])*([^/\\\\]*)$");
        private static final Pattern SPLIT_PATH = File.separatorChar == '/' ? IS_PATH_HAS_FILE_UNIX : IS_PATH_HAS_FILE_WIN;
        private static final Pattern WILD_CARD_ALL = Pattern.compile(".*");
        private final String virtualPath;
        private final Path path;
        private final Pattern regex;
        private final boolean alwaysTrue;

        private Analysis(String input, int DISPLAY_WIDTH) {
            String g2;
            String path = input.trim();
            String wild = "";
            Pattern regex = WILD_CARD_ALL;
            Matcher m = SPLIT_PATH.matcher(path);
            if (m.matches() && Analysis.hasWildcard(g2 = NanoTools.getValue(m.group(2).trim()))) {
                path = NanoTools.getValue(m.group(1)).trim();
                wild = g2;
                regex = Analysis.mkWildcard(g2);
            }
            if (path.isEmpty()) {
                path = "./";
            }
            this.path = Path.of(path, new String[0]);
            this.virtualPath = NanoTools.pack(path, DISPLAY_WIDTH) + (wild.isEmpty() ? "" : NanoTools.color(NanoTools.BLUE, wild));
            this.regex = regex;
            this.alwaysTrue = WILD_CARD_ALL.equals(regex);
        }

        private static boolean hasWildcard(String wild) {
            for (int i = 0; i < wild.length(); ++i) {
                char c = wild.charAt(i);
                if (0 > "*?|".indexOf(c)) continue;
                return true;
            }
            return wild.endsWith(".");
        }

        private static Pattern mkWildcard(String wild) {
            StringBuilder sb = new StringBuilder(128);
            if (wild.endsWith(".")) {
                wild = wild.substring(0, wild.length() - 1);
            }
            if (wild.isEmpty()) {
                wild = "*";
            }
            block5: for (int i = 0; i < wild.length(); ++i) {
                char c = wild.charAt(i);
                switch (c) {
                    case '*': {
                        sb.append(".*");
                        continue block5;
                    }
                    case '?': {
                        sb.append('.');
                        continue block5;
                    }
                    case '.': {
                        sb.append("\\.");
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return Pattern.compile(sb.toString(), 2);
        }
    }

    private record Redirect(boolean redirect, String name, String rid, String file, boolean isErr) {
    }

    private record Output(Path path, boolean createHolder) {
    }

    private class Progress {
        private final PrintStream printStream;
        private final boolean enable;
        private final boolean printX;
        private volatile boolean hasPrint;
        private volatile int folderNumber;
        private volatile int fileNumber;
        private volatile long fileSize;
        private volatile File file;
        private static final long ELAPSED = 500L;
        private volatile long elapse = System.currentTimeMillis();

        private Progress(boolean stdout, boolean enable) {
            Redirect re;
            this.printStream = stdout ? System.out : System.err;
            this.enable = enable;
            Redirect redirect = re = stdout ? NanoTools.this.__STDOUT : NanoTools.this.__STDERR;
            this.printX = re.redirect ? true : !enable;
            NanoTools.this.set.clear();
        }

        private void flush() {
            if (this.enable && NanoTools.this.atom.intValue() <= 0) {
                this.print();
                if (this.hasPrint) {
                    this.printStream.println();
                }
            }
        }

        private void print() {
            if (this.enable && this.file != null) {
                this.printStream.print(this);
                this.hasPrint = true;
            }
        }

        private synchronized void incrementFolder() {
            ++this.folderNumber;
        }

        private synchronized void decrementFolder() {
            --this.folderNumber;
        }

        private synchronized void addFile(Path input, Path output) {
            this.addFile(input, NanoTools.this.getFileSize(output));
        }

        private synchronized void addFile(Path input, long size) {
            this.file = input.toFile();
            if (this.printX) {
                NanoTools.this.set.add(this.file);
            }
            this.fileSize += size;
            ++this.fileNumber;
            long now = System.currentTimeMillis();
            if (now - this.elapse > 500L) {
                this.elapse = now;
                this.print();
            }
        }

        public String toString() {
            String elapsed = NanoTools.elapsedTime(System.currentTimeMillis() - NanoTools.this.start);
            String progress = String.format("%s %,d(%,d): ", elapsed, this.fileNumber, this.folderNumber);
            return NanoTools.color(NanoTools.BLUE, progress) + NanoTools.this.pack(this.file, new boolean[0]) + "\u001b[K\r";
        }
    }

    private record Action(int action, Path path) {
    }

    private class AsyncIO
    implements Runnable {
        private static final int RETRY = 5;
        private final Progress pro;
        private final boolean copy;
        private final int action;
        private final Path input;
        private final Path output;
        private Throwable ex;

        private AsyncIO(Progress pro, boolean copy, int action, Path input, Path output) {
            this.pro = pro;
            this.copy = copy;
            this.action = action;
            this.input = input;
            this.output = output;
        }

        @Override
        public void run() {
            if (this.copy) {
                this.copy();
            } else {
                this.move();
            }
            NanoTools.this.atom.decrementAndGet();
        }

        private void copy() {
            for (int i = 5; i > 0; --i) {
                try {
                    Files.copy(this.input, this.output, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    this.pro.addFile(this.input, this.output);
                    return;
                }
                catch (IOException e) {
                    NanoTools.messageMAGENTA("copy", NanoTools.this.pack(this.input.toFile(), new boolean[0]));
                    this.ex = e;
                    continue;
                }
            }
            throw new RuntimeException(NanoTools.this.exception("copy", this.ex));
        }

        private void move() {
            for (int i = 5; i > 0; --i) {
                try {
                    if (this.action != 0) {
                        Files.move(this.input, this.output, StandardCopyOption.REPLACE_EXISTING);
                    }
                    this.pro.addFile(this.input, this.output);
                    return;
                }
                catch (IOException e) {
                    NanoTools.messageMAGENTA("move", NanoTools.this.pack(this.input.toFile(), new boolean[0]));
                    this.ex = e;
                    continue;
                }
            }
            throw new RuntimeException(NanoTools.this.exception("move", this.ex));
        }
    }
}

