/*
 * Copyright (C) 2010 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package plus.run

import groovy.transform.CompileStatic
import plus.concurrent.Futures
import plus.reflect.Listener

/**
 * AWK~plus - Local Function (Lambda).
 *
 * @author kunio himei.
 */
@SuppressWarnings("unused")
@CompileStatic
class LocalFunction extends Listener {
    private String name
    private Listener lambda
    private Futures futures // Lambda 式の解析完了を待機する同期オブジェクトを構築

    LocalFunction(String name, Listener lambda) {
        this.name = name
        this.lambda = lambda
        futures = Futures.pair(name) as Futures
    }

    Object apply(Object[] args) { // 'c3.awk'で使用
        if (0 == args.length) lambda.apply() else args[0]
    }

    Object call() {
        return lambda.call()
    }

    String getName() { return name.replaceFirst(/^.*[$]/, "") }

    String toString() { return name } // 正式名称を返す
}