/*
 * Decompiled with CFR 0.152.
 */
package plus.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import plus.concurrent.ArrayAccessor;
import plus.concurrent.AtomicInterface;
import plus.util.NumHelper;

public class AtomicNumber
extends Number
implements AtomicInterface,
ArrayAccessor<Object, Object> {
    private static final long serialVersionUID = 1L;
    private static final Double DoubleOne = 1.0;
    private final AtomicReference<Double> atom = new AtomicReference();

    public AtomicNumber() {
        this.atom.set(0.0);
    }

    public AtomicNumber(double value) {
        this.atom.set(value);
    }

    public AtomicNumber(Number value) {
        this(value.doubleValue());
    }

    private static double calculate(String op, double left, double right) {
        switch (op.charAt(0)) {
            case '=': {
                return right;
            }
            case '+': {
                return left + right;
            }
            case '-': {
                return left - right;
            }
            case '*': {
                return op.startsWith("**") ? Math.pow(left, right) : left * right;
            }
            case '/': {
                return left / right;
            }
            case '%': {
                return left % right;
            }
            case '<': {
                return (long)left << (int)right;
            }
            case '>': {
                if (op.startsWith(">>>")) {
                    return (long)left >>> (int)right;
                }
                return (long)left >> (int)right;
            }
            case '&': {
                return (long)left & (long)right;
            }
            case '|': {
                return (long)left | (long)right;
            }
            case '^': {
                return (long)left ^ (long)right;
            }
            case '~': {
                return (long)left ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        throw new IllegalArgumentException(left + " " + op + " " + right);
    }

    public static Number calculate(String op, Object left, Object right) {
        return new AtomicNumber(AtomicNumber.calculate(op, NumHelper.doubleValue(left), NumHelper.doubleValue(right)));
    }

    public static double postIncDec(String op, double value) {
        if ("+-".equals(op)) {
            return value - 1.0;
        }
        if ("-+".equals(op)) {
            return value + 1.0;
        }
        return value;
    }

    @Override
    public double calculate(String op, Object right) {
        double update;
        double expect;
        double value = NumHelper.doubleValue(right);
        if ('=' == op.charAt(0)) {
            this.setAtom(value);
            return value;
        }
        while ((expect = this.atom.get().doubleValue()) != this.atom.getAndSet(update = AtomicNumber.calculate(op, expect, value))) {
        }
        return AtomicNumber.postIncDec(op, update);
    }

    @Override
    public Object getAtom() {
        return NumHelper.normalise(this.atom.get());
    }

    @Override
    public void setAtom(Object value) {
        this.atom.set(NumHelper.doubleValue(value));
    }

    @Override
    public final double doubleValue() {
        return NumHelper.doubleValue(this.getAtom());
    }

    @Override
    public final float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public final int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public final long longValue() {
        return (long)this.doubleValue();
    }

    public String toString() {
        return this.getAtom().toString();
    }

    public int compareTo(@NotNull Object right) {
        if (right == null) {
            AtomicNumber.$$$reportNull$$$0(0);
        }
        return Double.compare(NumHelper.doubleValue(this.getAtom()), NumHelper.doubleValue(right));
    }

    public boolean equals(Object right) {
        return 0 == this.compareTo(right);
    }

    @Override
    public Character getAt(Object key) {
        return Character.valueOf(this.toString().charAt(NumHelper.intValue(key)));
    }

    @Override
    public synchronized void putAt(Object key, Object value) {
        int p = NumHelper.intValue(key);
        String x = value.toString();
        StringBuilder sb = new StringBuilder(this.toString());
        if (!x.isEmpty()) {
            sb.insert(p, x);
        } else {
            sb.deleteCharAt(p);
        }
        this.setAtom(Double.parseDouble(sb.toString()));
    }

    public Number next() {
        this.calculate("++", DoubleOne);
        return this;
    }

    public Number previous() {
        this.calculate("--", DoubleOne);
        return this;
    }

    public Number plus(Object value) {
        this.calculate("+", value);
        return this;
    }

    public Number minus(Object value) {
        this.calculate("-", value);
        return this;
    }

    public Number multiply(Object value) {
        this.calculate("*", value);
        return this;
    }

    public Number div(Object value) {
        this.calculate("/", value);
        return this;
    }

    public Number mod(Number value) {
        this.calculate("%", value);
        return this;
    }

    public Number power(Number value) {
        this.calculate("**", value);
        return this;
    }

    public Number leftShift(Number value) {
        this.calculate("<<", value);
        return this;
    }

    public Number rightShift(Number value) {
        this.calculate(">>", value);
        return this;
    }

    public Number rightShiftUnsigned(Number value) {
        this.calculate(">>>", value);
        return this;
    }

    public Number and(Number value) {
        this.calculate("&", value);
        return this;
    }

    public Number or(Number value) {
        this.calculate("|", value);
        return this;
    }

    public Number xor(Number value) {
        this.calculate("^", value);
        return this;
    }

    public Number bitwiseNegate() {
        this.calculate("~", DoubleOne);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "plus/concurrent/AtomicNumber", "compareTo"));
    }
}

