/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import plus.io.Connectable;
import plus.io.ReadWriteable;

final class InetDatagramSocket
extends OutputStream
implements Connectable,
ReadWriteable {
    private static final int DEFAULT_BUFFER_SIZE = 65507;
    private final ReentrantLock SYNC = new ReentrantLock();
    private final DatagramSocket socket;
    private final SocketAddress socketAddress;
    private final int timeout;
    private volatile SocketAddress remoteAddress;

    InetDatagramSocket(SocketAddress address, int tout) throws IOException {
        this.socketAddress = address;
        this.socket = new DatagramSocket();
        this.socket.setReuseAddress(true);
        this.socket.setBroadcast(true);
        this.socket.connect(address);
        this.timeout = tout;
    }

    InetDatagramSocket(SocketAddress address, int localport, int tout) throws IOException {
        this.socketAddress = address;
        this.socket = new DatagramSocket(address);
        assert (0 <= localport);
        this.timeout = tout;
    }

    @Override
    public void close() {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public ReadWriteable connect() {
        return this;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        DatagramPacket packet = new DatagramPacket(new byte[65507], 65507);
        this.socket.setSoTimeout(this.timeout);
        this.SYNC.lock();
        try {
            this.socket.receive(packet);
            this.remoteAddress = packet.getSocketAddress();
        }
        finally {
            this.SYNC.unlock();
        }
        return new Treader(packet.getData(), packet.getOffset(), packet.getLength());
    }

    @Override
    public OutputStream getOutputStream() {
        return this;
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        if (b == null) {
            InetDatagramSocket.$$$reportNull$$$0(0);
        }
        SocketAddress address = null == this.remoteAddress || this.socket.isConnected() ? this.socketAddress : this.remoteAddress;
        this.socket.send(new DatagramPacket(b, off, len, address));
    }

    @Override
    public void write(int b) throws IOException {
        byte[] minibuf = new byte[]{(byte)b};
        this.write(minibuf, 0, 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "plus/io/InetDatagramSocket", "write"));
    }

    private final class Treader
    extends ByteArrayInputStream {
        Treader(byte[] buffer, int offset, int length) {
            super(buffer, offset, length);
        }

        @Override
        public void close() {
            InetDatagramSocket.this.close();
        }
    }
}

