/*
 * Decompiled with CFR 0.152.
 */
package plus.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import plus.runtime.BuiltInVar;
import plus.runtime.RegExp;
import plus.runtime.RunHelper;
import plus.util.NumHelper;

public final class Compare {
    private Compare() {
    }

    public static boolean compareIn(Object array, Object index) {
        if (array instanceof Map) {
            String key = RunHelper.toString(null, index);
            return ((Map)array).containsKey(key);
        }
        int ix = NumHelper.intValue(index);
        if (0 <= ix) {
            if (array instanceof List) {
                if (array instanceof CopyOnWriteArrayList) {
                    return null != ((List)array).get(ix);
                }
                return ix < ((List)array).size();
            }
            if (array instanceof Object[]) {
                return ix < ((Object[])array).length;
            }
            if (array instanceof int[]) {
                return ix < ((int[])array).length;
            }
            if (array instanceof double[]) {
                return ix < ((double[])array).length;
            }
            if (array instanceof float[]) {
                return ix < ((float[])array).length;
            }
            if (array instanceof long[]) {
                return ix < ((long[])array).length;
            }
            if (array instanceof char[]) {
                return ix < ((char[])array).length;
            }
            if (array instanceof short[]) {
                return ix < ((short[])array).length;
            }
            if (array instanceof byte[]) {
                return ix < ((byte[])array).length;
            }
            if (array instanceof boolean[]) {
                return ix < ((boolean[])array).length;
            }
        }
        throw new IllegalArgumentException(array.getClass() + " " + array);
    }

    public static boolean compareTo(String op, Object left, Object right) {
        int oplen = op.length();
        switch (op.charAt(oplen - 1)) {
            case '=': {
                if (3 == oplen) {
                    boolean bo = left == right;
                    return '!' == op.charAt(0) != bo;
                }
            }
            case '<': 
            case '>': {
                if (left instanceof Number) {
                    if (right instanceof Number) {
                        return Compare.compareToImpl(op, Double.compare(((Number)left).doubleValue(), ((Number)right).doubleValue()));
                    }
                    if (null != right) break;
                    return Compare.compareToImpl(op, Double.compare(((Number)left).doubleValue(), 0.0));
                }
                if (null != left || !(right instanceof Number)) break;
                return Compare.compareToImpl(op, Double.compare(0.0, ((Number)right).doubleValue()));
            }
            case '~': {
                String s1 = RunHelper.toString(null, left);
                String s2 = RunHelper.toString(null, right);
                boolean bo = RegExp.compile(s2).matcher(s1).find();
                return '!' == op.charAt(0) != bo;
            }
            default: {
                if ("in".equals(op)) {
                    return Compare.compareIn(right, left);
                }
                if (!"is".equals(op) && !"instanceof".equals(op)) break;
                Class<?> clazz = null == right ? Object.class : (right instanceof Class ? (Class<?>)right : right.getClass());
                return clazz.isInstance(left);
            }
        }
        String convfmt = BuiltInVar.CONVFMT.toString();
        String s1 = RunHelper.toString(convfmt, left);
        String s2 = RunHelper.toString(convfmt, right);
        int ignoreCase = BuiltInVar.IGNORECASE.intValue();
        return Compare.compareToImpl(op, 0 == ignoreCase ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2));
    }

    private static boolean compareToImpl(String op, int x) {
        switch (op.charAt(0)) {
            case '<': {
                return 1 == op.length() ? x < 0 : x <= 0;
            }
            case '>': {
                return 1 == op.length() ? x > 0 : x >= 0;
            }
            case '=': {
                return 0 == x;
            }
            case '!': {
                return 0 != x;
            }
        }
        throw new IllegalArgumentException(op + " " + x);
    }

    public static boolean compareToPattern(Map<String, Object> p2p, String id, boolean start, boolean end) {
        if (p2p.containsKey(id)) {
            if (end) {
                p2p.remove(id);
            }
            return true;
        }
        if (start) {
            if (!end) {
                p2p.put(id, Boolean.TRUE);
            }
            return true;
        }
        return false;
    }

    public static boolean boolValue(Object x) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x instanceof Number) {
            return 0L != ((Number)x).longValue();
        }
        if (x instanceof CharSequence) {
            return 0L != (long)NumHelper.doubleValue(x);
        }
        return false;
    }
}

