/*
 * Decompiled with CFR 0.152.
 */
package plus.util;

public final class Escape {
    public static final String NIL = "\ufffe";
    private static final int C_OCT_BITWIDTH = 3;
    private static final int C_HEX_BITWIDTH = 4;
    private static final int C_OCT_STRING_MAXLENGTH = 3;
    private static final int C_HEX_STRING_MAXLENGTH = 2;
    private static final int C_UNICODE_STRING_MAXLENGTH = 4;
    private static final int TO_OCT = 8;
    private static final int TO_HEX = 16;

    public static String toHexString(Object s) {
        if (s != null) {
            StringBuilder sb = new StringBuilder();
            String x = s.toString();
            for (int i = 0; i < x.length(); ++i) {
                char c = x.charAt(i);
                sb.append(c).append(':').append(Integer.toHexString(c).toUpperCase()).append(' ');
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return "null";
    }

    public static String removeNIL(String x) {
        return x.replace(NIL, "");
    }

    public static String encodeString(String x, String escape) {
        int len = x.length();
        StringBuilder sb = new StringBuilder(len + 19);
        StringBuilder ign = new StringBuilder("/'\"");
        for (int i = 0; i < escape.length(); ++i) {
            char c = escape.charAt(i);
            int ix = ign.indexOf(String.valueOf(c));
            if (ix < 0) continue;
            ign.deleteCharAt(ix);
        }
        String ignore = ign.toString();
        int p = 0;
        block8: while (len > p) {
            char c = x.charAt(p++);
            switch (c) {
                case '\\': {
                    char next = x.charAt(p++);
                    if (0 > ignore.indexOf(next)) {
                        sb.append(c);
                    }
                    sb.append(next);
                    if ('\\' != next || 0 > escape.indexOf(92)) continue block8;
                    sb.append("\\\\");
                    break;
                }
                case '\"': 
                case '\'': 
                case '/': {
                    if (0 <= escape.indexOf(c)) {
                        sb.append('\\');
                    }
                    sb.append(c);
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    if (x.length() > p && '\n' == x.charAt(p)) break;
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String outputFilter(String s) {
        String x = Escape.removeNIL(s);
        int len = x.length();
        StringBuilder sb = new StringBuilder(len + 19);
        int p = 0;
        while (len > p) {
            char c;
            if ('\\' == (c = x.charAt(p++)) && len > p) {
                c = x.charAt(p++);
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        break;
                    }
                    case 'a': {
                        c = '\u0007';
                        break;
                    }
                    case 'v': {
                        c = '\u000b';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'e': {
                        c = '\u001b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        int k;
                        int i;
                        if (len <= p) break;
                        c = '\u0000';
                        for (i = 3; 0 <= i && len > p && 0 <= (k = Character.digit(x.charAt(p), 16)); --i, ++p) {
                            c = (char)(c << 4 | k);
                        }
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        int k;
                        int i;
                        if (len <= p) break;
                        c = '\u0000';
                        for (i = 1; 0 <= i && len > p && 0 <= (k = Character.digit(x.charAt(p), 16)); --i, ++p) {
                            c = (char)(c << 4 | k);
                        }
                        break;
                    }
                    default: {
                        int i;
                        int k = Character.digit(c, 8);
                        if (0 <= k) {
                            c = (char)k;
                            for (i = 1; 0 <= i && len > p && 0 <= (k = Character.digit(x.charAt(p), 8)); --i, ++p) {
                                c = (char)(c << 3 | k);
                            }
                            break;
                        }
                        sb.append('\\');
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String nopFilter(String x) {
        return x;
    }
}

