/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.space;

import java.util.regex.Pattern;
import org.awk4j.space.Lang;
import org.awk4j.space.Main;
import org.awk4j.space.Modules;
import org.awk4j.space.Space;
import org.awk4j.space.T2TPL;
import org.awk4j.space.Template;
import org.awk4j.space.Tools;

class Parser {
    static Template TEMPLATE = new Template();
    private static Space SPACE = new Space();
    private static final Pattern SECTION_TAG = Pattern.compile("</?(html|head|script|style|body|main|header|footer)", 2);
    private static final Pattern HAS_BR_TAG = Pattern.compile("<br[^>]*?>[\\s]*", 2);
    static final StringBuilder out = new StringBuilder(16384);
    static final StringBuilder err = new StringBuilder(16384);
    static String expand = "";
    static boolean deprecated;
    static int debug;
    private static boolean hasPRE;

    Parser() {
    }

    static void execute(String input) {
        T2TPL t2;
        boolean d1;
        boolean bl = d1 = 1 <= debug;
        if (0 != debug) {
            err.append(Main.lineNumber).append("\t[").append(input).append("]\n");
        }
        if (null == (t2 = Modules.joinInputLine(input))) {
            return;
        }
        Object s = t2.source();
        String template = t2.template();
        if (d1 && 0 <= template.indexOf(127)) {
            err.append(" T\t[").append(template).append("]\n");
        }
        if (hasPRE) {
            if (!template.contains("</pre>") && !HAS_BR_TAG.matcher((CharSequence)s).find()) {
                s = Tools.rTrim((String)s) + "<br>";
            }
        } else {
            s = Tools.lTrim((String)s);
            s = SPACE.space((String)s, deprecated);
        }
        if (!((String)s).isEmpty()) {
            if (0 == debug) {
                Modules.appendLine(err, (String)s, ' ');
                Modules.appendNewLine(err);
            } else {
                err.append(' ').append((Object)Lang.top()).append(' ');
                Modules.appendLine(err, (String)s, '\u001e').append('\n');
            }
            if (!Tools.endsWith(out, '\n') && SECTION_TAG.matcher(template).find()) {
                Modules.appendNewLine(out);
            }
            Modules.appendLine(out, (String)s, ' ');
            if (Lang.isExpand(expand) || Template.LANGUAGE_END_TAG.matcher(template).find()) {
                Modules.appendNewLine(out);
            }
        }
        if (template.contains("</script>")) {
            Parser.endLanguage();
        }
        if (template.contains("</style>")) {
            Parser.endLanguage();
        }
        if (template.contains("<pre")) {
            hasPRE = true;
        }
        if (template.contains("</pre>")) {
            hasPRE = false;
        }
        if (t2.hasMark()) {
            Lang.reset();
        }
    }

    private static void endLanguage() {
        TEMPLATE = new Template();
        SPACE = new Space();
        hasPRE = false;
    }
}

