/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.space;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class Tools {
    static int RSTART;
    static int RLENGTH;
    private static final Pattern RIGHT_TRIM;
    private static final Pattern LEFT_TRIM;
    private static final String WHITE_SPACES = " \t\n\r\u001e";

    Tools() {
    }

    static boolean match(@NotNull Pattern r, CharSequence s, int group) {
        Matcher m;
        if (r == null) {
            Tools.$$$reportNull$$$0(0);
        }
        if ((m = r.matcher(s)).find()) {
            RSTART = m.start(group);
            RLENGTH = m.end(group) - RSTART;
            return true;
        }
        return false;
    }

    @NotNull
    static String rTrim(@NotNull String s) {
        Matcher m;
        if (s == null) {
            Tools.$$$reportNull$$$0(1);
        }
        if ((m = RIGHT_TRIM.matcher(s)).find()) {
            String string = s.substring(0, m.start());
            if (string == null) {
                Tools.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            Tools.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    static StringBuilder rTrim(@NotNull StringBuilder sb) {
        if (sb == null) {
            Tools.$$$reportNull$$$0(4);
        }
        int i = sb.length();
        while (0 <= --i && Tools.isSpace(sb.charAt(i))) {
        }
        sb.setLength(i + 1);
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            Tools.$$$reportNull$$$0(5);
        }
        return stringBuilder;
    }

    static void rTrim(@NotNull StringBuilder sb, @NotNull StringBuilder sx) {
        if (sb == null) {
            Tools.$$$reportNull$$$0(6);
        }
        if (sx == null) {
            Tools.$$$reportNull$$$0(7);
        }
        int len = Tools.rTrim(sx).length();
        sb.setLength(len);
    }

    @NotNull
    static String lTrim(@NotNull String s) {
        Matcher m;
        if (s == null) {
            Tools.$$$reportNull$$$0(8);
        }
        if ((m = LEFT_TRIM.matcher(s)).find()) {
            String string = s.substring(m.end());
            if (string == null) {
                Tools.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            Tools.$$$reportNull$$$0(10);
        }
        return string;
    }

    static boolean endsWith(@NotNull CharSequence cs, char c) {
        int ix;
        if (cs == null) {
            Tools.$$$reportNull$$$0(11);
        }
        return 0 <= (ix = cs.length() - 1) && c == cs.charAt(ix);
    }

    static char charAt(@NotNull CharSequence cs, int ix) {
        if (cs == null) {
            Tools.$$$reportNull$$$0(12);
        }
        if (0 <= ix && ix < cs.length()) {
            char c = cs.charAt(ix);
            return Tools.isSpace(c) ? (char)' ' : (char)c;
        }
        throw new IndexOutOfBoundsException(ix + "/" + cs.length() + ": " + cs);
    }

    static char charAtLast(@NotNull CharSequence cs) {
        int ix;
        if (cs == null) {
            Tools.$$$reportNull$$$0(13);
        }
        char c = 0 <= (ix = cs.length() - 1) ? cs.charAt(ix) : (char)'\u0000';
        return Tools.isSpace(c) ? (char)' ' : (char)c;
    }

    static char toWhiteSpace(char c) {
        return Tools.isSpace(c) ? (char)' ' : (char)c;
    }

    static boolean isSpace(char c) {
        return 0 <= WHITE_SPACES.indexOf(c);
    }

    static {
        RIGHT_TRIM = Pattern.compile("[\\s]+$");
        LEFT_TRIM = Pattern.compile("^[\\s]+");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/awk4j/space/Tools";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sx";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/awk4j/space/Tools";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "rTrim";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "lTrim";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rTrim";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lTrim";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "charAt";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "charAtLast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 9, 10 -> new IllegalStateException(string);
        };
    }
}

