/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.space;

import java.util.regex.Pattern;
import org.awk4j.space.Lang;
import org.awk4j.space.Main;
import org.awk4j.space.Parser;
import org.awk4j.space.T2TPL;
import org.awk4j.space.Tools;
import org.jetbrains.annotations.NotNull;

class Template {
    private static final Pattern HTML_LANGUAGE_TAG = Pattern.compile("</?(script|style)[^>]*?>", 2);
    static final Pattern HTML_LANGUAGE_END_TAG = Pattern.compile("</(script|style)>", 2);
    private static final Pattern LANG_INTEGRATE_TAG = Pattern.compile("</?(?:script|style)[^>]*?$", 2);
    private static final Pattern LANG_SCRIPT_START = Pattern.compile("<script[^>]*?$", 2);
    private static final Pattern LANG_CSS_START = Pattern.compile("<style[^>]*?$", 2);
    private static final Pattern REGEX_JUDGEMENT = Pattern.compile("^((?:[\\s]*/[*].*?[*]/)*[\\s]*/)[^*].*?/");
    private static final String QUOTES_SCRIPT = "\"'`";
    private static final String QUOTES_HTML = "\"'";
    private static final String CMT_SCRIPT_START = "/*";
    private static final String CMT_SCRIPT_END = "*/";
    private static final String CMT_HTML_START = "<!--";
    private static final String CMT_HTML_END = "-->";
    private String commentStart;
    private String commentEnd;
    private String quotes;
    static final char NUL = '\u0000';
    static final char DEL = '\u007f';
    static final char RS = '\u001e';
    static final char FS = '\u001c';
    private static final char FF = '\f';
    private static final char VT = '\u000b';
    private static final char DLE = '\u0010';
    private static final String ESC = "\u001b";
    private static final String DEL01 = "\u007f";
    private static final String DEL02 = "\u007f\u007f";
    private static final String NL = "\\n";
    private final StringBuilder sb = new StringBuilder(1024);
    private final StringBuilder sx = new StringBuilder(1024);
    private boolean inAction;
    private boolean isSCRIPT;
    private boolean isHTML;
    private boolean hasComment;
    private boolean hasBackQuote;
    private boolean hasQuote;
    private char quote;
    private boolean hasBracket;
    private int bracket;
    static final String SCRIPT_OPERATOR = "=.,:?!|&^~+-*/%";
    private static final String JOIN_SCRIPT_LINES = "=.,:?!|&^~+-*/%([{";
    private static final String EXCLUDE_JOIN_CSS_LINES = "}>";
    private static final String EXCLUDE_SEMICOLON = ";{}>";

    Template() {
    }

    private void changeLanguage(Lang lang) {
        Lang top = Lang.top();
        Lang.push(lang);
        this.isSCRIPT = Lang.is(Lang.SCRIPT);
        boolean bl = this.isHTML = !this.isSCRIPT && !Lang.is(Lang.CSS);
        if (this.isHTML) {
            this.quotes = QUOTES_HTML;
            this.commentStart = CMT_HTML_START;
            this.commentEnd = CMT_HTML_END;
            if (top != lang) {
                this.inAction = false;
            }
        } else {
            this.quotes = QUOTES_SCRIPT;
            this.commentStart = CMT_SCRIPT_START;
            this.commentEnd = CMT_SCRIPT_END;
            this.inAction = true;
            if (top != lang) {
                this.hasBracket = false;
                this.bracket = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    T2TPL parse(@NotNull String input) {
        void var5_11;
        if (input == null) {
            Template.$$$reportNull$$$0(0);
        }
        int langEndTagPosition = -1;
        this.changeLanguage(Lang.top());
        for (int i = 0; i < input.length(); ++i) {
            int t = input.charAt(i);
            char c = t;
            if (!this.hasQuote && !this.hasComment) {
                String w;
                if ('>' == c && Tools.match(LANG_INTEGRATE_TAG, this.sx, 0)) {
                    if (LANG_SCRIPT_START.matcher(this.sx).find()) {
                        this.changeLanguage(Lang.SCRIPT);
                    } else if (LANG_CSS_START.matcher(this.sx).find()) {
                        this.changeLanguage(Lang.CSS);
                    } else {
                        w = Tools.trim(this.sx.substring(0, Tools.RSTART));
                        if (!w.isEmpty() && 0 > langEndTagPosition) {
                            langEndTagPosition = Tools.RSTART;
                        }
                        this.changeLanguage(Lang.HTML);
                    }
                } else if (i == input.indexOf(this.commentStart, i)) {
                    this.hasComment = true;
                    i += this.commentStart.length() - 1;
                    continue;
                }
                if (this.isSCRIPT) {
                    if (i == input.indexOf("//", i)) break;
                    if ('{' == c) {
                        this.hasBracket = true;
                        ++this.bracket;
                    } else if ('}' == c && 0 > --this.bracket) {
                        Parser.err.append(Main.lineNumber).append(" ERROR: {}} are not paired.").append(" ('}' Has been removed)\n");
                        continue;
                    }
                    if (0 <= "=(,".indexOf(c) && i < input.indexOf(47, i) && Tools.match(REGEX_JUDGEMENT, w = input.substring(i + 1).replace("\\/", DEL02), 1)) {
                        this.sb.append(c);
                        this.sx.append(c);
                        i += Tools.RLENGTH;
                        this.hasQuote = true;
                        this.quote = (char)47;
                        this.sb.append('/');
                        this.sx.append('\u007f');
                        continue;
                    }
                } else if (this.isHTML) {
                    if ('<' == c) {
                        this.inAction = true;
                    } else if ('>' == c) {
                        this.inAction = false;
                    }
                }
            }
            if (this.hasComment) {
                if (i != input.indexOf(this.commentEnd, i)) continue;
                if (!this.isHTML) {
                    Tools.rTrimTwins(this.sb, this.sx);
                    this.sb.append(' ');
                    this.sx.append(' ');
                }
                this.hasComment = false;
                i += this.commentEnd.length() - 1;
                continue;
            }
            if (this.inAction && 0 <= this.quotes.indexOf(c)) {
                if (!this.hasQuote) {
                    this.quote = c;
                    if ('`' == c) {
                        c = '\"';
                        this.hasBackQuote = true;
                    }
                    this.hasQuote = true;
                } else if (this.quote == c) {
                    this.hasQuote = false;
                    if ('`' == c) {
                        c = '\"';
                        this.hasBackQuote = false;
                    }
                } else if ('\"' == c && this.hasBackQuote) {
                    this.sb.append('\\');
                    this.sx.append('\u007f');
                }
                t = 127;
            } else if (this.hasQuote) {
                t = 127;
                if ('/' == c && '/' == this.quote) {
                    this.hasQuote = false;
                } else if ('\\' == c && '`' != (c = Tools.charAt(input, ++i)) && !this.hasBackQuote) {
                    this.sb.append('\\');
                    this.sx.append('\u007f');
                }
            }
            this.sb.append(c);
            this.sx.append((char)t);
        }
        Tools.rTrimTwins(this.sb, this.sx);
        T2TPL t2 = new T2TPL(this.sb.toString(), this.sx.toString(), null, null, 0);
        String sep1 = "";
        String string = "";
        int request = 0;
        int newLength = 0;
        if (this.hasBackQuote) {
            sep1 = NL;
            String string2 = DEL02;
            request = 2;
        } else if (this.isHTML && (this.hasQuote || this.inAction)) {
            sep1 = " ";
            String string3 = this.hasQuote ? DEL01 : " ";
            request = 2;
        } else if (0 < langEndTagPosition) {
            t2 = this.split(langEndTagPosition);
            newLength = this.sb.length();
            Lang.mark();
            request = 3;
        } else if (this.hasBracket) {
            if (0 >= this.bracket || HTML_LANGUAGE_END_TAG.matcher(this.sx).find()) {
                this.bracket = 0;
                this.hasBracket = false;
            } else {
                request = 2;
            }
            t2 = this.semicolon(t2);
        } else if (!this.isHTML) {
            char c;
            char c2 = c = this.sx.isEmpty() ? (char)'\u0000' : Tools.charAtLast(this.sx);
            if (this.isSCRIPT) {
                if (c == '\u0000' || 0 <= JOIN_SCRIPT_LINES.indexOf(c)) {
                    request = 2;
                } else {
                    t2 = this.semicolon(t2);
                }
            } else if (c == '\u0000' || 0 > EXCLUDE_JOIN_CSS_LINES.indexOf(c)) {
                request = 2;
            }
        }
        this.sb.setLength(newLength);
        this.sx.setLength(newLength);
        return new T2TPL(t2.source(), t2.template().toLowerCase(), sep1, (String)var5_11, request);
    }

    @NotNull
    private T2TPL semicolon(T2TPL t2) {
        char c;
        if (!this.sx.isEmpty() && 0 > EXCLUDE_SEMICOLON.indexOf(c = Tools.charAtLast(this.sx)) && !HTML_LANGUAGE_TAG.matcher(this.sx).find()) {
            this.sb.append(';');
            this.sx.append(';');
            return new T2TPL(this.sb.toString(), this.sx.toString(), null, null, 1);
        }
        T2TPL t2TPL = t2;
        if (t2TPL == null) {
            Template.$$$reportNull$$$0(1);
        }
        return t2TPL;
    }

    @NotNull
    private T2TPL split(int position) {
        String tpl = Tools.rTrim(this.sx.substring(0, position));
        String src = this.sb.substring(0, tpl.length());
        this.sb.delete(0, position);
        this.sx.delete(0, position);
        return new T2TPL(src, tpl, null, null, 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/awk4j/space/Template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/awk4j/space/Template";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "semicolon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

