/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.space;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.awk4j.space.Parser;

public class Main {
    private static final String USAGE = "$(noSpace.jar) [-options] <output folder> <input file>\n-d debug\n-v Version 1.0.2";
    private static final Parser parser = new Parser();
    private static BufferedReader reader;
    private static String in;
    static int lineNumber;
    static boolean isDebug;

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    static String getLine() {
        try {
            if (null != in && null != (in = reader.readLine())) {
                ++lineNumber;
                return Parser.rTrim(in);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String arg;
        int ix;
        int argsLength = args.length;
        for (ix = 0; ix < argsLength && '-' == (arg = args[ix]).charAt(0); ++ix) {
            if (arg.contains("-v")) {
                System.err.println(USAGE);
                return;
            }
            if (!arg.startsWith("-d")) continue;
            isDebug = true;
        }
        try {
            String input;
            File outA;
            String name;
            File inputFile;
            File inA;
            File targetFile;
            File workFolder;
            if (ix >= argsLength) {
                Main.error("\u4f5c\u696d\u30d5\u30a9\u30eb\u30c0\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff01");
            }
            if (!(workFolder = new File(args[ix++])).exists() && !workFolder.mkdirs()) {
                Main.error("\u4f5c\u696d\u30d5\u30a9\u30eb\u30c0\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff01 " + String.valueOf(workFolder));
            }
            if (ix >= argsLength) {
                Main.error("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff01");
            }
            if (!(targetFile = new File(args[ix])).exists()) {
                Main.error("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\uff01 " + String.valueOf(targetFile));
            }
            if ((inA = (inputFile = new File(workFolder, name = targetFile.getName())).getAbsoluteFile().getCanonicalFile()).equals(outA = targetFile.getAbsoluteFile().getCanonicalFile())) {
                Main.error("\u5165\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306f\u540c\u3058\u3067\u3059\uff01");
            }
            if (inputFile.exists() && !inputFile.delete()) {
                Main.error("\u4f5c\u696d\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff01 " + String.valueOf(inputFile));
            }
            Path pTarget = targetFile.toPath();
            Path pInput = inputFile.toPath();
            Files.move(pTarget, pInput, new CopyOption[0]);
            System.out.println("Input File: " + String.valueOf(targetFile) + " \u2192 " + String.valueOf(inputFile));
            FileInputStream inputStream = new FileInputStream(inputFile);
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8), 1024);
            System.out.println("Output File: " + String.valueOf(targetFile));
            FileWriter writer = new FileWriter(targetFile, StandardCharsets.UTF_8);
            File debugFile = new File(workFolder, "~debug.html");
            System.out.println("Debug File: " + String.valueOf(debugFile));
            FileWriter debugger = new FileWriter(debugFile, StandardCharsets.UTF_8);
            while (null != (input = Main.getLine())) {
                String output = parser.parse(input);
                writer.write(output);
                debugger.write(Main.parser.debug);
            }
            debugger.write("<!-- \u2714 Removed " + Main.parser.cutSpace + " spaces -->");
            System.out.println("Removed " + Main.parser.cutSpace + " spaces, " + lineNumber + " lines");
            writer.flush();
            debugger.flush();
            writer.close();
            debugger.close();
            reader.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            System.out.flush();
            System.err.flush();
        }
    }

    static {
        in = "";
    }
}

