/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AwkLocation {
    private List<String> path;
    private boolean root;

    public AwkLocation(boolean root, List<String> path) {
        this.root = root;
        this.path = new ArrayList<String>(path);
    }

    public AwkLocation(boolean root, String ... path) {
        this.root = root;
        this.path = Arrays.asList(path);
    }

    public AwkLocation(String name) {
        this(false, name);
    }

    public String getName() {
        return this.path.get(this.path.size() - 1);
    }

    public int sizeOfPath() {
        return this.path.size();
    }

    public String getPathOf(int x) {
        return this.path.get(x);
    }

    public boolean isRoot() {
        return this.root;
    }

    public boolean isSimpleName() {
        return this.path.size() == 1;
    }

    public int hashCode() {
        int h = this.path.hashCode();
        return this.root ? -h : h;
    }

    public boolean equals(Object o) {
        if (o instanceof AwkLocation) {
            return this.path.equals(((AwkLocation)o).path) && this.root == ((AwkLocation)o).root;
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        String d = this.root ? "." : "";
        for (String s : this.path) {
            b.append(d).append(s);
            d = ".";
        }
        return b.toString();
    }
}

