/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.expr;

import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkAdder
extends AwkExpression {
    private AwkExpression e1;
    private AwkExpression e2;

    public AwkAdder(AwkExpression e1, AwkExpression e2) {
        this.e1 = e1;
        this.e2 = e2;
    }

    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        AwkValue r1 = this.e1.eval(ns, o);
        AwkValue r2 = this.e2.eval(ns, o);
        if (r1 instanceof AwkUndefined) {
            return r2;
        }
        if (r2 instanceof AwkUndefined) {
            return r1;
        }
        if (r1.isFloat() || r2.isFloat()) {
            return AwkFloat.valueOf(r1.toFloat() + r2.toFloat());
        }
        if (r1.isIntegerValue() && r2.isIntegerValue()) {
            return AwkInteger.valueOf(r1.toInteger().add(r2.toInteger()));
        }
        return AwkFloat.valueOf(r1.toFloat() + r2.toFloat());
    }
}

