/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin.s;

import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

public class SDump
extends AwkUnaryArgs {
    protected SDump() {
        super("dump");
    }

    public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
        StringBuffer b = new StringBuffer();
        String s = a1.toString(ns);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isISOControl((int)c)) {
                b.append('\\');
                switch (c) {
                    case '\u0007': {
                        b.append('a');
                        break;
                    }
                    case '\b': {
                        b.append('b');
                        break;
                    }
                    case '\t': {
                        b.append('t');
                        break;
                    }
                    case '\n': {
                        b.append('n');
                        break;
                    }
                    case '\u000b': {
                        b.append('v');
                        break;
                    }
                    case '\f': {
                        b.append('f');
                        break;
                    }
                    case '\r': {
                        b.append('r');
                        break;
                    }
                    default: {
                        b.append(Integer.toString(c / 64 % 8));
                        b.append(Integer.toString(c / 8 % 8));
                        b.append(Integer.toString(c % 8));
                        break;
                    }
                }
            } else if (c == '\\') {
                b.append("\\");
            } else {
                b.append(c);
            }
            ++i;
        }
        return AwkString.valueOf(b.toString());
    }
}

