/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.matrix;

import net.morilib.awk.matrix.AbstractDoubleMatrix;
import net.morilib.awk.matrix.AwkMatrixException;
import net.morilib.awk.matrix.DoubleMatrix;

public abstract class AbstractImmutableDoubleMatrix
extends AbstractDoubleMatrix
implements DoubleMatrix {
    public final void set(int row, int column, double x) throws AwkMatrixException {
        throw new AwkMatrixException("this matrix is immutable");
    }

    public int hashCode() {
        int r = 17;
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r = 31 * (r + (int)Double.doubleToLongBits(this.get(i, j)));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractImmutableDoubleMatrix) {
            DoubleMatrix y = (DoubleMatrix)o;
            if (this.rowSize() != y.rowSize() || this.columnSize() != y.columnSize()) {
                return false;
            }
            int i = 0;
            while (i < this.rowSize()) {
                int j = 0;
                while (j < this.columnSize()) {
                    if (this.get(i, j) != y.get(i, j)) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

