/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.value;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.morilib.awk.AwkCastException;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwkArray
extends AwkValue {
    private Map<String, AwkValue> map = new TreeMap<String, AwkValue>();

    public AwkArray() {
    }

    public AwkArray(int x, String ... s) {
        this();
        int i = 0;
        while (i < s.length) {
            this.map.put(Integer.toString(i + x), AwkString.valueOf(s[i]));
            ++i;
        }
    }

    public AwkArray(AwkValue v) {
        this();
        if (v.isArray()) {
            this.map.putAll(v.map());
        } else {
            this.map.put("1", v);
        }
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    public boolean isFloatValue() {
        return false;
    }

    @Override
    public boolean isIntegerValue() {
        return false;
    }

    @Override
    public boolean isRealValue() {
        return false;
    }

    @Override
    public boolean isNegativeValue() {
        return false;
    }

    @Override
    public boolean isPositiveValue() {
        return false;
    }

    @Override
    public boolean isZeroValue() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isRegex() {
        return false;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean toBoolean() {
        for (AwkValue v : this.values()) {
            if (v.toBoolean()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object toObject() {
        return new TreeMap<String, AwkValue>(this.map);
    }

    @Override
    public AwkValue referArray(String v) {
        AwkValue w = this.map.get(v);
        return w != null ? w : AwkUndefined.UNDEF;
    }

    @Override
    public AwkValue putArray(String k, AwkValue v) {
        return this.map.put(k, v);
    }

    @Override
    public boolean contains(String k) {
        return this.map.containsKey(k);
    }

    @Override
    public AwkValue deleteArray(String v) {
        return this.map.remove(v);
    }

    @Override
    public Set<String> keys() {
        return this.map.keySet();
    }

    @Override
    public Collection<AwkValue> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, AwkValue>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Map<String, AwkValue> map() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public AwkArray toArray() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        for (AwkValue v : this.values()) {
            if (v.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(AwkValue o, AwkNamespace ns) {
        throw new AwkCastException(this + " is not comparable");
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AwkArray) {
            return this.map.equals(((AwkArray)o).map);
        }
        return false;
    }

    @Override
    public String toString(AwkNamespace ns) {
        return this.map.toString();
    }
}

