/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.value;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkString
extends AwkValue {
    public static final AwkString EMPTY = new AwkString("");
    private static final Pattern PFL = Pattern.compile("[-+]?([0-9]+(\\.[0-9]+)?|\\.[0-9]+)([eE][-+]?[0-9]+)?");
    private static final Pattern PIT = Pattern.compile("[-+]?[0-9]+");
    private String value;

    private AwkString(String s) {
        this.value = s;
    }

    public static AwkString valueOf(String s) {
        return new AwkString(s);
    }

    public double toFloat() {
        Matcher m = PFL.matcher(this.value);
        if (m.lookingAt()) {
            return Double.parseDouble(m.group().replaceFirst("^\\+", ""));
        }
        return 0.0;
    }

    public BigInteger toInteger() {
        Matcher m = PIT.matcher(this.value);
        if (m.lookingAt()) {
            return new BigInteger(m.group().replaceFirst("^\\+", ""));
        }
        return BigInteger.ZERO;
    }

    public Number toReal() {
        try {
            return new BigInteger(this.value.replaceFirst("^\\+", ""));
        }
        catch (NumberFormatException e) {
            return this.toFloat();
        }
    }

    public boolean toBoolean() {
        return !this.value.equals("");
    }

    public Pattern toRegex() {
        return Pattern.compile(this.value);
    }

    public Object toObject() {
        return this.value;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isReal() {
        return false;
    }

    public boolean isFloatValue() {
        try {
            Double.parseDouble(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isIntegerValue() {
        try {
            new BigInteger(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isRealValue() {
        return this.isFloatValue() || this.isIntegerValue();
    }

    public boolean isNegativeValue() {
        try {
            return new BigInteger(this.value).signum() < 0;
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(this.value) < 0.0;
            }
            catch (NumberFormatException f) {
                return false;
            }
        }
    }

    public boolean isPositiveValue() {
        try {
            return new BigInteger(this.value).signum() > 0;
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(this.value) > 0.0;
            }
            catch (NumberFormatException f) {
                return false;
            }
        }
    }

    public boolean isZeroValue() {
        try {
            return new BigInteger(this.value).signum() == 0;
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(this.value) == 0.0;
            }
            catch (NumberFormatException f) {
                return false;
            }
        }
    }

    public boolean isString() {
        return true;
    }

    public boolean isRegex() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isEmpty() {
        return this.value.equals("");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AwkString) {
            return this.value.equals(((AwkString)o).value);
        }
        return false;
    }

    public String toString(AwkNamespace ns) {
        return this.value;
    }

    public int compareTo(AwkValue o, AwkNamespace ns) {
        if (o instanceof AwkUndefined) {
            return 1;
        }
        return this.value.compareTo(o.toString(ns));
    }
}

