/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.c.pre.directive;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.c.pre.CPreprocessorReader;
import net.morilib.c.pre.CpreMacros;
import net.morilib.c.pre.CpreSyntaxException;
import net.morilib.c.pre.directive.CpreDirective;
import net.morilib.c.pre.directive.CpreIfState;
import net.morilib.c.pre.expr.CpreExpression;
import net.morilib.c.pre.expr.CpreValue;
import net.morilib.c.pre.parser.CpreLexer;
import net.morilib.c.pre.parser.CpreParser;

public class CpreElif
implements CpreDirective {
    static final Pattern PI1 = Pattern.compile("(.*)[ \t]*");

    public CpreIfState execute(CpreMacros macros, String line, int ln, CpreIfState stat) {
        Matcher m = PI1.matcher(line);
        if (!m.matches()) {
            throw new RuntimeException();
        }
        if (stat.isTopLevel()) {
            throw new CpreSyntaxException(ln, "this directive must follow #if");
        }
        if (stat.isDone()) {
            throw new CpreSyntaxException(ln, "this directive must not follow #else");
        }
        if (stat.isProcessing() || stat.isProcessed()) {
            return CpreIfState.PROCESSED;
        }
        try {
            String s = CPreprocessorReader.substitute(m.group(1), ln, macros);
            StringReader r = new StringReader(s);
            CpreExpression e = CpreParser.parseExpression(new CpreLexer(ln, r));
            CpreValue v = e.eval(ln, macros);
            return v.toBoolean() ? CpreIfState.PROCESSING : CpreIfState.UNPROCESSED;
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }
}

