/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.a;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class ArrayIntersect extends AwkFunction {

	protected ArrayIntersect() {
		super("intersect", null);
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		Iterator<Map.Entry<String, AwkValue>> j;
		AwkValue b;
		AwkArray r;

		if(args.size() < 1) {
			return AwkUndefined.UNDEF;
		} else if(args.size() < 2) {
			return args.get(0);
		} else {
			r = new AwkArray(args.get(0));
			for(int i = 1; i < args.size(); i++) {
				if(r.size() == 0) {
					return r;
				} else if((b = args.get(i)).isArray()) {
					j = r.entrySet().iterator();
					while(j.hasNext()) {
						if(!b.contains(j.next().getKey())) {
							j.remove();
						}
					}
				}
			}
			return r;
		}
	}

}
