/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.a;

import java.util.ArrayList;
import java.util.List;

import net.morilib.awk.AwkRuntimeException;
import net.morilib.awk.builtin.AwkBinaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class ArrayMakelist extends AwkBinaryArgs {

	protected ArrayMakelist() {
		super("makelist");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2) {
		List<AwkValue> l = new ArrayList<AwkValue>();
		AwkValue r = new AwkArray();
		int rep;

		if((rep = a1.toIntExact()) < 0) {
			throw new AwkRuntimeException(
					"nonnegative integer required");
		} else if(a2 instanceof AwkFunction) {
			l.add(null);
			for(int i = 1; i <= rep; i++) {
				l.set(0, AwkInteger.valueOf(i));
				r.putArray(i + "", ((AwkFunction)a2).apply(ns, o, l));
			}
		} else {
			for(int i = 1; i <= rep; i++)  r.putArray(i + "", a2);
		}
		return r;
	}

}
