/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.s;

import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

public class SDump extends AwkUnaryArgs {

	protected SDump() {
		super("dump");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		StringBuffer b = new StringBuffer();
		String s = a1.toString(ns);
		int c;

		for(int i = 0; i < s.length(); i++) {
			if(Character.isISOControl(c = s.charAt(i))) {
				b.append('\\');
				switch(c) {
				case 0x07:  b.append('a');  break;
				case 0x08:  b.append('b');  break;
				case 0x09:  b.append('t');  break;
				case 0x0a:  b.append('n');  break;
				case 0x0b:  b.append('v');  break;
				case 0x0c:  b.append('f');  break;
				case 0x0d:  b.append('r');  break;
				default:
					b.append(Integer.toString((c / 64) % 8));
					b.append(Integer.toString((c /  8) % 8));
					b.append(Integer.toString(c % 8));
					break;
				}
			} else if(c == '\\') {
				b.append("\\");
			} else {
				b.append((char)c);
			}
		}
		return AwkString.valueOf(b.toString());
	}

}
