/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.s;

import java.math.BigInteger;

import net.morilib.awk.AwkRuntimeException;
import net.morilib.awk.builtin.AwkBinaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class SParseint extends AwkBinaryArgs {

	protected SParseint() {
		super("tostring");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2) {
		String s = a1.toString(ns);
		int c = a2 instanceof AwkUndefined ? 10 : a2.toIntExact();

		if(c < 2) {
			throw new AwkRuntimeException("radix must be more than 2");
		} else if(c > 36) {
			throw new AwkRuntimeException(
					"radix must be less than 36");
		} else {
			try {
				s = s.replaceFirst("^\\+", "");
				return AwkInteger.valueOf(new BigInteger(s, c));
			} catch(NumberFormatException e) {
				return AwkUndefined.UNDEF;
			}
		}
	}

}
