/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.matrix;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/09/19
 */
public interface DoubleMatrix {

	/**
	 * 
	 * @param row
	 * @param column
	 * @return
	 */
	public double get(int row, int column);

	/**
	 * 
	 * @param row
	 * @param column
	 * @param x
	 */
	public void set(int row, int column, double x);

	/**
	 * 
	 * @return
	 */
	public int rowSize();

	/**
	 * 
	 * @return
	 */
	public int columnSize();

	/**
	 * 
	 * @param column
	 * @return
	 */
	public DoubleVector getRowVector(int row);

	/**
	 * 
	 * @param row
	 * @return
	 */
	public DoubleVector getColumnVector(int column);

	/**
	 * 
	 * @param n
	 * @return
	 */
	public DoubleMatrix mul(double a);

	/**
	 * 
	 * @param a
	 * @return
	 */
	public DoubleMatrix add(DoubleMatrix a);

	/**
	 * 
	 * @param a
	 * @return
	 */
	public DoubleMatrix sub(DoubleMatrix a);

	/**
	 * 
	 * @return
	 */
	public DoubleMatrix uminus();

	/**
	 * 
	 * @param a
	 * @return
	 * @throws AwkMatrixException
	 */
	public DoubleMatrix mul(DoubleMatrix a);

	/**
	 * 
	 * @param a
	 * @return
	 * @throws AwkMatrixException
	 */
	public DoubleVector mul(DoubleVector a);

	/**
	 * 
	 * @return
	 * @throws AwkMatrixException
	 */
	public double determinant();

	/**
	 * 
	 * @return
	 * @throws AwkMatrixException
	 */
	public DoubleMatrix inv();

	/**
	 * 
	 * @param rowp
	 * @param colp
	 * @return
	 */
	public DoubleMatrix changeRow(Permutation rowp);

	/**
	 * 
	 * @param rowp
	 * @param colp
	 * @return
	 */
	public DoubleMatrix changeColumn(Permutation colp);

	/**
	 * 
	 * @param rowb
	 * @param rowe
	 * @param colb
	 * @param cole
	 * @return
	 */
	public DoubleMatrix submatrix(int rowb, int rowe, int colb,
			int cole);

	/**
	 * 
	 * @param y
	 * @return
	 */
	public boolean isEqualTo(DoubleMatrix y);

}
