/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin;

import java.math.BigInteger;
import net.morilib.awk.builtin.AwkMathFunction2;
import net.morilib.awk.misc.Math2;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class AwkSqrt
extends AwkMathFunction2 {
    protected AwkSqrt() {
        super("sqrt");
    }

    protected double f(double x) {
        return Math.sqrt(x);
    }

    protected AwkValue f(BigInteger x) {
        if (x.signum() < 0) {
            return AwkFloat.valueOf(Double.NaN);
        }
        BigInteger[] q = Math2.sqrtExact2(x);
        if (q[1].signum() == 0) {
            return AwkInteger.valueOf(q[0]);
        }
        return AwkFloat.valueOf(Math.sqrt(x.doubleValue()));
    }
}

