/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.morilib.awk.builtin.AwkRand;
import net.morilib.awk.stat.dist.ContinuousDistribution;
import net.morilib.awk.stat.dist.DiscreteDistribution;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public final class AwkStatUtils {
    public static double[] toDoubleArray(AwkValue a) {
        int j = 0;
        ArrayList<Double> v = new ArrayList<Double>();
        int i = 1;
        while (a.referArray(String.valueOf(i)).isRealValue()) {
            v.add(a.referArray(String.valueOf(i)).toFloat());
            ++i;
        }
        double[] x = new double[v.size()];
        j = 0;
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            x[j++] = d;
        }
        return x;
    }

    public static double[] toDoubleValues(AwkValue a) {
        int j = 0;
        Collection<AwkValue> z = a.values();
        ArrayList<Double> v = new ArrayList<Double>();
        for (AwkValue b : z) {
            if (!b.isRealValue()) continue;
            v.add(b.toFloat());
        }
        double[] x = new double[v.size()];
        j = 0;
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            x[j++] = d;
        }
        return x;
    }

    public static AwkValue generateRandom(ContinuousDistribution dist) {
        double x = AwkRand.RANDOM.nextDouble1Closed();
        x = dist.invCdf(x);
        return AwkFloat.valueOf(x);
    }

    public static AwkValue generateRandoms(ContinuousDistribution dist, int n) {
        AwkArray r = new AwkArray();
        int i = 0;
        while (i < n) {
            double x = AwkRand.RANDOM.nextDouble1Closed();
            x = dist.invCdf(x);
            r.putArray(String.valueOf(i + 1), AwkFloat.valueOf(x));
            ++i;
        }
        return r;
    }

    public static AwkValue generateRandom(DiscreteDistribution dist) {
        double x = AwkRand.RANDOM.nextDouble1Closed();
        return AwkInteger.valueOf(dist.invCdf(x));
    }

    public static AwkValue generateRandoms(DiscreteDistribution dist, int n) {
        AwkArray r = new AwkArray();
        int i = 1;
        while (i <= n) {
            double x = AwkRand.RANDOM.nextDouble1Closed();
            r.putArray(String.valueOf(i), AwkInteger.valueOf(dist.invCdf(x)));
            ++i;
        }
        return r;
    }
}

