/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OSInfo {
    UNKNOWN(0),
    LINUX(256),
    AIX(257),
    HP_UX(258),
    MAC_OS_X(259),
    FREE_BSD(320),
    OPEN_BSD(321),
    NET_BSD(322),
    SOLARIS(384),
    SUN_OS(385),
    OTHER_WINDOWS(512),
    WINDOWS_XP(513),
    WINDOWS_VISTA(514),
    WINDOWS_7(515),
    WINDOWS_2003_SERVER(640),
    WINDOWS_2008_SERVER(641),
    CLASSIC_MAC(768);

    public static final OSInfo OS;
    private int code;

    static {
        String osn = System.getProperty("os.name");
        String osv = System.getProperty("os.version");
        OS = osn.startsWith("Linux") || osn.startsWith("LINUX") ? LINUX : (osn.startsWith("AIX") ? AIX : (osn.startsWith("HP-UX") ? HP_UX : (osn.startsWith("Mac OS X") ? MAC_OS_X : (osn.startsWith("Mac") ? CLASSIC_MAC : (osn.startsWith("FreeBSD") ? FREE_BSD : (osn.startsWith("OpenBSD") ? OPEN_BSD : (osn.startsWith("NetBSD") ? NET_BSD : (osn.startsWith("Solaris") ? SOLARIS : (osn.startsWith("SunOS") ? SUN_OS : (osn.startsWith("Windows Server 2008") ? WINDOWS_2008_SERVER : (osn.startsWith("Windows") ? (osv.startsWith("5.1") ? WINDOWS_XP : (osv.startsWith("5.2") ? WINDOWS_2003_SERVER : (osv.startsWith("6.0") ? WINDOWS_VISTA : (osv.startsWith("6.1") ? WINDOWS_7 : OTHER_WINDOWS)))) : UNKNOWN)))))))))));
    }

    private OSInfo(int code) {
        this.code = code;
    }

    public boolean isUNIX() {
        return (this.code & 0xFF00) == 256;
    }

    public boolean isWindows() {
        return (this.code & 0xFF00) == 512;
    }

    public boolean isWindowsServer() {
        return this.isWindows() && (this.code & 0x80) == 128;
    }

    public boolean isClassicMac() {
        return (this.code & 0xFF00) == 768;
    }

    public boolean isMac() {
        return this.isClassicMac() || this.equals((Object)MAC_OS_X);
    }

    public boolean isBSD() {
        return (this.code & 0xC0) == 64;
    }

    public boolean isSunOS() {
        return (this.code & 0xC0) == 128;
    }

    public boolean hasShell() {
        return this.isUNIX() || this.isWindows();
    }

    public String getOptionString() {
        if (this.isUNIX()) {
            return "-";
        }
        if (this.isWindows()) {
            return "/";
        }
        return null;
    }

    public String getStandardShell() {
        if (this.equals((Object)LINUX)) {
            return "bash";
        }
        if (this.isUNIX()) {
            return "sh";
        }
        if (this.isWindows()) {
            return "cmd";
        }
        return null;
    }
}

