/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist.discrete;

import java.math.BigInteger;
import net.morilib.awk.stat.dist.AbstractDiscreteDistribution;
import net.morilib.awk.stat.special.Beta;
import net.morilib.awk.stat.special.Gamma;

public class BinomialDistribution
extends AbstractDiscreteDistribution {
    private BigInteger trial;
    private double succeed;

    public BinomialDistribution(BigInteger trial, double succeed) {
        if (trial == null) {
            throw new NullPointerException();
        }
        if (trial.signum() <= 0) {
            throw new IllegalArgumentException();
        }
        if (succeed < 0.0 || succeed > 1.0) {
            throw new IllegalArgumentException();
        }
        this.trial = trial;
        this.succeed = succeed;
    }

    public BigInteger getTrial() {
        return this.trial;
    }

    public double getSucceed() {
        return this.succeed;
    }

    public double f(int x) {
        double n = this.trial.doubleValue();
        double p = this.succeed;
        double k = x;
        if (!this.isInSupport(x)) {
            return 0.0;
        }
        double lb = Gamma.lnGamma(n + 1.0);
        double lp = k * Math.log(p) + (n - k) * Math.log(1.0 - p);
        return Math.exp((lb -= Gamma.lnGamma(k + 1.0) + Gamma.lnGamma(n - k + 1.0)) + lp);
    }

    public double cdf(double k) {
        double n = this.trial.doubleValue();
        double p = this.succeed;
        if (k < 0.0) {
            return 0.0;
        }
        if (k >= this.trial.doubleValue()) {
            return 1.0;
        }
        double l = Math.floor(k);
        double r = Beta.I(1.0 - p, n - l, 1.0 + l);
        double a = Beta.I(1.0 - p - 0.001, n - l, 1.0 + l);
        double b = Beta.I(1.0 - p + 0.001, n - l, 1.0 + l);
        if (Double.isNaN(r) || a < r && r > b || a > r && r < b) {
            return (a + b) / 2.0;
        }
        return r;
    }

    public boolean isInSupport(int n) {
        return n >= 0 && (double)n <= this.trial.doubleValue();
    }

    public double expectedValue() {
        return this.succeed * this.trial.doubleValue();
    }

    public double variance() {
        return this.succeed * this.trial.doubleValue() * (1.0 - this.succeed);
    }

    public double mode() {
        return Math.floor(this.succeed * (this.trial.doubleValue() + 1.0));
    }

    public double skewness() {
        double n = this.trial.doubleValue();
        double p = this.succeed;
        return (1.0 - 2.0 * p) / Math.sqrt(n * p * (1.0 - p));
    }

    public double kurtosis() {
        double n = this.trial.doubleValue();
        double p = this.succeed;
        return (1.0 - 6.0 * p * (1.0 - p)) / (n * p * (1.0 - p));
    }

    public int supportMinimum() {
        return 0;
    }

    public int supportMaximum() {
        return 0x7FFFFFFE;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (this.trial.hashCode() + r);
        r = 37 * ((int)Double.doubleToLongBits(this.succeed) + r);
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof BinomialDistribution) {
            BinomialDistribution d = (BinomialDistribution)o;
            return this.trial.equals(d.trial) && this.succeed == d.succeed;
        }
        return false;
    }
}

