/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist;

import net.morilib.awk.stat.DoubleTransform;
import net.morilib.awk.stat.MonotonicFunctions;
import net.morilib.awk.stat.dist.ContinuousDistribution;

public abstract class AbstractContinuousDistribution
implements ContinuousDistribution {
    public final DoubleTransform cumulative = new DoubleTransform(){

        public double f(double x) {
            return AbstractContinuousDistribution.this.cdf(x);
        }
    };

    public double cdf(double x1, double x2) {
        return this.cdf(x2) - this.cdf(x1);
    }

    public double invCdf(double p) {
        if (p == 1.0) {
            return this.supportSupremum();
        }
        if (p == 0.0) {
            return this.supportInfimum();
        }
        if (0.0 < p && p < 1.0) {
            return MonotonicFunctions.findRootByBisectionMethod(this.cumulative, p, this.supportInfimum(), this.supportSupremum());
        }
        return Double.NaN;
    }

    public double median() {
        return this.invCdf(0.5);
    }
}

