/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed;

public class SedSubstituteFlags {
    boolean global = false;
    boolean print = false;
    boolean caseInsensitive = false;
    boolean allmatch = false;
    String desc;
    String fileToWrite = null;
    int number = -1;

    void init(String s) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == 'g') {
                this.global = true;
            } else if (c >= '0' && c <= '9') {
                while (i < s.length()) {
                    c = s.charAt(i);
                    if (c < '0' || c > '9') break;
                    b.append(c);
                    ++i;
                }
                this.number = Integer.parseInt(b.toString());
            } else if (c == 'p') {
                this.print = true;
            } else {
                if (c == 'w') {
                    this.fileToWrite = s.substring(i + 1);
                    return;
                }
                if (c == 'i') {
                    this.caseInsensitive = true;
                } else if (c == 'm') {
                    this.allmatch = true;
                }
            }
            ++i;
        }
    }

    public SedSubstituteFlags(String flags) {
        this.desc = flags;
        this.init(flags);
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isPrint() {
        return this.print;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public String getFileToWrite() {
        return this.fileToWrite;
    }

    public boolean isAllmatch() {
        return this.allmatch;
    }

    public int getNumber() {
        return this.number;
    }

    public int hashCode() {
        int r = 17;
        r = r * 37 + (this.global ? 1 : 0);
        r = r * 37 + (this.print ? 1 : 0);
        r = r * 37 + (this.caseInsensitive ? 1 : 0);
        r = r * 37 + (this.fileToWrite == null ? 0 : this.fileToWrite.hashCode());
        r = r * 37 + (this.number < 0 ? -1 : this.number);
        return r;
    }

    private static boolean eq(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object o) {
        if (o instanceof SedSubstituteFlags) {
            SedSubstituteFlags f = (SedSubstituteFlags)o;
            return this.global == f.global && this.print == f.print && this.caseInsensitive == f.caseInsensitive && SedSubstituteFlags.eq(this.fileToWrite, f.fileToWrite) && this.number < 0 ? f.number < 0 : this.number == f.number;
        }
        return false;
    }

    public String toString() {
        return this.desc;
    }
}

