/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTrees;
import net.morilib.sh.misc.XtraceStream;
import net.morilib.unix.glob.Wildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShPattern {
    private List<ShToken> patterns;

    public ShPattern(List<ShToken> patterns) {
        this.patterns = new ArrayList<ShToken>(patterns);
    }

    public boolean matches(ShEnvironment env, ShFileSystem fs, ShRuntime run, PrintStream err, XtraceStream p, String s) throws IOException, ShSyntaxException {
        for (ShToken t : this.patterns) {
            String v = ShTrees.substituteCase(env, run, fs, err, p, t);
            if (!Wildcard.matches(v, s)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        String d = "";
        for (ShToken t : this.patterns) {
            b.append(d).append(t);
            d = "|";
        }
        return b.toString();
    }
}

