/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShOSProcess
implements ShProcess {
    private static final int BUFSIZE = 1024;
    private ProcessBuilder builder;

    public ShOSProcess(ProcessBuilder builder) {
        this.builder = builder;
    }

    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
        Thread ot = null;
        Thread er = null;
        try {
            Process p = this.builder.start();
            ot = new InThread(p.getInputStream(), stdout);
            er = new InThread(p.getInputStream(), stdout);
            ot.start();
            er.start();
            int n = p.waitFor();
            return n;
        }
        catch (BException ex) {
            throw ex.ioex;
        }
        catch (InterruptedException e) {
            return 255;
        }
        finally {
            try {
                if (ot != null) {
                    ot.join();
                }
                if (er != null) {
                    er.join();
                }
                stdout.flush();
                stderr.flush();
            }
            catch (InterruptedException e) {
                return 255;
            }
        }
    }

    static class BException
    extends RuntimeException {
        IOException ioex;

        public BException(IOException t) {
            this.ioex = t;
        }
    }

    static class InThread
    extends Thread {
        private InputStream src;
        private OutputStream dest;

        InThread(InputStream src, OutputStream dest) {
            this.src = src;
            this.dest = dest;
        }

        public void run() {
            byte[] b = new byte[1024];
            try {
                int l;
                while ((l = this.src.read(b)) >= 0) {
                    this.dest.write(b, 0, l);
                }
            }
            catch (IOException e) {
                throw new BException(e);
            }
        }
    }
}

