/**
    SDL_string - using strings in SDL
    Copyright (C) 2003-2006 kr2.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp

    mst
    mist.engine@gmail.com
*/

#ifdef SAVE_RCSID
static char rcsid =
"@(#) $Id: SDL_string.h,v 0.0.4 2007/01/13 02:04 mst Exp $";
#endif

#ifndef __SDL_STRING_H__
#define __SDL_STRING_H__

#include <SDL_types.h>
#include <SDL_version.h>

#include <begin_code.h>
/* Set up for C function definitions, even when using C++ */
#ifdef __cplusplus
extern "C" {
#endif

/* Printable format: "%d.%d.%d", MAJOR, MINOR, PATCHLEVEL
*/
#define SDL_STR_MAJOR_VERSION	0
#define SDL_STR_MINOR_VERSION	0
#define SDL_STR_PATCHLEVEL	3

/* This macro can be used to fill a version structure with the compile-time
 * version of the SDL_string library.
 */
#define SDL_STR_VERSION(X)						\
{									\
	(X)->major = SDL_STR_MAJOR_VERSION;				\
	(X)->minor = SDL_STR_MINOR_VERSION;				\
	(X)->patch = SDL_STR_PATCHLEVEL;				\
}

/* Backwards compatibility */
#define STR_MAJOR_VERSION	SDL_STR_MAJOR_VERSION
#define STR_MINOR_VERSION	SDL_STR_MINOR_VERSION
#define STR_PATCHLEVEL		SDL_STR_PATCHLEVEL
#define STR_VERSION(X)		SDL_STR_VERSION(X)

/* The internal format for a string converter object */
typedef struct _STR_SC STR_Conv ;
/* The internal format for a string object */
typedef struct _STR_Object STR_Object ;

/* This function gets the version of the dynamically linked SDL_string library.
   it should NOT be used to fill a version structure, instead you should
   use the SDL_STR_VERSION() macro.
 */
extern DECLSPEC const SDL_version * SDLCALL STR_Linked_Version(void);


/*

	{IɁAȉ̖߈ȊO͑SĕVKɐȂ
	STR_Create
	STR_Substring
	STR_NSubstring
	STR_ConvertFrom

*/

/* 𐶐 */
extern DECLSPEC STR_Object* STR_Create() ;

extern DECLSPEC void SDLCALL STR_Clear (STR_Object* str) ;
extern DECLSPEC int SDLCALL STR_IsEmpty (STR_Object* str) ;
extern DECLSPEC double SDLCALL STR_ToDouble (STR_Object* str) ;

/* Rs[ */
extern DECLSPEC STR_Object* STR_Copy ( STR_Object* dest, STR_Object* src ) ;
/* indexɂ镶Ԃ */
extern DECLSPEC Uint32 STR_CharAt ( STR_Object* str, size_t index ) ;
/* str2str1I邩ׂ */
extern DECLSPEC int STR_EndsWith(STR_Object* str1, STR_Object* str2) ;
/* str2str1n܂邩ׂ */
extern DECLSPEC int STR_StartsWith(STR_Object* str1, STR_Object* str2) ;
/* ̕r */
extern DECLSPEC int STR_CompareTo(STR_Object* str1, STR_Object* str2) ;
/* w肳ꂽƔrēłΐ^ɂȂ */
extern DECLSPEC int STR_Equals(STR_Object* str1, STR_Object* str2) ;
/* oldChar  NEWChar ɕϊԂ */
extern DECLSPEC STR_Object* STR_Replace( STR_Object* dest, Uint32 oldChar,Uint32 NEWChar) ;
extern DECLSPEC STR_Object* STR_NReplace( STR_Object* dest, STR_Object* str1, STR_Object* str2 ) ;

/* str2ŏɏoʒuԂ */
extern DECLSPEC int STR_IndexOf( STR_Object* str1, STR_Object* str2) ;
extern DECLSPEC int STR_NIndexOf( STR_Object* str1, STR_Object* str2, size_t start ) ;

/* str2ŌɏoʒuԂ */
extern DECLSPEC int STR_LastIndexOf(STR_Object* str1, STR_Object* str2) ;
extern DECLSPEC int STR_NLastIndexOf(STR_Object* str1, STR_Object* str2, size_t start) ;

/*
	̈ʒuŌ܂ł̕Ԃ 
	̊֐́AV𐶐邱Ƃɒ
*/
extern DECLSPEC STR_Object* STR_Substring(STR_Object* str1,size_t beginIndex) ;
extern DECLSPEC STR_Object* STR_NSubstring(STR_Object* str1,size_t beginIndex,size_t endIndex) ;

/*  ɕϊlԂ */
extern DECLSPEC STR_Object* STR_ToLowerCase(STR_Object* str) ;
/*  啶ɕϊlԂ */
extern DECLSPEC STR_Object* STR_ToUpperCase(STR_Object* str) ;

/* NULL܂܂ȂԂ */
extern DECLSPEC size_t STR_GetNumberOfChars (STR_Object* str) ;
/* 񂪐HĂ郁̗v̂ */
extern DECLSPEC size_t STR_GetNumberOfBytes (STR_Object* str) ;

/* ̗[󔒂 */
extern DECLSPEC STR_Object* STR_Trim (STR_Object* str) ;

/* str1str2AԂ */
extern DECLSPEC STR_Object* STR_Concat(STR_Object* str1, STR_Object* str2) ;

/* Ro[^̐ */
extern DECLSPEC STR_Conv* STR_CreateConv ( const char* codename ) ;

/*
	Ro[g
	0,sNULL/-1
*/
extern DECLSPEC const char* STR_ConvertTo(STR_Conv* conv,STR_Object* str) ;
extern DECLSPEC STR_Object* STR_ConvertFrom(STR_Conv* conv,STR_Object* dest, const char* src, int len) ;

/* Ends C function definitions when using C++ */
#ifdef __cplusplus
}
#endif
#include "close_code.h"

#endif /* __SDL_STRING_H__ */
