/**
    SDL_string - using strings in SDL
    Copyright (C) 2003-2006 kr2.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp

    mst
    mist.engine@gmail.com
*/
#include "SDL_string.h"

#include <SDL.h>
#include <iconv.h>
#include <gc.h>
#include <string.h>
#ifdef _MSC_VER
#include <memory.h>
#endif

#ifdef _MSC_VER
#pragma comment( lib, "gc.lib")
#pragma comment( lib, "iconv.lib")
#pragma comment( lib, "SDL.lib")
#endif

#ifdef malloc
#undef malloc
#define malloc GC_malloc
#endif
#ifdef realloc
#undef realloc
#define realloc GC_realloc
#endif
#ifdef free
#undef free
#define free
#endif

struct _STR_Object {

	_STR_Object()
	{
		m_buf = NULL ;
		m_len = 0 ;
	}

	~_STR_Object()
	{
		Clear () ;
	}

	// 擾
	const Uint32* Get () const
	{
		return m_buf ;
	}

	// Zbg
	// Zbg
	void Set ( const Uint32* str)
	{
		Clear () ;
		if ( str == NULL ) return ;
		if ( str == m_buf ) return ;
		if ( m_buf != NULL ) free ( m_buf ) ;
		int cnt = 0 ;
		for ( cnt=0; str[cnt]!=0; cnt++ ) ;
		m_buf = (Uint32*)malloc ( sizeof(Uint32)*(cnt+1) ) ;
		memcpy ( m_buf, str, sizeof(Uint32)*(cnt+1) ) ;
		m_len = cnt ;
	}

	void Set ( const Uint32* str, size_t len )
	{
		Clear () ;
		if ( str == NULL ) return ;
		if ( str == m_buf ) return ;
		if ( len == 0 ) return ;
		if ( m_buf != NULL ) delete[] m_buf ;
		m_buf = (Uint32*)malloc( sizeof(Uint32)*(len+1) ) ;
		memcpy ( m_buf, str, sizeof(Uint32)*len ) ;
		m_buf[len] = 0 ;
		m_len = len ;
	}


	void Set ( const STR_Object* str )
	{
		Clear () ;
		if ( str == NULL ) return ;
		if ( str == this ) return ;
		Set ( str->Get(), str->GetNumberOfChars() ) ;
	}

	void Clear ()
	{
		if ( m_len == 0 ) return ;
		if ( m_buf == NULL ) return ;
		if ( m_buf != NULL ) free ( m_buf ) ;
		m_buf = NULL ;
		m_len = 0 ;
	}

	// ̈ʒuɂ镶Ԃ
	Uint32 CharAt ( size_t index ) const
	{
		if ( index<m_len ) return m_buf[index] ;
		return 0 ;
	}

	// ̕ŕ񂪏I邩ׂ 
	int EndsWith(const STR_Object* suffix) const 
	{
		if ( suffix == this ) return 1 ;
		if ( suffix == NULL ) return 0 ;
		size_t slen = suffix->GetNumberOfChars () ;
		if ( suffix->GetNumberOfChars () > GetNumberOfChars () ) return 0 ;
		const Uint32* src = suffix->Get() ;
		if ( src == NULL ) return 0 ;
		if ( memcmp ( &m_buf[m_len-slen], src, slen*sizeof(Uint32) ) ==0 ) return 1 ;
		return 0;
	}

	// ̕ŕ񂪎n܂邩ׂ
	int StartsWith(const STR_Object* prefix) const
	{
		if ( prefix == this ) return 1 ;
		if ( prefix == NULL ) return 0 ;
		size_t slen = prefix->GetNumberOfChars () ;
		if ( prefix->GetNumberOfChars () > GetNumberOfChars () ) return 0 ;
		const Uint32* src = prefix->Get() ;
		if ( src == NULL ) return 0 ;
		if ( memcmp ( m_buf, src, slen*sizeof(Uint32) ) ==0 ) return 1 ;
		return 0; 
	}

	// ̕r
	int CompareTo(const STR_Object* anotherString) const
	{
		if ( anotherString == this ) return 0 ;
		if ( anotherString == NULL ) {
			size_t i ;
			Uint32 sum = 0 ;
			for ( i=0; i<m_len; i++ ) {
				sum += m_buf[i] ;
			}
			return sum ;
		}
		size_t slen = anotherString->GetNumberOfChars ()>m_len?anotherString->GetNumberOfChars ():m_len ;
		const Uint32* src = anotherString->Get() ;
		if ( src == NULL ) {
			size_t i ;
			Uint32 sum = 0 ;
			for ( i=0; i<m_len; i++ ) {
				sum += m_buf[i] ;
			}
			return sum ;
		}
		if ( m_buf == NULL ) {
			size_t i ;
			int sum = 0 ;
			for ( i=0; i<slen; i++ ) {
				sum -= src[i] ;
			}
			return sum ;
		}
		return memcmp ( m_buf, src, slen*sizeof(Uint32) ) ;
	}

	// ŌɁAAԂ
	STR_Object* Concat(const STR_Object* str)
	{
		if ( str == NULL ) return this ;
		size_t slen = str->GetNumberOfChars () ;
		if ( slen == 0 ) return this ;
		Uint32* buf = (Uint32*)malloc ( sizeof(Uint32)*(m_len+slen+1)) ;
		memcpy ( buf, m_buf, m_len*sizeof(Uint32) ) ;
		memcpy ( &buf[m_len], str->Get(), slen*sizeof(Uint32) ) ;
		// NULLŏI[
		buf[m_len+slen] = 0 ;
		Set ( buf ) ;
#if 0
		String* newstr = new String () ;
		newstr->SetUTF8StringConverter ( m_pUTF8StringConverter ) ;
		newstr->SetUTF16StringConverter ( m_pUTF16StringConverter ) ;
		newstr->SetStringConverter ( m_pStringConverter ) ;
		newstr->m_buf = buf ;
		newstr->m_len = m_len+slen ;
#endif
		return this ;
	}

	// w肳ꂽƔrēłΐ^ɂȂ
	int Equals(const STR_Object* string) const
	{
		if ( string == this ) return 1 ;
		size_t slen = string->GetNumberOfChars ();
		if ( slen == 0 && m_len == 0 ) return 1 ;
		if ( slen != m_len ) return 0 ;
		if ( slen == 0 && m_len==0 ) return 1 ;
		if ( slen == 0 ) return 0 ;
		const Uint32* src = string->Get() ;
		if ( memcmp ( m_buf, src, m_len*sizeof(Uint32) ) == 0 ) return 1 ;
		return 0 ;
	}

	// oldChar  NEWChar ɕϊԂ
	STR_Object* Replace(Uint32 oldChar,Uint32 NEWChar)
	{
		if ( m_len == 0 ) return this ;
		size_t i ;
		for ( i=0; i<m_len; i++ ) {
			if ( m_buf[i] ==  oldChar ) m_buf[i] = NEWChar ;
		}
		return this ;
	}

	int IndexOf(const STR_Object* str) const
	{
		return IndexOf ( 0, str ) ;
	}
	// ̕񂪍ŏɏoʒuԂ
	int IndexOf(size_t start, const STR_Object* str) const
	{
		if ( str == NULL ) return -1 ;
		if ( str == this ) return 0 ;
		if ( m_len == 0 ) return -1 ;
		if ( start < 0 ) return -1 ;
		size_t slen = str->GetNumberOfChars () ;
		if ( slen == 0 ) return -1 ;
		if ( start+slen > m_len ) return -1 ;
		const Uint32* src = str->Get () ;
		size_t i ;
		for ( i=start; i<=m_len-slen; i++ ) {
			if ( memcmp ( &m_buf[i], src, slen*sizeof(Uint32) ) == 0 ) return (int)i ; 
		}
		return -1 ;
	}

	int LastIndexOf(const STR_Object* str) const
	{
		return LastIndexOf (0, str) ;
	}
	// ̕񂪍ŌɏoʒuԂ
	int LastIndexOf(size_t start,const STR_Object* str) const
	{
		if ( str == NULL ) return -1 ;
		if ( str == this ) return 0 ;
		if ( m_len == 0 ) return -1 ;
		if ( start < 0 ) return -1 ;
		size_t slen = str->GetNumberOfChars () ;
		if ( slen == 0 ) return -1 ;
		if ( start+slen > m_len ) return -1 ;
		const Uint32* src = str->Get () ;
		int i ;
		for ( i=(int)(m_len-(slen+start)); i>=0; i-- ) {
			if ( memcmp ( &m_buf[i], src, slen*sizeof(Uint32) ) == 0 ) return i ; 
		}
		return -1 ;
	}

	// ̈ʒuŌ܂ł̕Ԃ
	STR_Object* Substring(size_t beginIndex) const
	{
		STR_Object* str = new STR_Object () ;
		if ( beginIndex >=m_len ) return str ;
		if ( m_len == 0 ) return str ;
		str->Set ( &m_buf[beginIndex] ) ;
		return str ;
	}

	STR_Object* Substring(size_t beginIndex,size_t endIndex) const
	{
		STR_Object* str = new STR_Object () ;
		if ( beginIndex >=m_len ) return str ;
		if ( endIndex >=m_len ) return str ;
		if ( beginIndex >= endIndex ) return str ;
		if ( m_len == 0 ) return str ;
		str->Set ( &m_buf[beginIndex], endIndex-beginIndex ) ;
		return str ;
	}

	//  ɕϊlԂ
	STR_Object* ToLowerCase()
	{
		if ( m_len == 0 ) return this ;
		size_t i ;
		for ( i=0; i<m_len; i++ ) {
			if ( 0x41<=m_buf[i] && m_buf[i]<=0x5a ) m_buf[i]+=0x20 ;
		}
		return this ;
	}

	//  啶ɕϊlԂ
	STR_Object* ToUpperCase()
	{
		if ( m_len == 0 ) return this ;
		size_t i ;
		for ( i=0; i<m_len; i++ ) {
			if ( 0x61<=m_buf[i] && m_buf[i]<=0x7a ) m_buf[i]-=0x20 ;
		}
		return this ;
	}

	// NULL܂܂ȂԂ
	size_t GetNumberOfChars () const
	{
		return m_len ;
	}

	// 񂪐HĂ郁̗v̂
	size_t GetNumberOfBytes () const
	{
		return sizeof(Uint32)*m_len ;
	}

	int IsEmpty ()
	{
		if ( m_buf == NULL ) return 1 ;
		return 0 ;
	}

	STR_Object* Replace ( STR_Object* src, STR_Object* dest )
	{
		size_t lastindex = 0 ;
		STR_Object* ret = new STR_Object() ;
		while (1) {
			int index = IndexOf ( lastindex, src ) ;
			if ( index == -1 ) break ;
			*ret += Substring ( lastindex, index ) ;
			*ret += dest ;
			lastindex = index+src->GetNumberOfChars() ;
		}
		if ( lastindex < this->GetNumberOfChars () ) {
			*ret += Substring ( lastindex ) ;
		}
		*this = *ret ;
		return this ;
	}
	// ̗[󔒂
	STR_Object* Trim ()
	{
		if ( m_len == 0 ) return this ;
		size_t i, start=0, end=m_len ; 
		for ( i=0; i<m_len; i++ ) {
			if ( m_buf[i]!=0x20 ) {
				start = i ;
				break ;
			}
		}
		for ( i=m_len-1; i>0; i-- ) {
			if ( m_buf[i]!=0x20 ) {
				end = i ;
				break ;
			}
		}
		if ( start==0 && end==m_len-1 ) return this ;
		STR_Object* str = new STR_Object () ;
		str->Set ( &m_buf[start], (end+1)-start ) ;
		*this = *str ;
		return this ;
	}

	#define TODOUBLE_MAXBUF 100
	double ToDouble ()
	{
		size_t i ;
		char buf[TODOUBLE_MAXBUF+1] ;
		buf[TODOUBLE_MAXBUF] = 0 ;
		size_t max = (TODOUBLE_MAXBUF>m_len)?m_len:TODOUBLE_MAXBUF ;
		for ( i=0; i<max; i++ ) {
			buf[i] = (char)m_buf[i] ;
		}
		return atof ( buf ) ;	
	}

	STR_Object* ValueOf ( bool b ) 
	{
		if ( b ) {
			return ValueOf ( "true" ) ;
		}
		return ValueOf ( "false" ) ;
	}

	STR_Object* ValueOf ( char c ) 
	{
		return ValueOf ( &c, 0, 1 ) ;
	}

	STR_Object* ValueOf ( const char* str ) 
	{
		return ValueOf ( str, 0, (str!=NULL)?strlen ( str ):0 ) ;
	}

	STR_Object* ValueOf ( const char* data, size_t offset, size_t count ) 
	{
		STR_Object* str = new STR_Object () ;
		if ( count == 0 ) return str ;
		if ( data != NULL ) return  str ;
		size_t len = strlen ( data ) ;
		if ( len <= offset ) return str ;
		if ( len < offset+count ) return str ;
		str->m_buf = (Uint32*)malloc( sizeof(Uint32)*(len+1) ) ;
		str->m_len = len ;
		size_t i ;
		for ( i=0; i<count; i++ ) {
			str->m_buf[i] = data[offset+i] ;
		}
		str->m_buf[len] = 0 ;
		return str ;	
	}

	STR_Object* ValueOf ( double d ) 
	{
		char buf[500] ;
		sprintf ( buf, "%lf", d ) ;
		return ValueOf ( buf ) ;
	}

	STR_Object* ValueOf ( float f ) 
	{
		char buf[500] ;
		sprintf ( buf, "%f", f ) ;
		return ValueOf ( buf ) ;
	}

	STR_Object* ValueOf ( int i ) 
	{
		char buf[500] ;
		sprintf ( buf, "%d", i ) ;
		return ValueOf ( buf ) ;
	}

	STR_Object* ValueOf ( long l ) 
	{
		char buf[500] ;
		sprintf ( buf, "%ld", l ) ;
		return ValueOf ( buf ) ;
	}

	STR_Object* operator=( const STR_Object* other )
	{
		Set ( other ) ;
		return this ;
	}

	STR_Object* operator+ ( const STR_Object* other )
	{
		return Concat ( other ) ;
	}

	STR_Object* operator+= ( const STR_Object* other )
	{
		(*this) = (*this)+other ;
		return this ;
	}

	Uint32 *m_buf ;
	size_t m_len ; //! NULL܂܂Ȃ
} ;

struct _STR_SC {
	_STR_SC ()
	{
		SetBufferSize ( 1024 ) ;
		// IȃGfBÃ`FbN
		unsigned int bom = 0xff ;
		unsigned char* cbom = (unsigned char*)&bom ;
		if ( cbom[0] == 0xff ) {
			// gGfBA
			m_btype = 1 ;
		}else if ( cbom[sizeof(int)-1] == 0xff ) {
			m_btype = 0 ;
		}
		m_crule_ic = (iconv_t)(-1) ;
		m_crule_ci = (iconv_t)(-1) ;
	}
	~_STR_SC ()
	{
		if ( m_crule_ic != (iconv_t)(-1) ) {
			iconv_close(m_crule_ic) ;
			m_crule_ic = (iconv_t)-1 ;
		}
		if ( m_crule_ci != (iconv_t)(-1) ) {
			iconv_close(m_crule_ci) ;
			m_crule_ci = (iconv_t)-1 ;
		}
	}

	STR_Object* Convert ( const char* src, size_t len )
	{
		if ( src == NULL ) {
			return 0 ;
		}
		if ( len == 0 ) {
			return 0 ;
		}
		size_t totaloutsize = 0 ;
		size_t outsize = m_bufsize ;
		int retval ;
		size_t insize = len ;
		char* buf = (char*)malloc ( m_bufsize )  ;
		int i=1;
		char* outbuf = buf ;
		size_t oldinsize = insize ;
		for (;;) {
			// ϊ
			retval = (int)iconv ( m_crule_ic, &src, &insize, &outbuf, &outsize ) ;
			// errno⑫łȂꍇ̑΍
			if ( oldinsize == insize ) {
				return NULL ;
			}
			oldinsize = insize ;
			// G[΍
			if ( retval == -1 ) {
				// sSȃ}`oCg񂪊܂܂Ă
				if ( errno == EINVAL ) {
					return NULL ;
				}
				// ȃ}`oCg܂܂ĂB
				if ( errno == EILSEQ ) {
					return NULL ;
				}
				// iconv̑łiconv_ts
				if ( errno == EBADF ) {
					return NULL ;
				}
				if ( errno == E2BIG ) {
				}
			}
			if ( insize == 0 ) break ;
			else {
				// o̓obt@Ȃꍇ̏
				// ovZ
				totaloutsize+=m_bufsize-outsize;
				// obt@̍Ċm
				buf = (char*)realloc ( buf, m_bufsize*++i ) ;
				// o̓obt@|C^ČvZ
				outbuf=&buf[totaloutsize] ;
				// o̓obt@TCYɖ߂
				outsize = m_bufsize; 
			}
		}
		totaloutsize += m_bufsize-outsize ;
		STR_Object* dest = new STR_Object () ;
		dest->Set ( (const unsigned int*)(buf), totaloutsize/sizeof(Uint32) ) ;
		totaloutsize += sizeof(Uint32) ;
		free ( buf ) ;
		return dest ;
	}

	const char* Convert ( STR_Object* src )
	{
		int i=1;
		size_t totaloutsize = 0 ;
		size_t outsize = m_bufsize ;
		int retval ;
		// GetNumberOfBytesNULL܂܂ȂoCgԂ
		// sizeof(Uint32)(NULL)𑫂ĂB
		size_t insize = src->GetNumberOfBytes()+sizeof(Uint32) ;
		const char* inbuf = (const char*)src->Get () ;
		char* buf = (char*)malloc ( m_bufsize ) ;
		char* outbuf = buf ;
		size_t oldinsize = insize ;
		for (;;) {
			// ϊ
			retval = (int)iconv ( m_crule_ci, &inbuf, &insize, &outbuf, &outsize ) ;
			// errno⑫łȂꍇ̑΍
			if ( oldinsize == insize ) {
				return NULL ;
			}
			oldinsize = insize ;
			// G[΍
			if ( retval == -1 ) {
				// sSȃ}`oCg񂪊܂܂Ă
				if ( errno == EINVAL ) {
					return NULL ;
				}
				// ȃ}`oCg܂܂ĂB
				if ( errno == EILSEQ ) {
					return NULL ;
				}
				// iconv̑łiconv_ts
				if ( errno == EBADF ) {
					return NULL ;
				}
				if ( errno == E2BIG ) {
				}
			}
			if ( insize == 0 ) break ;
			else {
				// o̓obt@Ȃꍇ̏
				// ovZ
				totaloutsize+=m_bufsize-outsize;
				// obt@̍Ċm
				buf = (char*)realloc ( buf, m_bufsize*++i ) ;
				// o̓obt@|C^ČvZ
				outbuf=&buf[totaloutsize] ;
				// o̓obt@TCYɖ߂
				outsize = m_bufsize; 
			}
		}
		totaloutsize += m_bufsize-outsize ;
		return buf ;
	}

	/*
		0
		s-1
	*/
	int SetConv ( const char* src )
	{
		if ( src == NULL ) return -1 ;
		if ( m_btype == 1 ) {
			m_crule_ic = iconv_open ( "UTF-32LE", src ) ; 
			m_crule_ci = iconv_open ( src, "UTF-32LE" ) ;
		}else{
			m_crule_ic = iconv_open ( "UTF-32BE", src ) ; 
			m_crule_ci = iconv_open ( src, "UTF-32BE" ) ;
		}
		if ( (m_crule_ic == (iconv_t)(-1))||(m_crule_ci == (iconv_t)(-1)) ) {
			return -1 ;
		}
		return 0 ;
	}

	void SetBufferSize ( size_t bufsize )
	{
		if ( m_bufsize == bufsize ) return ;
		if ( bufsize != 0 ) {
			m_bufsize = bufsize ;
		}
	}

	iconv_t m_crule_ic ;
	iconv_t m_crule_ci ;
	size_t m_bufsize ;
	// BOM
	// 0ȂBig Endian
	// 1ȂLittle Endian
	int m_btype ;
} ;

/* rcg06192001 get linked library's version. */
const SDL_version *STR_Linked_Version(void)
{
	static SDL_version linked_version;
	SDL_STR_VERSION(&linked_version);
	return(&linked_version);
}

STR_Object* STR_Create()
{
	return new STR_Object() ;
}

void SDLCALL STR_Clear (STR_Object* str)
{
	if ( str == NULL ) return ;
	str->Clear () ;
}

int SDLCALL STR_IsEmpty (STR_Object* str)
{
	if ( str == NULL ) return 1 ;
	return str->IsEmpty() ;
}

double SDLCALL STR_ToDouble (STR_Object* str)
{
	if ( str == NULL ) return 0.0 ;
	return str->ToDouble() ;
}


/* Rs[ */
STR_Object* STR_Copy ( STR_Object* dest, STR_Object* src )
{
	if ( dest == NULL ) return 0 ;
	dest->Set(src) ;
	return dest ;
}

/* ̈ʒuɂ镶Ԃ */
Uint32 STR_CharAt ( STR_Object* str, size_t index )
{
	if ( str == NULL ) return 0 ;
	return str->CharAt (index) ;
}

/* ̕ŕ񂪏I邩ׂ */
int STR_EndsWith(STR_Object* str1, STR_Object* str2)
{
	if ( str1 == NULL ) return 0 ;
	return str1->EndsWith ( str2 ) ;
}

/* ̕ŕ񂪎n܂邩ׂ */
int STR_StartsWith(STR_Object* str1, STR_Object* str2)
{
	if ( str1 == NULL ) return 0 ;
	return str1->StartsWith ( str2 ) ;
}

/* ̕r */
int STR_CompareTo(STR_Object* str1, STR_Object* str2)
{
	if ( str1 == NULL ) return -1 ;
	return str1->CompareTo ( str2 ) ;
}

/* w肳ꂽƔrēłΐ^ɂȂ */
int STR_Equals(STR_Object* str1, STR_Object* str2)
{
	if ( str1 == NULL ) return 0 ;
	return str1->Equals(str2) ;
}

/* oldChar  NEWChar ɕϊԂ */
STR_Object* STR_Replace( STR_Object* dest, Uint32 oldChar,Uint32 NEWChar)
{
	if ( dest == NULL ) return NULL ;
	return dest->Replace ( oldChar, NEWChar ) ;
}

STR_Object* STR_NReplace( STR_Object* dest, STR_Object* str1, STR_Object* str2 )
{
	if ( dest == NULL ) return NULL ;
	return dest->Replace ( str1, str2 ) ;
}


/* ̕񂪍ŏɏoʒuԂ */
int STR_IndexOf( STR_Object* str1, STR_Object* str2)
{
	if ( str1 == NULL ) return -1 ;
	return str1->IndexOf(str2) ;
}

int STR_NIndexOf( STR_Object* str1, STR_Object* str2, size_t start )
{
	if ( str1 == NULL ) return -1 ;
	return str1->IndexOf(start, str2) ;
}


/* ̕񂪍ŌɏoʒuԂ */
int STR_LastIndexOf(STR_Object* str1, STR_Object* str2)
{
	if ( str1 == NULL ) return -1 ;
	return str1->LastIndexOf(str2) ;
}

int STR_NLastIndexOf(STR_Object* str1, STR_Object* str2, size_t start)
{
	if ( str1 == NULL ) return -1 ;
	return str1->LastIndexOf(start, str2) ;
}


/* ̈ʒuŌ܂ł̕Ԃ */
STR_Object* STR_Substring(STR_Object* str1,size_t beginIndex)
{
	if ( str1 == NULL ) return NULL ;
	return str1->Substring(beginIndex) ;
}

STR_Object* STR_NSubstring(STR_Object* str1,size_t beginIndex,size_t endIndex)
{
	if ( str1 == NULL ) return NULL ;
	return str1->Substring(beginIndex,endIndex) ;
}


/*  ɕϊlԂ */
STR_Object* STR_ToLowerCase(STR_Object* str)
{
	if ( str == NULL ) return NULL ;
	return str->ToLowerCase() ;
}

/*  啶ɕϊlԂ */
STR_Object* STR_ToUpperCase(STR_Object* str)
{
	if ( str == NULL ) return NULL ;
	return str->ToUpperCase() ;
}


/* NULL܂܂ȂԂ */
size_t STR_GetNumberOfChars (STR_Object* str)
{
	if ( str == NULL ) return 0 ;
	return str->GetNumberOfChars() ;
}

/* 񂪐HĂ郁̗v̂ */
size_t STR_GetNumberOfBytes (STR_Object* str)
{
	if ( str == NULL ) return 0 ;
	return str->GetNumberOfBytes() ;
}


/* ̗[󔒂 */
STR_Object* STR_Trim (STR_Object* str)
{
	if ( str == NULL ) return 0 ;
	return str->Trim() ;
}


/* str1str2AԂ */
STR_Object* STR_Concat(STR_Object* str1, STR_Object* str2)
{
	if ( str1 == NULL ) return NULL ;
	return str1->Concat(str2) ;
}


STR_Conv* STR_CreateConv ( const char* codename )
{
	if ( codename == NULL ) return NULL ;
	STR_Conv* conv = new STR_Conv () ;
	if ( conv == NULL ) return NULL ;
	if ( conv->SetConv ( codename ) != 0 ) {
		delete conv ;
		return NULL ;
	}
	return conv ;
}

/*	Ro[g */
const char* STR_ConvertTo(STR_Conv* conv,STR_Object* str)
{
	if ( conv == NULL ) return NULL ;
	return conv->Convert ( str ) ;
}

STR_Object* STR_ConvertFrom(STR_Conv* conv, const char* src, int len)
{
	if ( conv == NULL ) return NULL ;
	return conv->Convert ( src, len ) ;
}
