#ifndef __SENSORS_BC9_H__
#define __SENSORS_BC9_H__

#define LOG_TAG "bc9Sensors"

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <cutils/log.h>
#include <cutils/sockets.h>
#include <pthread.h>
#include <hardware/sensors.h>

#include <linux/bc9-accelerometer.h>
#include <linux/hmc5843.h>

/**  Logging macros  */
#ifndef _DEBUG 
#define  D(...)  ((void)0)
#else
#define  D(...)  LOGD(__VA_ARGS__)
#endif

#define  E(...)  LOGE(__VA_ARGS__)

/** SENSOR IDS AND NAMES
 **/

#define MAX_NUM_SENSORS 3

#define SUPPORTED_SENSORS  ((1<<MAX_NUM_SENSORS)-1)

#define ID_BASE           SENSORS_HANDLE_BASE
#define ID_ACCELERATION   (ID_BASE+0)
#define ID_MAGNETIC_FIELD (ID_BASE+1)
#define ID_ORIENTATION    (ID_BASE+2)
#define ID_TEMPERATURE    (ID_BASE+3)

#define SENSORS_ACCELERATION    (1 << ID_ACCELERATION)
#define SENSORS_MAGNETIC_FIELD  (1 << ID_MAGNETIC_FIELD)
#define SENSORS_ORIENTATION     (1 << ID_ORIENTATION)
#define SENSORS_TEMPERATURE     (1 << ID_TEMPERATURE)

#define ID_CHECK(x)  ((unsigned)((x)-ID_BASE) < 4)

#define SENSORS_LIST  \
    SENSOR_(ACCELERATION,"acceleration") \
    SENSOR_(MAGNETIC_FIELD,"magnetic-field") \
    SENSOR_(ORIENTATION,"orientation") 
#if 0
    /*  Notice: currently not supported  */ 
    SENSOR_(TEMPERATURE,"temperature") 
#endif

static const struct {
    const char*  name;
    int          id;
} _sensorIds[MAX_NUM_SENSORS] =
{
//
//  {"acceleration", 0},
//  {"magnetic-field", 1},
//  {"orientation", 2},
//  {"temperature", 3},
//
#define SENSOR_(x,y)  { y, ID_##x },
    SENSORS_LIST
#undef  SENSOR_
};

static const char*
_sensorIdToName( int  id )
{
    int  nn;
    for (nn = 0; nn < MAX_NUM_SENSORS; nn++)
        if (id == _sensorIds[nn].id)
            return _sensorIds[nn].name;
    return "<UNKNOWN>";
}

static int
_sensorIdFromName( const char*  name )
{
    int  nn;

    if (name == NULL)
        return -1;

    for (nn = 0; nn < MAX_NUM_SENSORS; nn++)
        if (!strcmp(name, _sensorIds[nn].name))
            return _sensorIds[nn].id;

    return -1;
}

/** SENSORS CONTROL DEVICE
 **
 ** This one is used to send commands to the sensors drivers.
 **/

typedef struct SensorControl {
    struct sensors_control_device_t  device;
    int                              fd;          //  control fd
    int                              accel_fd;    //  accelaremonator
    int                              compass_fd;  //  compass fd 
    int                              event_delay;
    uint32_t                         active_sensors;
    pthread_t                        read_thread;
    int                              already_thread_started;
    int                              force_stop;
} SensorControl;


/** SENSORS DATA DEVICE
 **
 ** This one is used to read sensor data from the hardware.
 **/

typedef struct SensorData {
    struct sensors_data_device_t  device;
    int                           events_fd;
} SensorData;

/** SENSORS VALUE
 **
 ** used to send data between different threads.
 **/

typedef struct SensorValue {
    int            type;
    sensors_data_t data;
} SensorValue;

#endif  //  end of __SENSORS_BC9_H__
